/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HiCOMMENT;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.hi.customized.CommentPanel;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiStatementNodeInt;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class HiCommentObject
extends AbstractUIObject
implements HiStatementNodeInt {
    HiCOMMENT _comment;
    CommentPanel _panel;

    public HiCommentObject() {
        this._comment = this.createComment();
    }

    private HiCOMMENT createComment() {
        HiCOMMENT comment = new HiCOMMENT();
        comment.setOptContent(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HiCommentObject.Comment"));
        return comment;
    }

    public HiCommentObject(HiCOMMENT comment) {
        this._comment = comment;
    }

    @Override
    public DefaultMutableTreeNode[] getTreeNode() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
        return new DefaultMutableTreeNode[]{node};
    }

    public String toString() {
        String content = this._comment.getOptContent();
        if (content == null) {
            return "//";
        }
        return "//" + content;
    }

    @Override
    public JPanel getShowPanel() {
        if (this._panel == null) {
            this._panel = new CommentPanel();
        }
        this._panel.setObject(this);
        return this._panel;
    }

    public boolean setComment(String comment) {
        String oldValue = this.getComment();
        if (PolicyHandler.compareTwoObject(oldValue, comment) == 0) {
            return false;
        }
        this._comment.setOptContent(comment);
        return true;
    }

    public String getComment() {
        return this._comment.getOptContent();
    }

    @Override
    public boolean canAddCondition() {
        return false;
    }

    @Override
    public boolean canAddCommand() {
        return false;
    }

    public HiCOMMENT getHiComment() {
        return this._comment;
    }

    @Override
    public boolean isValid() {
        this._panel.commentChanged();
        return true;
    }

    @Override
    public boolean delete() {
        HiScriptBlock sBlock = (HiScriptBlock)this._comment.getParent();
        sBlock.getParent().removeChild((AbstractSchema)sBlock);
        return false;
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        WashIDHandler washer = new WashIDHandler();
        HashMap<String, TopLevelObject> createdObjSet = new HashMap<String, TopLevelObject>();
        try {
            HiCOMMENT newCall = (HiCOMMENT)washer.duplicateObject((ConfigObject)this._comment, createdObjSet);
            return new HiCommentObject(newCall);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }

    @Override
    public boolean isStatement() {
        return true;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public HiScriptBlock wrapWithABlock() {
        HiScriptBlock sBlock = new HiScriptBlock();
        sBlock.setOptHiCOMMENT(this._comment);
        return sBlock;
    }
}

