/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.HiAND;
import com.sygate.scm.common.configobject.schema.HiCALL;
import com.sygate.scm.common.configobject.schema.HiCONDITION;
import com.sygate.scm.common.configobject.schema.HiConditionBlock;
import com.sygate.scm.common.configobject.schema.HiNOT;
import com.sygate.scm.common.configobject.schema.HiOR;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.HiConditionBlockObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.customized.FunctionPanel;
import com.sygate.scm.console.ui.policy.hi.logicobject.FunctionType;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiConditionNodeInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiNotNodeInt;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiStatementNodeInt;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedType;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class HiCALLObject
extends AbstractUIObject
implements HiNotNodeInt,
HiStatementNodeInt,
HiConditionNodeInt {
    private HiCALL _hicall;
    private FunctionPanel _panel;
    private PhysicalFileObject physicalFileObject;
    private int functionType;
    private String clientType;

    public HiCALLObject(String clientType) {
        this.clientType = clientType;
        this._hicall = this.createHiCall();
    }

    public HiCALLObject(HiCALL call) {
        this._hicall = call;
    }

    private HiCALL createHiCall() {
        HiCALL call = new HiCALL();
        call.setFuncName("     ");
        call.setOptComment("     ");
        UnknownContent unknow = new UnknownContent();
        call.setUnknownContent(unknow);
        unknow.setConent(new byte[]{0});
        return call;
    }

    @Override
    public HiScriptBlock wrapWithABlock() {
        HiScriptBlock sBlock = new HiScriptBlock();
        sBlock.setOptHiCALL(this._hicall);
        return sBlock;
    }

    @Override
    public HiConditionBlock wrapWithBlock() {
        HiConditionBlock block = new HiConditionBlock();
        block.setOptHiCALL(this._hicall);
        return block;
    }

    public String getClientType() {
        if (StringUtilities.isEmpty((String)this.clientType)) {
            return "Windows";
        }
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    @Override
    public boolean delete() {
        AbstractSchema directParent = this._hicall.getParent();
        directParent.getParent().removeChild(directParent);
        if (directParent instanceof HiConditionBlock) {
            HiOR or;
            int count;
            AbstractSchema nextParent = directParent.getParent();
            if (nextParent instanceof HiNOT) {
                HiNOT not = (HiNOT)nextParent;
                HiConditionBlock notBlock = (HiConditionBlock)not.getParent();
                notBlock.getParent().removeChild((AbstractSchema)notBlock);
                directParent = notBlock;
                nextParent = directParent.getParent();
            }
            if (nextParent instanceof HiAND) {
                HiAND and = (HiAND)nextParent;
                int count2 = and.getHiConditionBlockCount();
                if (count2 == 1) {
                    HiConditionBlock andBlock = (HiConditionBlock)and.getParent();
                    HiConditionBlock leftoverBlock = and.getHiConditionBlock(0);
                    if (leftoverBlock.getOptHiAND() != null) {
                        andBlock.setOptHiAND(leftoverBlock.getOptHiAND());
                    } else if (leftoverBlock.getOptHiOR() != null) {
                        andBlock.setOptHiOR(leftoverBlock.getOptHiOR());
                    } else if (leftoverBlock.getOptHiCALL() != null) {
                        andBlock.setOptHiCALL(leftoverBlock.getOptHiCALL());
                    } else if (leftoverBlock.getOptHiNOT() != null) {
                        andBlock.setOptHiNOT(leftoverBlock.getOptHiNOT());
                    }
                    and.getParent().removeChild((AbstractSchema)and);
                    return true;
                }
            } else if (nextParent instanceof HiOR && (count = (or = (HiOR)nextParent).getHiConditionBlockCount()) == 1) {
                HiConditionBlock andBlock = (HiConditionBlock)or.getParent();
                HiConditionBlock leftoverBlock = or.getHiConditionBlock(0);
                if (leftoverBlock.getOptHiAND() != null) {
                    andBlock.setOptHiAND(leftoverBlock.getOptHiAND());
                } else if (leftoverBlock.getOptHiOR() != null) {
                    andBlock.setOptHiOR(leftoverBlock.getOptHiOR());
                } else if (leftoverBlock.getOptHiCALL() != null) {
                    andBlock.setOptHiCALL(leftoverBlock.getOptHiCALL());
                } else if (leftoverBlock.getOptHiNOT() != null) {
                    andBlock.setOptHiNOT(leftoverBlock.getOptHiNOT());
                }
                or.getParent().removeChild((AbstractSchema)or);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Object comment = this._hicall.getOptComment();
        comment = comment == null ? "    " : comment;
        AbstractSchema directParent = this._hicall.getParent();
        if (directParent instanceof HiConditionBlock) {
            HiAND and;
            Vector allBlocks;
            int index;
            AbstractSchema nextParent = directParent.getParent();
            if (nextParent instanceof HiNOT) {
                comment = "NOT " + (String)comment;
                directParent = nextParent.getParent();
                if (directParent != null) {
                    nextParent = directParent.getParent();
                }
            }
            if (nextParent != null && nextParent instanceof HiAND && (index = (allBlocks = (and = (HiAND)nextParent).getHiConditionBlock()).indexOf(directParent)) != 0) {
                comment = "AND " + (String)comment;
            }
            if (nextParent != null && nextParent instanceof HiOR && (index = (allBlocks = (and = (HiOR)nextParent).getHiConditionBlock()).indexOf(directParent)) != 0) {
                comment = "OR " + (String)comment;
            }
        }
        return comment;
    }

    @Override
    public DefaultMutableTreeNode[] getTreeNode() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
        return new DefaultMutableTreeNode[]{node};
    }

    @Override
    public JPanel getShowPanel() {
        if (this._panel == null) {
            this._panel = new FunctionPanel();
        }
        this._panel.setObject(this);
        return this._panel;
    }

    @Override
    public boolean canAddCondition() {
        return false;
    }

    @Override
    public boolean canAddCommand() {
        return false;
    }

    public HiCALL getHiCall() {
        return this._hicall;
    }

    public void setFunctionType(FunctionType ctype) throws ConsoleException {
        this._hicall.setFuncName(ctype.getFuncName());
        this._hicall.setOptComment(ctype.getTypeDesc());
        UnknownContent unknow = new UnknownContent();
        try {
            unknow.setConent(ctype.getParameter());
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        this._hicall.setUnknownContent(unknow);
        this.functionType = ctype.getType();
    }

    public void setFunctionType(PredefinedType ptype) throws ConsoleException {
        this._hicall.setFuncName(ptype.getFuncName());
        UnknownContent unknow = new UnknownContent();
        try {
            unknow.setConent(ptype.getParameter());
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        this._hicall.setUnknownContent(unknow);
    }

    public UnknownContent getParameter() {
        return this._hicall.getUnknownContent();
    }

    public String getFuncName() {
        return this._hicall.getFuncName();
    }

    public void setParameter(ConfigObject osObj) throws ConsoleException {
        try {
            byte[] content = osObj.getBytes();
            UnknownContent unknown = this._hicall.getUnknownContent();
            unknown.setConent(content);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }

    @Override
    public boolean isValid() throws GUICheckException {
        boolean valid;
        String funcName = this.getFuncName();
        boolean bl = valid = funcName.trim().length() > 0;
        if (!valid) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HiCALLObject.errMsgFunctionNameIsEmpty"));
        }
        valid = this._panel.checkValidation();
        return valid;
    }

    public boolean usedAsCondition() {
        AbstractSchema parent = this._hicall.getParent();
        return parent instanceof HiCONDITION || parent instanceof HiConditionBlock;
    }

    @Override
    public void setNotCondition() {
        AbstractSchema directParent = this._hicall.getParent();
        if (directParent instanceof HiConditionBlock) {
            AbstractSchema nextParent = directParent.getParent();
            if (nextParent instanceof HiNOT) {
                HiNOT not = (HiNOT)nextParent;
                HiConditionBlock notParent = (HiConditionBlock)not.getParent();
                notParent.setOptHiCALL(this._hicall);
                notParent.setOptHiNOT(null);
            } else {
                HiNOT not = new HiNOT();
                HiConditionBlock notBlock = new HiConditionBlock();
                notBlock.setOptHiCALL(this._hicall);
                not.setHiConditionBlock(notBlock);
                HiConditionBlock thisBlock = (HiConditionBlock)directParent;
                thisBlock.setOptHiNOT(not);
                thisBlock.setOptHiCALL(null);
            }
        }
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        WashIDHandler washer = new WashIDHandler();
        HashMap<String, TopLevelObject> createdObjSet = new HashMap<String, TopLevelObject>();
        try {
            AbstractSchema nextParent;
            AbstractSchema parent = this._hicall.getParent();
            if (parent instanceof HiConditionBlock && (nextParent = parent.getParent()) instanceof HiNOT) {
                HiConditionBlock notBlock = (HiConditionBlock)nextParent.getParent();
                HiConditionBlock newCall = (HiConditionBlock)washer.duplicateObject((ConfigObject)notBlock, createdObjSet);
                return new HiConditionBlockObject(newCall);
            }
            HiCALL newCall = (HiCALL)washer.duplicateObject((ConfigObject)this._hicall, createdObjSet);
            return new HiCALLObject(newCall);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }

    @Override
    public boolean isStatement() {
        String funcName = this._hicall.getFuncName();
        return FunctionType.isStatement(funcName);
    }

    @Override
    public boolean isCondition() {
        String funcName = this._hicall.getFuncName();
        return FunctionType.isCondition(funcName);
    }

    public boolean setFuncName(String newName) {
        String funcName = this.getFuncName();
        if (PolicyHandler.compareTwoObject(funcName, newName) == 0) {
            return false;
        }
        this._hicall.setFuncName(newName);
        return true;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public void setPhysicalFileObject(PhysicalFileObject obj) {
        this.physicalFileObject = obj;
    }

    public PhysicalFileObject getPhysicalFileObject() {
        return this.physicalFileObject;
    }

    public String getOwnerId() {
        return PolicyHandler.getOwnerOfObject((ConfigObject)this._hicall).toString();
    }
}

