/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.GroupPolicyPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AgentServiceProtection;
import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.configobject.schema.AppAuthenticationProtection;
import com.sygate.scm.common.configobject.schema.AutoLocation;
import com.sygate.scm.common.configobject.schema.BufferOverrunProtection;
import com.sygate.scm.common.configobject.schema.CloudAppliedPolicyArray;
import com.sygate.scm.common.configobject.schema.Communication;
import com.sygate.scm.common.configobject.schema.ComputerLockdownProtection;
import com.sygate.scm.common.configobject.schema.EnforcerClient;
import com.sygate.scm.common.configobject.schema.ExternalCommunication;
import com.sygate.scm.common.configobject.schema.IDS;
import com.sygate.scm.common.configobject.schema.Inheritance;
import com.sygate.scm.common.configobject.schema.Location;
import com.sygate.scm.common.configobject.schema.LocationArray;
import com.sygate.scm.common.configobject.schema.Log;
import com.sygate.scm.common.configobject.schema.LuContentSelection;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OptimizationSettings;
import com.sygate.scm.common.configobject.schema.PasswordProtection;
import com.sygate.scm.common.configobject.schema.PerformanceSettings;
import com.sygate.scm.common.configobject.schema.PrestartingProtection;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.configobject.schema.ServerCertificate;
import com.sygate.scm.common.configobject.schema.SpiffyStart;
import com.sygate.scm.common.configobject.schema.TamperProtectionPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AgentLogObject;
import com.sygate.scm.console.logicobject.AgentPolicyObject;
import com.sygate.scm.console.logicobject.AppAuthenticationObject;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.AutoLocationObject;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.ComputerLockdownProtectionObject;
import com.sygate.scm.console.logicobject.EnforcerNotificationObject;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.IDSObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.OverflowObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.logicobject.PolicyLogEvent;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class GroupPolicyObject
extends AbstractUIObject {
    public static final String MODE_LOCAL = "USE_LOCAL";
    public static final String MODE_INHERIT = "USE_PARENT";
    private SemGroupPolicy semGroupPolicy;
    private SemAgentPolicy semAgentPolicy;
    private Inheritance inheritance;
    private Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> deletedObjSet = new HashMap<String, TopLevelObject>();
    private GroupObject groupObject;
    private Map<String, TopLevelObject> changedObjSet = new HashMap<String, TopLevelObject>();
    private List<PolicyLogEvent> logList = new Vector<PolicyLogEvent>();
    private PhysicalFileObject physicalFileObject = new PhysicalFileObject();
    private long lastestT = -1L;
    private ConfigObject latestObject;

    public GroupPolicyObject(SemGroupPolicy semPolicy) {
        this.semGroupPolicy = semPolicy;
        this.inheritance = this.semGroupPolicy.getInheritance();
    }

    public void addAgentPolicyObject(SemAgentPolicy agentPolicy) {
        ConsoleAssertion.runAssert(agentPolicy == null, "null agent Policy");
        if (this.semAgentPolicy == null || this.semAgentPolicy != agentPolicy) {
            this.newObjSet.put(agentPolicy.getId(), (TopLevelObject)agentPolicy);
            PolicyHandler.addToNewObjectPool(agentPolicy.getId(), (TopLevelObject)agentPolicy);
            this.semAgentPolicy = agentPolicy;
            ObjReference obj = PolicyHandler.getSemAgentPolicyReference(this.semGroupPolicy);
            if (obj != null) {
                obj.setTargetId(this.semAgentPolicy.getId());
            } else {
                obj = new ObjReference();
                obj.setName("SemAgentPolicyLink");
                obj.setTargetId(this.semAgentPolicy.getId());
                obj.setTargetType("SemAgentPolicy");
                this.semGroupPolicy.addObjReference(obj);
            }
        }
    }

    public void clearNewObject() {
        this.newObjSet.clear();
    }

    public void addChangedObject(TopLevelObject obj) {
        PolicyHandler.updateObject(obj, this.newObjSet, this.changedObjSet);
        if (!PolicyHandler.newObjectPoolContainsKey(obj.getId())) {
            PolicyHandler.addToChangedObjectPool(obj.getId(), obj);
        } else {
            PolicyHandler.addToNewObjectPool(obj.getId(), obj);
        }
    }

    public void deleteObject(TopLevelObject deletedObj) {
        String key = deletedObj.getId();
        if (this.newObjSet.containsKey(key)) {
            this.newObjSet.remove(key);
            PolicyHandler.removeFromNewObjectPool(key);
        } else {
            this.deletedObjSet.put(key, deletedObj);
        }
        this.changedObjSet.remove(key);
        PolicyHandler.removeFromChangedObjectPool(key);
    }

    public void addNewObjSet(Map<String, TopLevelObject> set) {
        PolicyHandler.dumpObjects(set, this.newObjSet);
        PolicyHandler.dumpObjects(set, PolicyHandler.getNewObjectPool());
        set.clear();
    }

    public void addChangedObjSet(Map<String, TopLevelObject> set) {
        PolicyHandler.dumpObjects(set, this.changedObjSet);
        PolicyHandler.dumpObjects(set, PolicyHandler.getChangedObjectPool());
        set.clear();
    }

    public void addDeletedObjSet(Map<String, TopLevelObject> set) {
        PolicyHandler.dumpObjects(set, this.deletedObjSet);
    }

    public void addLog(int eventId, String ownerId, String desc) {
        this.logList.add(new PolicyLogEvent(eventId, ownerId, desc));
    }

    public void addLog(int eventId, TopLevelObject topLevelObject, String desc) {
        String ownerId = null;
        MetadataAttributes attributes = topLevelObject.getMetadataAttributes();
        GUID owner = attributes.getOwner();
        if (owner != null) {
            ownerId = owner.toString();
        }
        if (ownerId == null || ownerId.length() == 0) {
            ownerId = topLevelObject.getId();
        }
        this.logList.add(new PolicyLogEvent(eventId, ownerId, desc));
    }

    public void addLogList(List<PolicyLogEvent> list) {
        this.logList.addAll(list);
    }

    public long calculateLastestT() {
        this.lastestT = this.getLatestT((ConfigObject)this.semAgentPolicy, this.lastestT);
        this.lastestT = this.getLatestT((ConfigObject)this.semGroupPolicy.getInheritance(), this.lastestT);
        return this.lastestT;
    }

    public void copyAppliedPoliciesToLocation(AppliedPolicyObject appliedPolicy, LocationObject newLoc) throws ConsoleException {
        AppliedPolicyObject copyOfDefault = appliedPolicy.getClone();
        this.copyPolicies(copyOfDefault);
        newLoc.setAppliedPolicyObject(copyOfDefault);
    }

    public void pasteAgentPolicy(AgentPolicyObject newPolicy) {
        String desc;
        if (this.isInherit()) {
            this.setInherit(false);
            desc = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "GroupPolicyObject.InheritanceStatusChanged");
            this.addLog(2, this.getId(), desc);
        }
        this.addAgentPolicyObject(newPolicy.getSemAgentPolicy());
        this.addNewObjSet(newPolicy.getNewObjSet());
        desc = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "GroupPolicyObject.PasteAgentPolicy");
        this.addLog(2, this.getId(), desc);
    }

    private PasswordProtection generationPasswordProtection() {
        PasswordProtection password = new PasswordProtection();
        return password;
    }

    private void copyPolicies(AppliedPolicyObject appPolicy) throws ConsoleException {
        List<PolicyInt> policies = appPolicy.getAllAppliedPolicyFromDB();
        for (PolicyInt policyInt : policies) {
            PolicyInt pi = policyInt;
            if (!pi.isLocalPolicy()) continue;
            try {
                TopLevelObject policy = pi.getSchemaObj();
                WashIDHandler idHandler = new WashIDHandler();
                HashMap<String, TopLevelObject> newObjs = new HashMap<String, TopLevelObject>();
                TopLevelObject copy = (TopLevelObject)idHandler.duplicateObject((ConfigObject)policy, newObjs);
                for (TopLevelObject topLevelObject : newObjs.values()) {
                    DataobjectManager.getInstance().addObject(topLevelObject);
                }
                DataobjectManager.getInstance().addObject(copy);
                appPolicy.removePolicy(pi, false);
                pi.setSchemaObj(copy);
                appPolicy.addNewLocalPolicy(pi);
            }
            catch (Exception e) {
                throw new ConsoleException(e);
            }
        }
    }

    private long getLatestT(ConfigObject configObject, long curT) {
        HashMap<String, ObjReference> objRefMap = new HashMap<String, ObjReference>();
        curT = this.getLatestT(configObject, curT, objRefMap);
        if (!objRefMap.isEmpty()) {
            ArrayList<String> idList = new ArrayList<String>(objRefMap.keySet());
            try {
                List<TopLevelObject> objects = DataobjectManager.getInstance().getMutipleObjectById(idList);
                for (TopLevelObject subObj : objects) {
                    curT = this.getLatestT((ConfigObject)subObj, curT);
                }
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e.getMessage());
            }
        }
        return curT;
    }

    private long getLatestT(ConfigObject configObject, long curT, HashMap<String, ObjReference> objRefMap) {
        long newT = configObject.getT();
        if (curT < newT) {
            curT = newT;
            this.latestObject = configObject;
        }
        if (configObject instanceof ObjReference) {
            ObjReference objRef = (ObjReference)configObject;
            String objType = objRef.getTargetType();
            String objId = objRef.getTargetId();
            if (objType.equals("SemLocationConfig")) {
                objRefMap.put(objId, objRef);
            }
        }
        for (AbstractSchema child : configObject.getChildren()) {
            curT = this.getLatestT((ConfigObject)child, curT, objRefMap);
        }
        return curT;
    }

    public void setSemGroupPolicy(SemGroupPolicy semPolicy) {
        this.semGroupPolicy = semPolicy;
        this.inheritance = this.semGroupPolicy.getInheritance();
    }

    public void setAgentPolicyObject(SemAgentPolicy agentPolicy) {
        ConsoleAssertion.runAssert(agentPolicy == null, "null agent Policy");
        if (this.semAgentPolicy == null || this.semAgentPolicy != agentPolicy) {
            this.semAgentPolicy = agentPolicy;
        }
    }

    public Map<String, TopLevelObject> getNewObject() {
        return this.newObjSet;
    }

    public boolean isInherit() {
        Integer mode = this.inheritance.getMode();
        return Inheritance.USE_PARENT.equals(mode);
    }

    public boolean setInherit(boolean isInherit) {
        boolean oldInherit = this.isInherit();
        if (isInherit != oldInherit) {
            Integer mode = isInherit ? Inheritance.USE_PARENT : Inheritance.USE_LOCAL;
            this.inheritance.setMode(mode);
            return true;
        }
        return false;
    }

    public String getGroupName() {
        String name = this.groupObject.getName();
        ConsoleAssertion.runAssert(name == null, "No Group Name in SemGroupPolicy. Policy ID is:" + this.semGroupPolicy.getId());
        return name;
    }

    public List<LocationObject> getLocations() throws ConsoleException {
        AutoLocation auLocation = this.semAgentPolicy.getAutoLocation();
        LocationArray locArrayObj = auLocation.getLocationArray();
        String defLocationId = locArrayObj.getDefaultLocation();
        Vector locs = locArrayObj.getLocation();
        ArrayList<LocationObject> locArray = new ArrayList<LocationObject>();
        for (int i = 0; i < locs.size(); ++i) {
            Location curLoc = (Location)locs.get(i);
            boolean isDefault = PolicyHandler.isDefaultLocation(curLoc, defLocationId);
            locArray.add(new LocationObject(curLoc, isDefault, false));
        }
        return locArray;
    }

    public List<LocationObject> getLocationsFromDB() throws ConsoleException {
        AutoLocation auLocation = this.semAgentPolicy.getAutoLocation();
        LocationArray locArrayObj = auLocation.getLocationArray();
        String defLocation = locArrayObj.getDefaultLocation();
        Vector locs = locArrayObj.getLocation();
        ArrayList<LocationObject> locArray = new ArrayList<LocationObject>();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < locs.size(); ++i) {
            Location curLoc = (Location)locs.get(i);
            ObjReference refer = curLoc.getObjReference();
            idList.add(refer.getTargetId());
        }
        List<TopLevelObject> objects = DataobjectManager.getInstance().getMutipleObjectById(idList);
        HashMap<String, SemLocationConfig> idSemLocationMap = new HashMap<String, SemLocationConfig>();
        for (TopLevelObject o : objects) {
            if (!(o instanceof SemLocationConfig)) continue;
            idSemLocationMap.put(o.getId(), (SemLocationConfig)o);
        }
        for (int i = 0; i < locs.size(); ++i) {
            Location curLoc = (Location)locs.get(i);
            boolean isDefault = PolicyHandler.isDefaultLocation(curLoc, defLocation);
            ObjReference refer = curLoc.getObjReference();
            SemLocationConfig semLocConfig = (SemLocationConfig)idSemLocationMap.get(refer.getTargetId());
            if (semLocConfig == null) continue;
            locArray.add(new LocationObject(curLoc, semLocConfig, isDefault));
        }
        return locArray;
    }

    public AutoLocationObject getAutoLocation() throws ConsoleException {
        AutoLocation auLocation = this.semAgentPolicy.getAutoLocation();
        return new AutoLocationObject(auLocation);
    }

    public RebootOptions getRebootOptions() throws ConsoleException {
        RebootOptions rebootOptions = this.semAgentPolicy.getOptRebootOptions();
        if (rebootOptions == null) {
            rebootOptions = new RebootOptions();
            this.semAgentPolicy.setOptRebootOptions(rebootOptions);
        }
        return rebootOptions;
    }

    public SemGroupPolicy getSemGroupPolicyObject() {
        return this.semGroupPolicy;
    }

    public SemAgentPolicy getSemAgentPolicyObject() {
        return this.semAgentPolicy;
    }

    public void setAutoLocation(AutoLocationObject newAutoLocObj) {
        ConsoleAssertion.runAssert(newAutoLocObj == null, "Null newAutoLocObj");
        this.semAgentPolicy.setAutoLocation(newAutoLocObj.getAutoLocation());
        Map<String, TopLevelObject> newObjFromAutoLoc = newAutoLocObj.getNewObjSet();
        PolicyHandler.dumpObjects(newObjFromAutoLoc, this.newObjSet);
        PolicyHandler.dumpObjects(this.newObjSet, PolicyHandler.getNewObjectPool());
        newObjFromAutoLoc.clear();
        Map<String, TopLevelObject> deletedObjFromAutoLoc = newAutoLocObj.getDeletedObj();
        HashSet<String> newSet = new HashSet<String>(this.newObjSet.keySet());
        newSet.retainAll(deletedObjFromAutoLoc.keySet());
        for (Object e : newSet) {
            this.newObjSet.remove(e);
            deletedObjFromAutoLoc.remove(e);
        }
        PolicyHandler.dumpObjects(deletedObjFromAutoLoc, this.deletedObjSet);
        deletedObjFromAutoLoc.clear();
        this.logList.addAll(newAutoLocObj.getLogList());
    }

    public GroupPolicyObject getClone() throws ConsoleException {
        try {
            SemGroupPolicy newPolicy = (SemGroupPolicy)PolicyHandler.getCopyOfObj((ConfigObject)this.semGroupPolicy);
            GroupPolicyObject newObj = new GroupPolicyObject(newPolicy);
            SemAgentPolicy newAgent = (SemAgentPolicy)PolicyHandler.getCopyOfObj((ConfigObject)this.semAgentPolicy);
            newObj.setAgentPolicyObject(newAgent);
            newObj.setGroupObject(this.groupObject);
            return newObj;
        }
        catch (ConsoleException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public void setGroupObject(GroupObject myGroup) {
        this.groupObject = myGroup;
    }

    public GroupObject getGroupObject() {
        return this.groupObject;
    }

    public SemClientGroup getClientGroup() {
        return this.getGroupObject() == null ? null : this.getGroupObject().getSemClientGroup();
    }

    public boolean isTopGroup() {
        return this.groupObject != null && this.groupObject.getParentGroup() == null;
    }

    public String getId() {
        return this.semGroupPolicy.getId();
    }

    public EnforcerNotificationObject getEnforcerNotificationObj() {
        EnforcerClient enfClient = this.semAgentPolicy.getOptEnforcerClient();
        return new EnforcerNotificationObject(enfClient);
    }

    public void setEnforcerNotificationObject(EnforcerNotificationObject enforceNotificationObj) {
        this.semAgentPolicy.setOptEnforcerClient(enforceNotificationObj.getEnforcerClient());
    }

    public void setRebootOptions(RebootOptions rebootOptionsObject) {
        this.semAgentPolicy.setOptRebootOptions(rebootOptionsObject);
    }

    public AgentLogObject getAgentLogObject() {
        Log agentLog = this.semAgentPolicy.getLog();
        return new AgentLogObject(agentLog);
    }

    public void setAgentLogObject(AgentLogObject newLogObj) {
        Log agentLog = newLogObj.getLog();
        this.semAgentPolicy.setLog(agentLog);
    }

    public Map<String, TopLevelObject> getChangedObject() {
        return this.changedObjSet;
    }

    public Map<String, TopLevelObject> getDeletedObject() {
        return this.deletedObjSet;
    }

    public AppAuthenticationObject getAppAuthenticationObject() {
        AppAuthenticationProtection appAuthen = this.semAgentPolicy.getOptAppAuthenticationProtection();
        return new AppAuthenticationObject(appAuthen);
    }

    public IDSObject getIDSObject() {
        IDS ids = this.semAgentPolicy.getOptIDS();
        return new IDSObject(ids);
    }

    public void setAppAuthentication(AppAuthenticationObject newObj) {
        AppAuthenticationProtection appAuthen = newObj.getAppAuthenticationProtection();
        this.semAgentPolicy.setOptAppAuthenticationProtection(appAuthen);
    }

    public void setIDS(IDSObject newObj) {
        if (newObj == null) {
            return;
        }
        IDS ids = newObj.getIDS();
        this.semAgentPolicy.setOptIDS(ids);
    }

    public boolean getBlockTrafficBeforeStart() {
        PrestartingProtection protection = this.semAgentPolicy.getOptPrestartingProtection();
        if (protection != null) {
            Boolean enable = protection.getOptEnable();
            if (enable != null) {
                return enable;
            }
            return true;
        }
        return false;
    }

    public boolean setBlockTrafficBeforeStart(boolean newValue) {
        boolean oldValue = this.getBlockTrafficBeforeStart();
        if (oldValue != newValue) {
            PrestartingProtection protection = this.semAgentPolicy.getOptPrestartingProtection();
            if (protection == null) {
                protection = new PrestartingProtection();
                this.semAgentPolicy.setOptPrestartingProtection(protection);
            }
            protection.setOptEnable(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getAllowInitTraffic() {
        PrestartingProtection protection = this.semAgentPolicy.getOptPrestartingProtection();
        if (protection != null) {
            Boolean initTraffic = protection.getOptAllowInitTraffic();
            if (initTraffic != null) {
                return initTraffic;
            }
            return false;
        }
        return false;
    }

    public boolean setAllowInitTraffic(boolean newValue) {
        boolean oldValue = this.getAllowInitTraffic();
        if (oldValue != newValue) {
            PrestartingProtection protection = this.semAgentPolicy.getOptPrestartingProtection();
            if (protection == null) {
                protection = new PrestartingProtection();
                this.semAgentPolicy.setOptPrestartingProtection(protection);
            }
            protection.setOptAllowInitTraffic(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getPreventFromKill() {
        AgentServiceProtection protection = this.semAgentPolicy.getOptAgentServiceProtection();
        if (protection != null) {
            Boolean enable = protection.getOptEnable();
            if (enable != null) {
                return enable;
            }
            return true;
        }
        return false;
    }

    public boolean setPreventFromKill(boolean newValue) {
        boolean oldValue = this.getPreventFromKill();
        if (oldValue != newValue) {
            AgentServiceProtection protection = this.semAgentPolicy.getOptAgentServiceProtection();
            if (protection == null) {
                protection = new AgentServiceProtection();
                this.semAgentPolicy.setOptAgentServiceProtection(protection);
            }
            protection.setOptEnable(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getValidateServerCertificate() {
        Boolean enable;
        ServerCertificate certificate = this.semAgentPolicy.getOptServerCertificate();
        if (certificate != null && (enable = certificate.getOptEnableSignatureValidation()) != null) {
            return enable;
        }
        return new ServerCertificate().getDefEnableSignatureValidation();
    }

    public boolean setValidateServerCertificate(boolean newValue) {
        boolean oldValue = this.getValidateServerCertificate();
        if (oldValue != newValue) {
            ServerCertificate certificate = this.semAgentPolicy.getOptServerCertificate();
            if (certificate == null) {
                certificate = new ServerCertificate();
                this.semAgentPolicy.setOptServerCertificate(certificate);
            }
            certificate.setOptEnableSignatureValidation(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public AgentServiceProtection getAgentServiceProtect() {
        return this.semAgentPolicy.getOptAgentServiceProtection();
    }

    public void setAgentServiceProtection(GroupPolicyObject newObj) {
        this.semAgentPolicy.setOptAgentServiceProtection(newObj.getAgentServiceProtect());
    }

    public LuContentSelection getLuContentSelection() {
        return this.semAgentPolicy.getOptLuContentSelection();
    }

    public void setLuContentSelection(LuContentSelection sel) {
        this.semAgentPolicy.setOptLuContentSelection(sel);
    }

    public PrestartingProtection getPrestartingProtection() {
        return this.semAgentPolicy.getOptPrestartingProtection();
    }

    public void setPrestartingProtection(GroupPolicyObject newObj) {
        this.semAgentPolicy.setOptPrestartingProtection(newObj.getPrestartingProtection());
    }

    public List<PolicyLogEvent> getLogList() {
        return this.logList;
    }

    public String getAgentPolicyId() {
        return this.semAgentPolicy.getId();
    }

    public List<String> getGroupPolicyHistoryCheckId() {
        HashSet<String> resultSet = new HashSet<String>(3);
        resultSet.add(this.getId());
        resultSet.add(this.getAgentPolicyId());
        resultSet.addAll(this.getPolicyIdList());
        return new ArrayList<String>(resultSet);
    }

    private List<String> getPolicyIdList() {
        ArrayList<String> stringList = new ArrayList<String>();
        List<LocationObject> allLocations = null;
        try {
            allLocations = this.getLocationsFromDB();
        }
        catch (ConsoleException e1) {
            LoggerUtilities.logException((Throwable)e1);
            return stringList;
        }
        for (LocationObject locObj : allLocations) {
            AppliedPolicyObject appliedObj = locObj.getAppliedPolicyObject();
            List<ObjInfoObject> objInfoObjs = appliedObj.getAllAppliedPolicyObjInfo();
            for (int i = 0; i < objInfoObjs.size(); ++i) {
                ObjInfoObject objInfoObj = objInfoObjs.get(i);
                String id = objInfoObj.getId();
                stringList.add(id);
            }
        }
        return stringList;
    }

    public void setPhysicalFileObject(PhysicalFileObject obj) {
        this.physicalFileObject = obj;
    }

    public PhysicalFileObject getPhysicalFileObject() {
        return this.physicalFileObject;
    }

    public boolean getAskPwdOpenGui() {
        PasswordProtection protection;
        if (this.semAgentPolicy != null && (protection = this.semAgentPolicy.getOptPasswordProtection()) != null) {
            Boolean ask = protection.getOptAskPwdWhenOpenAgentGUI();
            if (ask == null) {
                ask = protection.getDefAskPwdWhenOpenAgentGUI();
            }
            return ask;
        }
        return false;
    }

    public boolean setAskPwdOpenGui(boolean newValue) {
        boolean oldValue = this.getAskPwdOpenGui();
        if (oldValue == newValue) {
            return false;
        }
        PasswordProtection protection = this.semAgentPolicy.getOptPasswordProtection();
        if (protection == null) {
            protection = this.getPasswordProtectionAllOff();
        }
        protection.setOptAskPwdWhenOpenAgentGUI(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getAskPwdUninstall() {
        PasswordProtection protection;
        if (this.semAgentPolicy != null && (protection = this.semAgentPolicy.getOptPasswordProtection()) != null) {
            Boolean value = protection.getOptAskPwdWhenUninstall();
            if (value == null) {
                value = protection.getDefAskPwdWhenUninstall();
            }
            return value;
        }
        return false;
    }

    public boolean setAskPwdUninstall(boolean newValue) {
        boolean oldValue = this.getAskPwdUninstall();
        if (oldValue == newValue) {
            return false;
        }
        PasswordProtection protection = this.semAgentPolicy.getOptPasswordProtection();
        if (protection == null) {
            protection = this.getPasswordProtectionAllOff();
        }
        protection.setOptAskPwdWhenUninstall(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getAskPwdCleanwipe() {
        PasswordProtection protection;
        if (this.semAgentPolicy != null && (protection = this.semAgentPolicy.getOptPasswordProtection()) != null) {
            Boolean value = protection.getOptAskPwdWhenCleanwipe();
            if (value == null) {
                value = protection.getDefAskPwdWhenCleanwipe();
            }
            return value;
        }
        return false;
    }

    public boolean setAskPwdCleanwipe(boolean newValue) {
        boolean oldValue = this.getAskPwdCleanwipe();
        if (oldValue == newValue) {
            return false;
        }
        PasswordProtection protection = this.semAgentPolicy.getOptPasswordProtection();
        if (protection == null) {
            protection = this.getPasswordProtectionAllOff();
        }
        protection.setOptAskPwdWhenCleanwipe(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getAskPwdExit() {
        PasswordProtection protection;
        if (this.semAgentPolicy != null && (protection = this.semAgentPolicy.getOptPasswordProtection()) != null) {
            Boolean value = protection.getOptAskPwdWhenExit();
            if (value == null) {
                value = protection.getDefAskPwdWhenExit();
            }
            return value;
        }
        return false;
    }

    public boolean setAskPwdExit(boolean newValue) {
        boolean oldValue = this.getAskPwdExit();
        if (oldValue == newValue) {
            return false;
        }
        PasswordProtection protection = this.semAgentPolicy.getOptPasswordProtection();
        if (protection == null) {
            protection = this.getPasswordProtectionAllOff();
        }
        protection.setOptAskPwdWhenExit(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getAskPwdProfile() {
        PasswordProtection protection;
        if (this.semAgentPolicy != null && (protection = this.semAgentPolicy.getOptPasswordProtection()) != null) {
            Boolean value = protection.getOptAskPwdWhenImportOrExportProfile();
            if (value == null) {
                value = protection.getDefAskPwdWhenImportOrExportProfile();
            }
            return value;
        }
        return false;
    }

    public boolean setAskPwdProfile(boolean newValue) {
        boolean oldValue = this.getAskPwdProfile();
        if (oldValue == newValue) {
            return false;
        }
        PasswordProtection protection = this.semAgentPolicy.getOptPasswordProtection();
        if (protection == null) {
            protection = this.getPasswordProtectionAllOff();
        }
        protection.setOptAskPwdWhenImportOrExportProfile(Boolean.valueOf(newValue));
        return true;
    }

    public String getPasswordHash() {
        PasswordProtection protection;
        if (this.semAgentPolicy != null && (protection = this.semAgentPolicy.getOptPasswordProtection()) != null) {
            return protection.getOptPasswordHash();
        }
        return null;
    }

    public String getPassword3Hash() {
        PasswordProtection protection;
        if (this.semAgentPolicy != null && (protection = this.semAgentPolicy.getOptPasswordProtection()) != null) {
            return protection.getOptPassword3Hash();
        }
        return null;
    }

    public boolean setPassword(String newValue) {
        String oldValue = this.getPasswordHash();
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return false;
        }
        PasswordProtection protection = this.semAgentPolicy.getOptPasswordProtection();
        if (protection == null) {
            protection = this.generationPasswordProtection();
            this.semAgentPolicy.setOptPasswordProtection(protection);
        }
        if (newValue != null) {
            protection.setOptPasswordHash(Utility.calculateHash((String)newValue));
            protection.setOptPassword3Hash(Utility.calculatePKDBF2Hash_DefaultSaltLengthDefaultWorkFactor((String)newValue));
        } else {
            protection.setOptPasswordHash(null);
            protection.setOptPassword3Hash(null);
        }
        return true;
    }

    public PasswordProtection getPasswordProtection() {
        return this.semAgentPolicy.getOptPasswordProtection();
    }

    public void setPasswordProtection(PasswordProtection protection) {
        this.semAgentPolicy.setOptPasswordProtection(protection);
    }

    public CommunicationObject getCommunicationObject() {
        Communication com = this.semAgentPolicy.getCommunication();
        return new CommunicationObject(com);
    }

    public void setCommunicationObject(CommunicationObject comObj) {
        Communication com = comObj.getCommunication();
        this.semAgentPolicy.setCommunication(com);
    }

    public ExternalCommunicationObject getExternalCommunicationObject() {
        ExternalCommunication externalComm = this.semAgentPolicy.getOptExternalCommunication();
        if (externalComm == null) {
            externalComm = new ExternalCommunication();
            this.semAgentPolicy.setOptExternalCommunication(externalComm);
        }
        return new ExternalCommunicationObject(externalComm);
    }

    public void setExternalCommunicationObject(ExternalCommunicationObject comObj) {
        ExternalCommunication com = comObj.getExternalCommunication();
        this.semAgentPolicy.setOptExternalCommunication(com);
    }

    public TamperProtectionPolicy getTamperProtectionPolicy() throws ConsoleException {
        TamperProtectionPolicy policy = this.semAgentPolicy.getOptTamperProtectionPolicy();
        try {
            if (policy == null) {
                policy = new TamperProtectionPolicy();
                policy.setId(new GUIDGenerator().getGUIDString());
                this.semAgentPolicy.setOptTamperProtectionPolicy(policy);
            }
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
        return policy;
    }

    public void setTamperProtectionPolicy(TamperProtectionPolicy tpObj) {
        this.semAgentPolicy.setOptTamperProtectionPolicy(tpObj);
    }

    public OverflowObject getOverflowObject() {
        BufferOverrunProtection overrun = this.semAgentPolicy.getOptBufferOverrunProtection();
        return new OverflowObject(overrun);
    }

    public void setOverflowObject(OverflowObject newObj) {
        this.semAgentPolicy.setOptBufferOverrunProtection(newObj.getBufferOverrunProtection());
    }

    public void setGroupPolicyObject(GroupPolicyObject newOne) {
        this.semGroupPolicy = newOne.getSemGroupPolicyObject();
        this.semAgentPolicy = newOne.getSemAgentPolicyObject();
        this.inheritance = this.semGroupPolicy.getInheritance();
        Map<String, TopLevelObject> newObjFromAutoLoc = newOne.getNewObject();
        PolicyHandler.dumpObjects(newObjFromAutoLoc, this.newObjSet);
        PolicyHandler.dumpObjects(this.newObjSet, PolicyHandler.getNewObjectPool());
        newObjFromAutoLoc.clear();
        Map<String, TopLevelObject> deletedObjFromAutoLoc = newOne.getDeletedObject();
        HashSet<String> newSet = new HashSet<String>(this.newObjSet.keySet());
        newSet.retainAll(deletedObjFromAutoLoc.keySet());
        for (Object e : newSet) {
            this.newObjSet.remove(e);
            deletedObjFromAutoLoc.remove(e);
        }
        PolicyHandler.dumpObjects(deletedObjFromAutoLoc, this.deletedObjSet);
        deletedObjFromAutoLoc.clear();
        this.logList.addAll(newOne.getLogList());
    }

    public void setComputerLockdownProtectionObject(ComputerLockdownProtectionObject lockdownObj) {
        ComputerLockdownProtection lockdown = lockdownObj.getComputerLockdownProtection();
        this.semAgentPolicy.setOptComputerLockdownProtection(lockdown);
    }

    public ComputerLockdownProtectionObject getComputerLockdownProtectionObject() {
        ComputerLockdownProtection lockdown = this.semAgentPolicy.getOptComputerLockdownProtection();
        return new ComputerLockdownProtectionObject(lockdown);
    }

    public AppliedPolicyObject getDefaultLocationAppliedPolicy() throws ConsoleException {
        LocationObject defaultLoc = PolicyHandler.getDefaultLocation(this.getAutoLocation().getAutoLocation());
        if (defaultLoc != null) {
            return defaultLoc.getAppliedPolicyObject();
        }
        return null;
    }

    public boolean hasChanged(GroupPolicyObject newGpObj) {
        long newLastestT = newGpObj.calculateLastestT();
        if (newLastestT != this.lastestT) {
            System.out.println("Old Lastest T:" + this.lastestT);
            System.out.println("New Lastest T:" + newLastestT);
            System.out.println("Changed Object:" + newGpObj.latestObject.getObjectTypeName());
        }
        return newLastestT != this.lastestT;
    }

    public OptimizationSettings getOptimizationSettings() {
        OptimizationSettings opSettings = this.semAgentPolicy.getOptOptimizationSettings();
        if (opSettings == null) {
            opSettings = new OptimizationSettings();
            opSettings.setSpiffyStart(new SpiffyStart());
            this.semAgentPolicy.setOptOptimizationSettings(opSettings);
        }
        return opSettings;
    }

    public void setOptimizationSettings(OptimizationSettings opSettings) {
        this.semAgentPolicy.setOptOptimizationSettings(opSettings);
    }

    public boolean isPolicyEditable(boolean isSharedPolicy) {
        if (this.isInherit()) {
            return false;
        }
        if (isSharedPolicy) {
            AuthorizationManager manager = AuthorizationManager.getInstance();
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            return manager.checkPermission(context, (Permission)AuthorizationManager.PolicyPermission.EDIT_SHARED_POLICIES);
        }
        return !this.getGroupObject().isReadOnly();
    }

    public boolean isLowBandwidthEnabled() throws Exception {
        boolean lowBandwidthEnabled = new AmlLowBandwidth().getDefEnableLowBandwidth();
        AmlLowBandwidth amlLowBandwidth = null;
        Boolean lowBandwidthValue = null;
        CloudAppliedPolicyArray cloudAppliedPolicyArray = this.semGroupPolicy.getOptCloudAppliedPolicyArray();
        if (cloudAppliedPolicyArray != null) {
            ExternalCommunication externalCommunication = cloudAppliedPolicyArray.getOptExternalCommunication();
            if (externalCommunication != null) {
                amlLowBandwidth = externalCommunication.getOptAmlLowBandwidth();
                if (amlLowBandwidth != null) {
                    lowBandwidthValue = amlLowBandwidth.getOptEnableLowBandwidth();
                } else {
                    System.out.println("GroupPolicyObject> isLowBandwidthEnabled>> AmlLowBandwidth is null for group: " + this.groupObject.getName());
                }
            } else {
                System.out.println("GroupPolicyObject> isLowBandwidthEnabled>> externalCommunication is null for group: " + this.groupObject.getName());
            }
        } else {
            System.out.println("GroupPolicyObject> isLowBandwidthEnabled>> CloudAppliedPolicyArray is null for group: " + this.groupObject.getName());
        }
        lowBandwidthEnabled = lowBandwidthValue == null ? new AmlLowBandwidth().getDefEnableLowBandwidth().booleanValue() : lowBandwidthValue.booleanValue();
        return lowBandwidthEnabled;
    }

    public GroupPolicyPermission.GroupPolicyMode getGroupPolicyMode() {
        return this.isInherit() ? GroupPolicyPermission.GroupPolicyMode.INHERIT : GroupPolicyPermission.GroupPolicyMode.LOCAL;
    }

    public PerformanceSettings getPerformanceSettings() {
        PerformanceSettings performanceSettings = this.semAgentPolicy.getOptPerformanceSettings();
        if (performanceSettings == null) {
            performanceSettings = new PerformanceSettings();
            this.semAgentPolicy.setOptPerformanceSettings(performanceSettings);
        }
        return performanceSettings;
    }

    public void setPerformanceSettings(PerformanceSettings performanceSettings) {
        this.semAgentPolicy.setOptPerformanceSettings(performanceSettings);
    }

    private PasswordProtection getPasswordProtectionAllOff() {
        PasswordProtection protection = this.generationPasswordProtection();
        this.semAgentPolicy.setOptPasswordProtection(protection);
        protection.setOptAskPwdWhenExit(Boolean.FALSE);
        protection.setOptAskPwdWhenImportOrExportProfile(Boolean.FALSE);
        protection.setOptAskPwdWhenOpenAgentGUI(Boolean.FALSE);
        protection.setOptAskPwdWhenUninstall(Boolean.FALSE);
        protection.setOptAskPwdWhenCleanwipe(Boolean.FALSE);
        return protection;
    }
}

