/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.Inheritance;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class GroupObject
extends AbstractSelectableUIObject
implements TreeItem {
    public static final int GROUPPATH_MAXLEN = 1000;
    public static final int GROUPNAME_MAXLEN = 990;
    public static final int FULL_ACCESS = 0;
    public static final int NO_ACCESS = 1;
    public static final int READ_ONLY = 2;
    private static final String EMPTY_STRING = "";
    private static MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    boolean isAccessible = true;
    boolean isInherited = true;
    SemClientGroup semClientGroup = null;
    Set<SemGroupPolicy> newObjSet = new HashSet<SemGroupPolicy>();
    private boolean changed = false;
    private int accessConstraint = 0;
    private boolean isInheritedSet = false;

    public GroupObject() {
    }

    public GroupObject(GroupObject parentClientGroup, String name, String description, String creatorGUID) throws ConsoleException {
        this.semClientGroup = new SemClientGroup();
        if (parentClientGroup != null) {
            parentClientGroup.getSemClientGroup().addSemClientGroup(this.semClientGroup);
        }
        this.semClientGroup.setOptBlockNewClient(Boolean.FALSE);
        this.semClientGroup.setOptDescription(description);
        this.semClientGroup.setCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        this.semClientGroup.setModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
        this.semClientGroup.setOptType(SemClientGroup.NATIVE);
        this.semClientGroup.setCreator(creatorGUID);
        String id = new GUIDGenerator().getGUIDString();
        this.semClientGroup.setId(id);
        this.semClientGroup.setName(name);
        SemGroupPolicy groupPolicy = new SemGroupPolicy();
        this.newObjSet.add(groupPolicy);
        groupPolicy.setId(new GUIDGenerator().getGUIDString());
        groupPolicy.setName(name);
        Inheritance inherit = new Inheritance();
        inherit.setMode(Inheritance.USE_PARENT);
        groupPolicy.setInheritance(inherit);
        ObjReference obj = new ObjReference();
        obj.setName("PolicyApplied");
        obj.setTargetId(groupPolicy.getId());
        obj.setOptEnable(Boolean.TRUE);
        obj.setTargetType("SemGroupPolicy");
        this.semClientGroup.setObjReference(obj);
    }

    public GroupObject(SemClientGroup clientGroup) {
        this.semClientGroup = clientGroup;
    }

    public SemClientGroup getSemClientGroup() {
        return this.semClientGroup;
    }

    public Set<SemGroupPolicy> getNewObject() {
        return this.newObjSet;
    }

    public void clearNewObject() {
        this.newObjSet.clear();
    }

    public int getType() {
        if (this.semClientGroup == null) {
            return SemClientGroup.NATIVE;
        }
        if (this.semClientGroup.getOptType() == null) {
            return SemClientGroup.NATIVE;
        }
        return this.semClientGroup.getOptType();
    }

    public String getAdsPath() {
        if (this.semClientGroup == null) {
            return EMPTY_STRING;
        }
        String adsPath = this.semClientGroup.getOptADsPath();
        return adsPath == null ? EMPTY_STRING : adsPath;
    }

    public boolean isFixed() {
        return this.isTemp() || this.isGlobal();
    }

    public boolean isGlobal() {
        return this.getName().equals(GroupHandler.getGlobalGroupName()) && this.getParent() == null;
    }

    public boolean isTemp() {
        return this.semClientGroup.getOptType() != null && this.semClientGroup.getOptType().equals(SemClientGroup.TEMPORARY);
    }

    public boolean isTypeNative() {
        return this.getType() == SemClientGroup.NATIVE.intValue();
    }

    public boolean isTypeAd() {
        int type = this.getType();
        return type == SemClientGroup.ADTREE || type == SemClientGroup.ADNODE;
    }

    public boolean isTypeAdTree() {
        return this.getType() == SemClientGroup.ADTREE.intValue();
    }

    public boolean isTypeAdNode() {
        return this.getType() == SemClientGroup.ADNODE.intValue();
    }

    public boolean isTypeCloudNode() {
        return this.getType() == SemClientGroup.CLOUDNODE.intValue();
    }

    public boolean isDefaultGroup() {
        String i18DefaultGroupName = MessageResources.getInstance().getString("com.sygate.scm.util.template.template", "$$I18N.DefaultGroup.Name$$");
        return this.getName().equalsIgnoreCase(i18DefaultGroupName);
    }

    @Override
    public int getItemType() {
        if (this.isTypeAdTree()) {
            return 11;
        }
        if (this.isTypeAdNode()) {
            return 11;
        }
        if (this.isTypeCloudNode()) {
            return 307;
        }
        return 9;
    }

    public String getDescription() {
        String description = this.semClientGroup.getOptDescription();
        return description == null ? EMPTY_STRING : description;
    }

    public void setDescription(String value) {
        this.semClientGroup.setOptDescription(value);
    }

    @Override
    public String getId() {
        return this.semClientGroup.getId();
    }

    @Override
    public String getName() {
        if (this.semClientGroup == null) {
            return EMPTY_STRING;
        }
        return this.semClientGroup.getName();
    }

    public void setId(String string) {
        this.semClientGroup.setId(string);
    }

    public void setName(String string) {
        this.semClientGroup.setName(string);
    }

    public boolean doesBlockNewUser() {
        if (this.semClientGroup == null) {
            return false;
        }
        if (this.semClientGroup.getOptBlockNewClient() == null) {
            return false;
        }
        return this.semClientGroup.getOptBlockNewClient();
    }

    public String getBlockNewUserStatusString() {
        return this.doesBlockNewUser() ? res.getString("GroupObject.Yes") : res.getString("GroupObject.No");
    }

    public void setBlockNewUser(boolean block) {
        if (this.semClientGroup == null) {
            return;
        }
        this.semClientGroup.setOptBlockNewClient(Boolean.valueOf(block));
    }

    public boolean isAutoUpgradeDisabled() {
        if (this.semClientGroup == null) {
            return false;
        }
        if (this.semClientGroup.getOptDisableAutoUpgrade() == null) {
            return false;
        }
        return this.semClientGroup.getOptDisableAutoUpgrade();
    }

    public void setDisableAutoUpgrade(boolean block) {
        if (this.semClientGroup == null) {
            return;
        }
        this.semClientGroup.setOptDisableAutoUpgrade(Boolean.valueOf(block));
    }

    public String getParentGroupId() {
        AbstractSchema parent = this.semClientGroup.getParent();
        if (parent instanceof SemClientGroup) {
            return ((SemClientGroup)parent).getId();
        }
        return null;
    }

    public SemClientGroup getParent() {
        if (this.semClientGroup == null) {
            return null;
        }
        AbstractSchema parent = this.semClientGroup.getParent();
        if (parent == null) {
            return null;
        }
        return parent instanceof SemClientGroup ? (SemClientGroup)parent : null;
    }

    public GroupObject getParentGroup() {
        SemClientGroup parent = this.getParent();
        return parent != null ? new GroupObject(parent) : null;
    }

    public void setParentGroupId(String value) {
        AbstractSchema parent = this.semClientGroup.getParent();
        if (parent instanceof SemClientGroup) {
            ((SemClientGroup)parent).setId(value);
        }
    }

    public String getStatus() {
        return EMPTY_STRING;
    }

    public String getDisplayName() {
        if (this.isGlobal()) {
            return GroupHandler.getGlobalGroupName();
        }
        if (this.isTemp()) {
            return this.getName();
        }
        return this.getName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void setStatus(String value) {
    }

    public boolean hasChanged() {
        return this.semClientGroup.isDirty();
    }

    public void reset() {
        this.semClientGroup.setClean();
    }

    public String getChecksum() {
        SemClientGroup root = this.semClientGroup;
        while (root.getParent() != null) {
            root = (ConfigObject)root.getParent();
        }
        MetadataAttributes metadata = ((TopLevelObject)root).getMetadataAttributes();
        if (metadata == null) {
            return null;
        }
        return metadata.getChecksum();
    }

    public String getCreator() {
        if (this.semClientGroup == null) {
            return EMPTY_STRING;
        }
        String admin = this.semClientGroup.getCreator();
        try {
            SemAdministrator semAdmin = AdminHandler.retrieveAdmin(admin);
            if (semAdmin != null) {
                admin = semAdmin.getName();
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return admin;
    }

    public String getFullGroupPath() {
        return GroupHandler.getGroupFullPath(this);
    }

    public String getFullGroupPathForExport() {
        String name = this.semClientGroup.getName();
        Object fullName = name;
        for (AbstractSchema asParent = this.semClientGroup.getParent(); asParent != null && asParent instanceof SemClientGroup; asParent = asParent.getParent()) {
            SemClientGroup parent = (SemClientGroup)asParent;
            fullName = parent.getName() + "_" + (String)fullName;
        }
        return fullName;
    }

    public int getChildrenGroupCount() {
        if (this.semClientGroup == null) {
            return 0;
        }
        return this.semClientGroup.getSemClientGroupCount();
    }

    public Vector<SemClientGroup> getChildrenGroups() {
        if (this.semClientGroup == null) {
            return null;
        }
        return this.semClientGroup.getSemClientGroup();
    }

    public long getCreationTime() {
        return this.semClientGroup != null ? this.semClientGroup.getCreationTime() : -1L;
    }

    public String getCreationTimeDisplayString() {
        long time = this.getCreationTime();
        if (time < 1L) {
            return EMPTY_STRING;
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public long getModificationTime() {
        return this.semClientGroup != null ? this.semClientGroup.getModifiedTime() : -1L;
    }

    public String getModificationTimeDisplayString() {
        long time = this.getModificationTime();
        if (time < 1L) {
            return EMPTY_STRING;
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public boolean isAccessible() {
        return this.isAccessible;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public boolean isInheritedSet() {
        return this.isInheritedSet;
    }

    public boolean isAccessible(boolean refresh) {
        if (refresh) {
            AdminPrivilegeObject privObj = AdminPrivilegeObject.newInstance(DataobjectManager.getInstance().getCurrentAdminPrivilege(true));
            GroupObject parentGroup = this.getParentGroup();
            boolean parentAccessible = true;
            if (parentGroup != null) {
                parentAccessible = parentGroup.isAccessible() && parentGroup.getAccessConstraint(true) != 1;
            }
            this.setAccessible(privObj.hasAccessRightToGroup(this.getId(), parentAccessible));
        }
        return this.isAccessible();
    }

    public void setAccessible(boolean accessible) {
        this.isAccessible = accessible;
        if (!accessible) {
            this.setDirectiveSelectable(false);
        }
    }

    public void setInherited(boolean isInherited) {
        this.isInherited = isInherited;
        this.isInheritedSet = true;
    }

    public void setDirty() {
        this.changed = true;
    }

    public boolean isDirty() {
        return this.changed;
    }

    public int getAccessConstraint() {
        return this.accessConstraint;
    }

    public void setAccessConstraint(int constraint) {
        this.accessConstraint = constraint;
    }

    public int getAccessConstraint(boolean refresh) {
        if (!refresh) {
            return this.getAccessConstraint();
        }
        AdminPrivilegeObject privObj = AdminPrivilegeObject.newInstance(DataobjectManager.getInstance().getCurrentAdminPrivilege(true));
        ArrayList<GroupObject> groups = new ArrayList<GroupObject>();
        groups.add(this);
        for (GroupObject parent = this.getParentGroup(); parent != null; parent = parent.getParentGroup()) {
            groups.add(parent);
        }
        int constraint = 0;
        int i = groups.size();
        while (--i >= 0) {
            GroupObject group = (GroupObject)groups.get(i);
            constraint = privObj.getGroupConstraint(group.getId(), constraint);
        }
        return constraint;
    }

    public String[] getSerialNumbers() {
        String[] serialNos = new String[]{EMPTY_STRING, EMPTY_STRING, EMPTY_STRING};
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)this.getId());
        try {
            SemTable semTable = GUIManager.getSemTable(1200, rpc, -1, -1);
            int rowCount = semTable.getSemTableRowCount();
            if (rowCount != 1) {
                return serialNos;
            }
            SemTableRow row = semTable.getSemTableRow(0);
            serialNos[0] = row.getSemTableValue(0).getValue();
            try {
                serialNos[1] = UIUtilities.formatDate(Long.parseLong(row.getSemTableValue(1).getValue()));
            }
            catch (NumberFormatException e) {
                LoggerUtilities.logException((Throwable)e);
            }
            serialNos[2] = row.getSemTableValue(2).getValue();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return serialNos;
    }

    public boolean isReadable() {
        int accessConstraint = this.getAccessConstraint(true);
        return accessConstraint == 0 || accessConstraint == 2;
    }

    public boolean isFullAccessible() {
        return this.getAccessConstraint(true) == 0;
    }

    public boolean isReadOnly() {
        return this.getAccessConstraint(true) == 2;
    }
}

