/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.GatewayEnforcement;
import com.sygate.scm.common.configobject.schema.GatewayEnforcerMode;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.LoggerUtilities;

public class GatewayEnforcerModeObject
extends AbstractUIObject {
    private GatewayEnforcerMode gatewayMode;

    public GatewayEnforcerModeObject(GatewayEnforcerMode gatewayMode) {
        this.gatewayMode = gatewayMode;
    }

    public static GatewayEnforcerModeObject newInstance(GatewayEnforcement gateway) {
        GatewayEnforcerMode newMode = new GatewayEnforcerMode();
        gateway.setOptGatewayEnforcerMode(newMode);
        return new GatewayEnforcerModeObject(newMode);
    }

    public String getModeString() {
        try {
            String mode = this.gatewayMode.getOptModeValue();
            return mode == null ? "ENFORCE" : mode;
        }
        catch (ValidationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return "";
        }
    }

    public int getMode() {
        Integer mode = this.gatewayMode.getOptMode();
        if (mode == null) {
            mode = this.gatewayMode.getDefMode();
        }
        return mode;
    }

    public void setMode(int mode) {
        if (mode != this.getMode()) {
            this.gatewayMode.setOptMode(Integer.valueOf(mode));
        }
    }
}

