/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AuthParameter;
import com.sygate.scm.common.configobject.schema.AuthSection;
import com.sygate.scm.common.configobject.schema.BypassARP;
import com.sygate.scm.common.configobject.schema.BypassDhcpRequest;
import com.sygate.scm.common.configobject.schema.BypassDnsRequest;
import com.sygate.scm.common.configobject.schema.BypassIpv6;
import com.sygate.scm.common.configobject.schema.BypassOtherProtocol;
import com.sygate.scm.common.configobject.schema.EnableNetworkTimeProtocol;
import com.sygate.scm.common.configobject.schema.EnforcerFailover;
import com.sygate.scm.common.configobject.schema.GatewayAllowLegacyClient;
import com.sygate.scm.common.configobject.schema.GatewayEnableLocalAuth;
import com.sygate.scm.common.configobject.schema.GatewayEnforcement;
import com.sygate.scm.common.configobject.schema.GatewayEnforcerMode;
import com.sygate.scm.common.configobject.schema.SEPMHealthCheck;
import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnableNetworkTimeProtocolObject;
import com.sygate.scm.console.logicobject.EnforcerAuthSectionObject;
import com.sygate.scm.console.logicobject.EnforcerBypassARPObject;
import com.sygate.scm.console.logicobject.EnforcerBypassDhcpObject;
import com.sygate.scm.console.logicobject.EnforcerBypassDnsObject;
import com.sygate.scm.console.logicobject.EnforcerBypassIpv6Object;
import com.sygate.scm.console.logicobject.EnforcerBypassOtherObject;
import com.sygate.scm.console.logicobject.EnforcerFailoverObject;
import com.sygate.scm.console.logicobject.EnforcerSEPMHealthCheckObject;
import com.sygate.scm.console.logicobject.GatewayEnforcerAllowLegacyClientObject;
import com.sygate.scm.console.logicobject.GatewayEnforcerEnableLocalAuthenticationObject;
import com.sygate.scm.console.logicobject.GatewayEnforcerModeObject;

public class GatewayEnforcementObject
extends AbstractUIObject {
    private GatewayEnforcement gateway;

    public GatewayEnforcementObject(GatewayEnforcement gateway) {
        this.gateway = gateway;
    }

    public static GatewayEnforcementObject newInstance(SeEnforcerPolicy policy) {
        GatewayEnforcement gateway = policy.getOptGatewayEnforcement();
        if (gateway == null) {
            gateway = new GatewayEnforcement();
            gateway.setAuthSection(GatewayEnforcementObject.createAuthSection());
            policy.setOptGatewayEnforcement(gateway);
        }
        return new GatewayEnforcementObject(gateway);
    }

    public EnforcerAuthSectionObject getAuthSectionObject() {
        return new EnforcerAuthSectionObject(this.gateway.getAuthSection());
    }

    public EnforcerFailoverObject getFailoverObject() {
        EnforcerFailover failover = this.gateway.getOptEnforcerFailover();
        if (failover == null) {
            return null;
        }
        return new EnforcerFailoverObject(failover);
    }

    public EnforcerBypassDhcpObject getBypassDhcpObject() {
        BypassDhcpRequest dhcp = this.gateway.getOptBypassDhcpRequest();
        if (dhcp == null) {
            return null;
        }
        return new EnforcerBypassDhcpObject(dhcp);
    }

    public EnforcerBypassDnsObject getBypassDnsObject() {
        BypassDnsRequest dns = this.gateway.getOptBypassDnsRequest();
        if (dns == null) {
            return null;
        }
        return new EnforcerBypassDnsObject(dns);
    }

    public EnforcerBypassARPObject getBypassARPObject() {
        BypassARP arp = this.gateway.getOptBypassARP();
        if (arp == null) {
            return null;
        }
        return new EnforcerBypassARPObject(arp);
    }

    public EnforcerBypassIpv6Object getBypassIpv6Object() {
        BypassIpv6 ipv6 = this.gateway.getOptBypassIpv6();
        if (ipv6 == null) {
            return null;
        }
        return new EnforcerBypassIpv6Object(ipv6);
    }

    public EnforcerBypassOtherObject getBypassOtherObject() {
        BypassOtherProtocol other = this.gateway.getOptBypassOtherProtocol();
        if (other == null) {
            return null;
        }
        return new EnforcerBypassOtherObject(other);
    }

    public GatewayEnforcerModeObject getGatewayEnforcerModeObject() {
        GatewayEnforcerMode mode = this.gateway.getOptGatewayEnforcerMode();
        if (mode == null) {
            return null;
        }
        return new GatewayEnforcerModeObject(mode);
    }

    public void setFailoverObject(boolean isEnabled, String port, int sensitiveLevel) {
        EnforcerFailoverObject failoverObj = this.getFailoverObject();
        if (failoverObj == null) {
            failoverObj = EnforcerFailoverObject.newInstance(this.gateway);
        }
        failoverObj.setEnabled(isEnabled);
        failoverObj.setPort(port);
        failoverObj.setSensitiveLevel(sensitiveLevel);
    }

    public void setBypassDhcpObject(boolean isEnabled) {
        EnforcerBypassDhcpObject dhcpObj = this.getBypassDhcpObject();
        if (dhcpObj == null) {
            dhcpObj = EnforcerBypassDhcpObject.newInstance(this.gateway);
        }
        dhcpObj.setEnabled(isEnabled);
    }

    public void setBypassDnsObject(boolean isEnabled) {
        EnforcerBypassDnsObject dnsObj = this.getBypassDnsObject();
        if (dnsObj == null) {
            dnsObj = EnforcerBypassDnsObject.newInstance(this.gateway);
        }
        dnsObj.setEnabled(isEnabled);
    }

    public void setBypassARPObject(boolean isEnabled) {
        EnforcerBypassARPObject arpObj = this.getBypassARPObject();
        if (arpObj == null) {
            arpObj = EnforcerBypassARPObject.newInstance(this.gateway);
        }
        arpObj.setEnabled(isEnabled);
    }

    public void setBypassIpv6Object(boolean isEnabled) {
        EnforcerBypassIpv6Object ipv6Obj = this.getBypassIpv6Object();
        if (ipv6Obj == null) {
            ipv6Obj = EnforcerBypassIpv6Object.newInstance(this.gateway);
        }
        ipv6Obj.setEnabled(isEnabled);
    }

    public void setBypassOtherObject(boolean isEnabled) {
        EnforcerBypassOtherObject otherObj = this.getBypassOtherObject();
        if (otherObj == null) {
            otherObj = EnforcerBypassOtherObject.newInstance(this.gateway);
        }
        otherObj.setEnabled(isEnabled);
    }

    public void setGatewayEnforcerModeObject(int mode) {
        GatewayEnforcerModeObject modeObj = this.getGatewayEnforcerModeObject();
        if (modeObj == null) {
            modeObj = GatewayEnforcerModeObject.newInstance(this.gateway);
        }
        modeObj.setMode(mode);
    }

    public void setBypassOtherFilterObject(String value) {
        EnforcerBypassOtherObject otherObj = this.getBypassOtherObject();
        if (otherObj == null) {
            otherObj = EnforcerBypassOtherObject.newInstance(this.gateway);
        }
        otherObj.setFilter(value);
    }

    public GatewayEnforcerAllowLegacyClientObject getAllowLegacyClientObject() {
        GatewayAllowLegacyClient schema = this.gateway.getOptGatewayAllowLegacyClient();
        if (schema == null) {
            return null;
        }
        return new GatewayEnforcerAllowLegacyClientObject(schema);
    }

    public void setAllowLegacyClientObject(boolean isEnabled) {
        GatewayEnforcerAllowLegacyClientObject obj = this.getAllowLegacyClientObject();
        if (obj == null) {
            obj = GatewayEnforcerAllowLegacyClientObject.newInstance(this.gateway);
        }
        obj.setEnabled(isEnabled);
    }

    public GatewayEnforcerEnableLocalAuthenticationObject getEnableLocalAuthenticationObject() {
        GatewayEnableLocalAuth schema = this.gateway.getOptGatewayEnableLocalAuth();
        if (schema == null) {
            return null;
        }
        return new GatewayEnforcerEnableLocalAuthenticationObject(schema);
    }

    public void setEnableLocalAuthenticationObject(boolean isEnabled) {
        GatewayEnforcerEnableLocalAuthenticationObject obj = this.getEnableLocalAuthenticationObject();
        if (obj == null) {
            obj = GatewayEnforcerEnableLocalAuthenticationObject.newInstance(this.gateway);
        }
        obj.setEnabled(isEnabled);
    }

    public EnableNetworkTimeProtocolObject getEnableNetworkTimeProtocolObject() {
        EnableNetworkTimeProtocol schema = this.gateway.getOptEnableNetworkTimeProtocol();
        if (schema == null) {
            return null;
        }
        return new EnableNetworkTimeProtocolObject(schema);
    }

    public void setEnableNetworkTimeProtocolObject(boolean isEnabled) {
        EnableNetworkTimeProtocolObject obj = this.getEnableNetworkTimeProtocolObject();
        if (obj == null) {
            obj = EnableNetworkTimeProtocolObject.newInstance(this.gateway);
        }
        obj.setEnabled(isEnabled);
    }

    public void setEnableNetworkTimeProtocolNPTServerObject(String value) {
        EnableNetworkTimeProtocolObject obj = this.getEnableNetworkTimeProtocolObject();
        if (obj == null) {
            obj = EnableNetworkTimeProtocolObject.newInstance(this.gateway);
        }
        obj.setNtpServer(value);
    }

    public EnforcerSEPMHealthCheckObject getEnforcerSEPMHealthCheckObject() {
        SEPMHealthCheck schema = this.gateway.getOptSEPMHealthCheck();
        if (schema == null) {
            return null;
        }
        return new EnforcerSEPMHealthCheckObject(schema);
    }

    public void setEnforcerSEPMHealthCheckEnable(boolean isEnabled) {
        EnforcerSEPMHealthCheckObject obj = this.getEnforcerSEPMHealthCheckObject();
        if (obj == null) {
            obj = EnforcerSEPMHealthCheckObject.newInstance(this.gateway);
        }
        obj.setEnabled(isEnabled);
    }

    public void setEnforcerSEPMHealthCheckTime(Integer value) {
        EnforcerSEPMHealthCheckObject obj = this.getEnforcerSEPMHealthCheckObject();
        if (obj == null) {
            obj = EnforcerSEPMHealthCheckObject.newInstance(this.gateway);
        }
        obj.setHealthCheckTime(value);
    }

    private static AuthSection createAuthSection() {
        AuthSection auth = new AuthSection();
        auth.setAuthParameter(new AuthParameter());
        return auth;
    }
}

