/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicyPool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.ArrayList;
import java.util.Vector;

public class FirewallPolicyPool
extends AppliablePolicyPool {
    public FirewallPolicyPool(SemDomain domain) throws ConsoleException {
        super(domain, 43);
    }

    public static FirewallPolicyPool getFirewallPolicyPool() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        return new FirewallPolicyPool(domain);
    }

    @Override
    protected void addPolicyPoolReference(ConfigObject policyPool, ObjReference objRef) throws ConsoleException {
        if (!(policyPool instanceof FwFirewallPolicyPool)) {
            throw new ConsoleException(302645248, 32);
        }
        ((FwFirewallPolicyPool)policyPool).addObjReference(objRef);
    }

    @Override
    protected Vector<ObjReference> getPolicyPoolReferences() {
        return ((FwFirewallPolicyPool)this.policyPool).getObjReference();
    }

    @Override
    protected void createSemPolicyPool() {
        this.policyPool = new FwFirewallPolicyPool();
        this.domainObjPool.setOptFwFirewallPolicyPool((FwFirewallPolicyPool)this.policyPool);
        this.updateObjSet.put(this.domain.getId(), this.domain);
    }

    @Deprecated
    public static ArrayList<FirewallRule> getAllFwPoliciesFromPolicyPool() throws ConsoleException {
        ArrayList<FirewallRule> firewallRules = new ArrayList<FirewallRule>();
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwFirewallPolicyPool firewallPolicyPool = objectPool.getOptFwFirewallPolicyPool();
        if (firewallPolicyPool != null) {
            Vector objReferences = firewallPolicyPool.getObjReference();
            int referenceCount = objReferences.size();
            for (int i = 0; i < referenceCount; ++i) {
                EnforcedFirewallRuleArray enforcedRule;
                String id;
                ObjReference groupReference = (ObjReference)objReferences.get(i);
                String type = groupReference.getTargetType();
                FwFirewallPolicy firewallPolicy = (FwFirewallPolicy)PolicyHandler.getObject(type, id = groupReference.getTargetId());
                FirewallRuleSystem ruleSystem = firewallPolicy.getOptFirewallRuleSystem();
                if (ruleSystem == null) continue;
                BaselineFirewallRuleArray baseRule = ruleSystem.getOptBaselineFirewallRuleArray();
                if (baseRule != null) {
                    Vector baseV = baseRule.getFirewallRule();
                    for (int j = 0; j < baseV.size(); ++j) {
                        FirewallRule rule = (FirewallRule)baseV.get(j);
                        firewallRules.add(rule);
                    }
                }
                if ((enforcedRule = ruleSystem.getOptEnforcedFirewallRuleArray()) == null) continue;
                Vector enforceV = enforcedRule.getFirewallRule();
                for (int j = 0; j < enforceV.size(); ++j) {
                    FirewallRule rule = (FirewallRule)enforceV.get(j);
                    firewallRules.add(rule);
                }
            }
        }
        return firewallRules;
    }
}

