/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.ExtLogContent;
import com.sygate.scm.common.configobject.schema.ExtLogContentEntity;
import com.sygate.scm.common.configobject.schema.ExtLogFileDump;
import com.sygate.scm.common.configobject.schema.ExtLogFileEntity;
import com.sygate.scm.common.configobject.schema.ExternalLogging;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SyslogServer;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.io.PrintStream;
import java.util.Vector;
import java.util.logging.Level;

public class ExternalLoggingObject {
    public static final int UPDATE_FREQUENCY_MIN_IN_SECS = 30;
    public static final int UPDATE_FREQUENCY_MAX_IN_SECS = 3600;
    public static final int SYSLOGSERVER_DEFAULT_UDP_PORT = 514;
    public static final int SYSLOGSERVER_DEFAULT_TCP_PORT = 1468;
    public static final int SYSLOGSERVER_DEFAULT_TLS_PORT = 6514;
    public static final int SYSLOGSERVER_PORT_MIN = 0;
    public static final int SYSLOGSERVER_PORT_MAX = 65535;
    public static final String SYSLOGSERVER_PROTOCOL_UDP_STRING = "UDP";
    public static final String SYSLOGSERVER_PROTOCOL_TCP_STRING = "TCP";
    public static final String SYSLOGSERVER_PROTOCOL_TLS_STRING = "TLS";
    public static final String SYSLOGSERVER_LINESEPARATOR_CR_STRING = "CR";
    public static final String SYSLOGSERVER_LINESEPARATOR_LF_STRING = "LF";
    public static final String SYSLOGSERVER_LINESEPARATOR_NULL_STRING = "NULL";
    public static final int SYSLOGSERVER_DEFAULT_FACILITY_NUMBER = 6;
    public static final int SYSLOGSERVER_LOG_FACILITY_NUMBER_MAX = 23;
    public static final int EXTLOGFILEENTITY_DEFAULT_MAXLOGSIZE = 1000;
    public static final int EXTLOGFILEENTITY_MAXLOGSIZE_MIN = 10;
    public static final int EXTLOGFILEENTITY_MAXLOGSIZE_MAX = Integer.MAX_VALUE;
    public static final String EXTLOGCONTENTENTITY_SEVERITY_CRITICAL = "0x0-0x3";
    public static final String EXTLOGCONTENTENTITY_SEVERITY_MAJOR = "0x4-0x7";
    public static final String EXTLOGCONTENTENTITY_SEVERITY_MINOR = "0x8-0xb";
    public static final String EXTLOGCONTENTENTITY_SEVERITY_INFO = "0xc-0xf";
    public static final int EXTLOGCONTENTENTITY_AGENT_SYSTEM_LEVEL_FATAL = 3;
    public static final int EXTLOGCONTENTENTITY_AGENT_SYSTEM_LEVEL_ERROR = 2;
    public static final int EXTLOGCONTENTENTITY_AGENT_SYSTEM_LEVEL_WARNING = 1;
    public static final int EXTLOGCONTENTENTITY_AGENT_SYSTEM_LEVEL_INFO = 0;
    public static final int EXTLOGCONTENTENTITY_ENFORCER_SYSTEM_LEVEL_FATAL = 3;
    public static final int EXTLOGCONTENTENTITY_ENFORCER_SYSTEM_LEVEL_ERROR = 2;
    public static final int EXTLOGCONTENTENTITY_ENFORCER_SYSTEM_LEVEL_WARNING = 1;
    public static final int EXTLOGCONTENTENTITY_ENFORCER_SYSTEM_LEVEL_INFO = 0;
    private ExternalLogging externalLogging;

    public ExternalLoggingObject() {
    }

    public ExternalLoggingObject(ExternalLogging externalLogging) {
        this.externalLogging = externalLogging;
    }

    public static ExternalLogging newInstance() {
        ExternalLogging externalLogging = new ExternalLogging();
        externalLogging.setOptEnable(Boolean.valueOf(true));
        SyslogServer syslogServer = new SyslogServer();
        syslogServer.setOptEnable(Boolean.valueOf(false));
        syslogServer.setServerAddress("");
        syslogServer.setOptPort(Integer.valueOf(514));
        syslogServer.setOptProtocol(SyslogServer.UDP);
        syslogServer.setOptLineSeparator(SyslogServer.CR);
        externalLogging.setOptSyslogServer(syslogServer);
        externalLogging.setExtLogMasterServer("");
        ExtLogContent extLogContent = new ExtLogContent();
        externalLogging.setExtLogContent(extLogContent);
        return externalLogging;
    }

    public boolean isValid() {
        return this.externalLogging != null;
    }

    public ExternalLogging getExternalLogging() {
        return this.externalLogging;
    }

    public int getUpdateFrequency() {
        if (this.externalLogging == null) {
            return 30;
        }
        Schedule schedule = this.externalLogging.getOptSchedule();
        if (schedule == null) {
            return 30;
        }
        int hours = 0;
        if (schedule.getOptStartHour() != null) {
            try {
                hours = Integer.parseInt(schedule.getOptStartHour());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        int minutes = 0;
        if (schedule.getOptStartMinute() != null) {
            minutes = schedule.getOptStartMinute();
        }
        int seconds = 0;
        if (schedule.getOptStartSecond() != null) {
            seconds = schedule.getOptStartSecond();
        }
        return hours * 3600 + minutes * 60 + seconds;
    }

    public void setUpdateFrequency(int seconds) {
        if (this.externalLogging == null) {
            return;
        }
        Schedule schedule = this.externalLogging.getOptSchedule();
        if (schedule == null) {
            schedule = new Schedule();
            this.externalLogging.setOptSchedule(schedule);
        }
        int hours = seconds / 3600;
        int remaining = seconds - hours * 3600;
        int minutes = remaining / 60;
        int secs = remaining - minutes * 60;
        schedule.setOptStartHour(String.valueOf(hours));
        schedule.setOptStartMinute(Integer.valueOf(minutes));
        schedule.setOptStartSecond(Integer.valueOf(secs));
    }

    public String getMasterLoggingServer() {
        if (this.externalLogging == null) {
            return "";
        }
        return this.externalLogging.getExtLogMasterServer();
    }

    public void setMasterLoggingServer(String server) {
        if (this.externalLogging == null) {
            return;
        }
        this.externalLogging.setExtLogMasterServer(server);
    }

    public SyslogServer getSyslogServer() {
        if (this.externalLogging == null) {
            return null;
        }
        return this.externalLogging.getOptSyslogServer();
    }

    public boolean isSyslogServerEnabled() {
        SyslogServer s = this.getSyslogServer();
        if (s == null) {
            return false;
        }
        if (s.getOptEnable() == null) {
            return false;
        }
        return s.getOptEnable();
    }

    public String getSyslogServerAddress() {
        SyslogServer s = this.getSyslogServer();
        if (s == null) {
            return "";
        }
        if (s.getServerAddress() == null) {
            return "";
        }
        return s.getServerAddress();
    }

    public int getSyslogServerPort() {
        SyslogServer s = this.getSyslogServer();
        if (s == null || s.getOptPort() == null) {
            return 514;
        }
        return s.getOptPort();
    }

    public int getSyslogServerFacilityNumber() {
        SyslogServer s = this.getSyslogServer();
        if (s == null || s.getOptFacilityNumber() == null) {
            return 6;
        }
        return s.getOptFacilityNumber();
    }

    public int getSyslogServerPotocol() {
        SyslogServer s = this.getSyslogServer();
        if (s == null || s.getOptProtocol() == null) {
            return SyslogServer.UDP;
        }
        return s.getOptProtocol();
    }

    public int getSyslogServerLineSeparator() {
        SyslogServer s = this.getSyslogServer();
        if (s == null || s.getOptLineSeparator() == null) {
            return SyslogServer.CR;
        }
        return s.getOptLineSeparator();
    }

    public String getSyslogServerPotocolDisplayString() {
        int protocol = this.getSyslogServerPotocol();
        if (protocol == SyslogServer.TCP) {
            return SYSLOGSERVER_PROTOCOL_TCP_STRING;
        }
        if (protocol == SyslogServer.TLS) {
            return SYSLOGSERVER_PROTOCOL_TLS_STRING;
        }
        return SYSLOGSERVER_PROTOCOL_UDP_STRING;
    }

    public String getSyslogServerLineSeparatorlDisplayString() {
        int lineSeparator = this.getSyslogServerLineSeparator();
        if (lineSeparator == SyslogServer.CR) {
            return SYSLOGSERVER_LINESEPARATOR_CR_STRING;
        }
        if (lineSeparator == SyslogServer.LF) {
            return SYSLOGSERVER_LINESEPARATOR_LF_STRING;
        }
        if (lineSeparator == SyslogServer.NULL) {
            return SYSLOGSERVER_LINESEPARATOR_NULL_STRING;
        }
        return SYSLOGSERVER_LINESEPARATOR_CR_STRING;
    }

    public int getSyslogServerPotocolFromDisplayString(String str) {
        if (SYSLOGSERVER_PROTOCOL_TCP_STRING.equalsIgnoreCase(str)) {
            return SyslogServer.TCP;
        }
        if (SYSLOGSERVER_PROTOCOL_TLS_STRING.equalsIgnoreCase(str)) {
            return SyslogServer.TLS;
        }
        return SyslogServer.UDP;
    }

    public int getSyslogServerLineSeparatorFromDisplayString(String str) {
        if (SYSLOGSERVER_LINESEPARATOR_CR_STRING.equalsIgnoreCase(str)) {
            return SyslogServer.CR;
        }
        if (SYSLOGSERVER_LINESEPARATOR_LF_STRING.equalsIgnoreCase(str)) {
            return SyslogServer.LF;
        }
        if (SYSLOGSERVER_LINESEPARATOR_NULL_STRING.equalsIgnoreCase(str)) {
            return SyslogServer.NULL;
        }
        return SyslogServer.CR;
    }

    public void setSyslog(boolean enabled, String serverAddress, String protocol, int port, int facilityNumber) {
        if (this.externalLogging == null) {
            return;
        }
        SyslogServer s = this.externalLogging.getOptSyslogServer();
        if (s == null) {
            s = new SyslogServer();
            this.externalLogging.setOptSyslogServer(s);
        }
        s.setOptEnable(Boolean.valueOf(enabled));
        if (enabled) {
            s.setServerAddress(serverAddress);
            s.setOptProtocol(Integer.valueOf(this.getSyslogServerPotocolFromDisplayString(protocol)));
            s.setOptPort(Integer.valueOf(port));
            s.setOptFacilityNumber(Integer.valueOf(facilityNumber));
        }
    }

    public void setSyslogServerLineSeparator(String lineSeparator) {
        if (this.externalLogging == null) {
            return;
        }
        SyslogServer s = this.externalLogging.getOptSyslogServer();
        if (s == null) {
            return;
        }
        s.setOptLineSeparator(Integer.valueOf(this.getSyslogServerLineSeparatorFromDisplayString(lineSeparator)));
    }

    public ExtLogFileDump getExtLogFileDump() {
        if (this.externalLogging == null) {
            return null;
        }
        return this.externalLogging.getOptExtLogFileDump();
    }

    public boolean isExtLogFileDumpEnabled() {
        ExtLogFileDump e = this.getExtLogFileDump();
        if (e == null) {
            return false;
        }
        if (e.getOptEnable() == null) {
            return false;
        }
        return e.getOptEnable();
    }

    public boolean isLimitDumpFileRecords() {
        ExtLogFileDump e = this.getExtLogFileDump();
        if (e == null) {
            return false;
        }
        if (e.getOptLimitDumpFileRecords() == null) {
            return false;
        }
        return e.getOptLimitDumpFileRecords();
    }

    public void setExtLogFileDump(boolean enabled, boolean limitDumpFileRecords) {
        if (this.externalLogging == null) {
            return;
        }
        ExtLogFileDump e = this.externalLogging.getOptExtLogFileDump();
        if (e == null) {
            e = new ExtLogFileDump();
            this.externalLogging.setOptExtLogFileDump(e);
        }
        e.setOptEnable(Boolean.valueOf(enabled));
        if (enabled) {
            e.setOptLimitDumpFileRecords(Boolean.valueOf(limitDumpFileRecords));
        }
    }

    public Vector<ExtLogFileEntity> getExtLogFileEntities() {
        ExtLogFileDump e = this.getExtLogFileDump();
        if (e == null) {
            return new Vector<ExtLogFileEntity>();
        }
        return e.getExtLogFileEntity();
    }

    public static ExtLogFileEntity getExtLogFileEntity(Vector<ExtLogFileEntity> extLogFileEntiies, Integer type) {
        if (extLogFileEntiies == null) {
            return null;
        }
        for (ExtLogFileEntity e : extLogFileEntiies) {
            if (!e.getLogType().equals(type)) continue;
            return e;
        }
        return null;
    }

    public static int getExtLogFileEntityMaxLogSize(Vector<ExtLogFileEntity> extLogFileEntiies, Integer type) {
        ExtLogFileEntity e = ExternalLoggingObject.getExtLogFileEntity(extLogFileEntiies, type);
        if (e == null || e.getOptMaxLogSize() == null) {
            return 1000;
        }
        return e.getOptMaxLogSize();
    }

    public void setExtLogFileEntity(int type, int maxLogSize) {
        this.setExtLogFileEntity((Integer)type, (Integer)maxLogSize);
    }

    public void setExtLogFileEntity(Integer type, Integer maxLogSize) {
        if (this.externalLogging == null) {
            return;
        }
        ExtLogFileDump extLogFileDump = this.externalLogging.getOptExtLogFileDump();
        if (extLogFileDump == null) {
            extLogFileDump = new ExtLogFileDump();
            this.externalLogging.setOptExtLogFileDump(extLogFileDump);
        }
        int count = extLogFileDump.getExtLogFileEntityCount();
        for (int i = 0; i < count; ++i) {
            ExtLogFileEntity e = extLogFileDump.getExtLogFileEntity(i);
            if (!e.getLogType().equals(type)) continue;
            e.setOptMaxLogSize(maxLogSize);
            return;
        }
        ExtLogFileEntity e = new ExtLogFileEntity();
        e.setLogType(type);
        e.setOptMaxLogSize(maxLogSize);
        extLogFileDump.addExtLogFileEntity(e);
    }

    public ExtLogContent getExtLogContent() {
        if (this.externalLogging == null) {
            return null;
        }
        return this.externalLogging.getExtLogContent();
    }

    public Vector<ExtLogContentEntity> getExtLogContentEntities() {
        ExtLogContent e = this.getExtLogContent();
        if (e == null) {
            return new Vector<ExtLogContentEntity>();
        }
        return e.getExtLogContentEntity();
    }

    public static ExtLogContentEntity getExtLogContentEntity(Vector<ExtLogContentEntity> extLogContentEntiies, Integer type) {
        if (extLogContentEntiies == null) {
            return null;
        }
        for (ExtLogContentEntity e : extLogContentEntiies) {
            if (!e.getLogType().equals(type)) continue;
            return e;
        }
        return null;
    }

    public static String getExtLogContentEntitySeverity(Vector<ExtLogContentEntity> extLogContentEntiies, Integer type) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, type);
        if (e == null || e.getOptSeverity() == null) {
            return "";
        }
        return e.getOptSeverity();
    }

    public void setExtLogContentEntity(Integer type, boolean enabled, String severity) {
        if (this.externalLogging == null) {
            return;
        }
        ExtLogContent extLogContent = this.externalLogging.getExtLogContent();
        if (extLogContent == null) {
            extLogContent = new ExtLogContent();
            this.externalLogging.setExtLogContent(extLogContent);
        }
        int count = extLogContent.getExtLogContentEntityCount();
        for (int i = 0; i < count; ++i) {
            ExtLogContentEntity e = extLogContent.getExtLogContentEntity(i);
            if (!e.getLogType().equals(type)) continue;
            e.setOptEnable(Boolean.valueOf(enabled));
            if (severity != null) {
                e.setOptSeverity(severity);
            }
            return;
        }
        ExtLogContentEntity e = new ExtLogContentEntity();
        e.setOptEnable(Boolean.valueOf(enabled));
        e.setLogType(type);
        if (severity != null) {
            e.setOptSeverity(severity);
        }
        extLogContent.addExtLogContentEntity(e);
    }

    public void setExtLogContentEntity(Integer type, boolean enabled, boolean critical, boolean major, boolean minor, boolean info) {
        IntegerSet is = new IntegerSet();
        try {
            if (critical) {
                is.addRange(EXTLOGCONTENTENTITY_SEVERITY_CRITICAL, 16);
            }
            if (major) {
                is.addRange(EXTLOGCONTENTENTITY_SEVERITY_MAJOR, 16);
            }
            if (minor) {
                is.addRange(EXTLOGCONTENTENTITY_SEVERITY_MINOR, 16);
            }
            if (info) {
                is.addRange(EXTLOGCONTENTENTITY_SEVERITY_INFO, 16);
            }
        }
        catch (BadFormatException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        String severity = is.toString(16, true);
        this.setExtLogContentEntity(type, enabled, severity);
    }

    public static boolean[] getExtLogContentEntity(Integer type, Vector<ExtLogContentEntity> extLogContentEntiies) {
        boolean[] enables = new boolean[5];
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, type);
        if (e == null || e.getOptSeverity() == null) {
            enables[0] = e == null || e.getOptEnable() == null ? false : e.getOptEnable();
            enables[1] = false;
            enables[2] = false;
            enables[3] = false;
            enables[4] = false;
        } else {
            enables[0] = e.getOptEnable() == null ? false : e.getOptEnable();
            String severity = e.getOptSeverity();
            try {
                IntegerSet s = new IntegerSet(severity, 16);
                enables[1] = s.containsRange(EXTLOGCONTENTENTITY_SEVERITY_CRITICAL, 16);
                enables[2] = s.containsRange(EXTLOGCONTENTENTITY_SEVERITY_MAJOR, 16);
                enables[3] = s.containsRange(EXTLOGCONTENTENTITY_SEVERITY_MINOR, 16);
                enables[4] = s.containsRange(EXTLOGCONTENTENTITY_SEVERITY_INFO, 16);
            }
            catch (BadFormatException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return enables;
    }

    public void setExtLogContentEntityForServerSystemLog(boolean enabled, boolean severe, boolean warning, boolean info) {
        IntegerSet is = new IntegerSet();
        if (severe) {
            is.add(Level.SEVERE.intValue());
        }
        if (warning) {
            is.add(Level.WARNING.intValue());
        }
        if (info) {
            is.add(Level.INFO.intValue());
        }
        String severity = is.toString(16, true);
        this.setExtLogContentEntity(ExtLogFileEntity.LT_SCM_SYSTEM_LOG, enabled, severity);
    }

    public static boolean[] getExtLogContentEntityForServerSystemLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        boolean[] enables = new boolean[4];
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_SCM_SYSTEM_LOG);
        if (e == null || e.getOptSeverity() == null) {
            enables[0] = e == null || e.getOptEnable() == null ? false : e.getOptEnable();
            enables[1] = false;
            enables[2] = false;
            enables[3] = false;
        } else {
            enables[0] = e.getOptEnable() == null ? false : e.getOptEnable();
            String severity = e.getOptSeverity();
            try {
                IntegerSet s = new IntegerSet(severity, 16);
                enables[1] = s.contains(Level.SEVERE.intValue());
                enables[2] = s.contains(Level.WARNING.intValue());
                enables[3] = s.contains(Level.INFO.intValue());
            }
            catch (BadFormatException e1) {
                LoggerUtilities.logException((Throwable)e1);
            }
        }
        return enables;
    }

    public void setExtLogContentEntityForServerAdminLog(boolean enabled, boolean severe, boolean warning, boolean info) {
        IntegerSet is = new IntegerSet();
        if (severe) {
            is.add(Level.SEVERE.intValue());
        }
        if (warning) {
            is.add(Level.WARNING.intValue());
        }
        if (info) {
            is.add(Level.INFO.intValue());
        }
        String severity = is.toString(16, true);
        this.setExtLogContentEntity(ExtLogFileEntity.LT_SCM_ADMIN_LOG, enabled, severity);
    }

    public static boolean[] getExtLogContentEntityForServerAdminLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        boolean[] enables = new boolean[4];
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_SCM_ADMIN_LOG);
        if (e == null || e.getOptSeverity() == null) {
            enables[0] = e == null || e.getOptEnable() == null ? false : e.getOptEnable();
            enables[1] = false;
            enables[2] = false;
            enables[3] = false;
        } else {
            enables[0] = e.getOptEnable() == null ? false : e.getOptEnable();
            String severity = e.getOptSeverity();
            try {
                IntegerSet s = new IntegerSet(severity, 16);
                enables[1] = s.contains(Level.SEVERE.intValue());
                enables[2] = s.contains(Level.WARNING.intValue());
                enables[3] = s.contains(Level.INFO.intValue());
            }
            catch (BadFormatException e1) {
                LoggerUtilities.logException((Throwable)e1);
            }
        }
        return enables;
    }

    public static boolean getExtLogContentEntityForServerClientActivityLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_SCM_AGENT_ACT_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForServerClientActivityLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_SCM_AGENT_ACT_LOG, enabled, null);
    }

    public static boolean getExtLogContentEntityForServerEnforcerActivityLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_SCM_ENFORCER_ACT_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForServerEnforcerActivityLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_SCM_ENFORCER_ACT_LOG, enabled, null);
    }

    public static boolean getExtLogContentEntityForServerPolicyLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_SCM_POLICY_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForServerPolicyLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_SCM_POLICY_LOG, enabled, null);
    }

    public void setExtLogContentEntityForAgentSecurityLog(boolean enabled, boolean critical, boolean major, boolean minor, boolean info) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_SECURITY_LOG, enabled, critical, major, minor, info);
    }

    public static boolean[] getExtLogContentEntityForAgentSecurityLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        return ExternalLoggingObject.getExtLogContentEntity(ExtLogFileEntity.LT_AGT_SECURITY_LOG, extLogContentEntiies);
    }

    public static boolean[] getExtLogContentEntityForAgentTrafficLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        return ExternalLoggingObject.getExtLogContentEntity(ExtLogFileEntity.LT_AGT_TRAFFIC_LOG, extLogContentEntiies);
    }

    public void setExtLogContentEntityForAgentTrafficLog(boolean enabled, boolean critical, boolean major, boolean minor, boolean info) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_TRAFFIC_LOG, enabled, critical, major, minor, info);
    }

    public static boolean getExtLogContentEntityForAgentPacketLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_AGT_PACKET_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForAgentPacketLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_PACKET_LOG, enabled, null);
    }

    public static boolean getExtLogContentEntityForAgentScanLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_AGT_SCAN_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForAgentScanLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_SCAN_LOG, enabled, null);
    }

    public static boolean getExtLogContentEntityForAgentRiskLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_AGT_RISK_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForAgentRiskLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_RISK_LOG, enabled, null);
    }

    public static boolean getExtLogContentEntityForAgentProActDetectLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_AGT_PROACTIVE_DETECT_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForAgentProActDetectLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_PROACTIVE_DETECT_LOG, enabled, null);
    }

    public void setExtLogContentEntityForAgentSystemLog(boolean enabled, boolean fatal, boolean error, boolean warning, boolean info) {
        IntegerSet is = new IntegerSet();
        if (fatal) {
            is.add(3);
        }
        if (error) {
            is.add(2);
        }
        if (warning) {
            is.add(1);
        }
        if (info) {
            is.add(0);
        }
        String severity = is.toString(16, true);
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_SYSTEM_LOG, enabled, severity);
    }

    public static boolean[] getExtLogContentEntityForAgentSystemLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        boolean[] enables = new boolean[5];
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_AGT_SYSTEM_LOG);
        if (e == null || e.getOptSeverity() == null) {
            enables[0] = e == null || e.getOptEnable() == null ? false : e.getOptEnable();
            enables[1] = false;
            enables[2] = false;
            enables[3] = false;
            enables[4] = false;
        } else {
            enables[0] = e.getOptEnable() == null ? false : e.getOptEnable();
            String severity = e.getOptSeverity();
            try {
                IntegerSet s = new IntegerSet(severity, 16);
                enables[1] = s.contains(3);
                enables[2] = s.contains(2);
                enables[3] = s.contains(1);
                enables[4] = s.contains(0);
            }
            catch (BadFormatException e1) {
                LoggerUtilities.logException((Throwable)e1);
            }
        }
        return enables;
    }

    public static boolean[] getExtLogContentEntityForAgentBehaviorLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        return ExternalLoggingObject.getExtLogContentEntity(ExtLogFileEntity.LT_AGT_BEHAVIOR_LOG, extLogContentEntiies);
    }

    public void setExtLogContentEntityForAgentBehaviorLog(boolean enabled, boolean critical, boolean major, boolean minor, boolean info) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_AGT_BEHAVIOR_LOG, enabled, critical, major, minor, info);
    }

    public static boolean getExtLogContentEntityForEnforcerTrafficLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_ENF_TRAFFIC_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForEnforcerTrafficLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_ENF_TRAFFIC_LOG, enabled, null);
    }

    public void setExtLogContentEntityForEnforcerSystemLog(boolean enabled, boolean fatal, boolean error, boolean warning, boolean info) {
        IntegerSet is = new IntegerSet();
        if (fatal) {
            is.add(3);
        }
        if (error) {
            is.add(2);
        }
        if (warning) {
            is.add(1);
        }
        if (info) {
            is.add(0);
        }
        String severity = is.toString(16, true);
        this.setExtLogContentEntity(ExtLogFileEntity.LT_ENF_SYSTEM_LOG, enabled, severity);
    }

    public static boolean[] getExtLogContentEntityForEnforcerSystemLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        boolean[] enables = new boolean[5];
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_ENF_SYSTEM_LOG);
        if (e == null || e.getOptSeverity() == null) {
            enables[0] = e == null || e.getOptEnable() == null ? false : e.getOptEnable();
            enables[1] = false;
            enables[2] = false;
            enables[3] = false;
            enables[4] = false;
        } else {
            enables[0] = e.getOptEnable() == null ? false : e.getOptEnable();
            String severity = e.getOptSeverity();
            try {
                IntegerSet s = new IntegerSet(severity, 16);
                enables[1] = s.contains(3);
                enables[2] = s.contains(2);
                enables[3] = s.contains(1);
                enables[4] = s.contains(0);
            }
            catch (BadFormatException e1) {
                LoggerUtilities.logException((Throwable)e1);
            }
        }
        return enables;
    }

    public static boolean getExtLogContentEntityForEnforcerClientActivityLog(Vector<ExtLogContentEntity> extLogContentEntiies) {
        ExtLogContentEntity e = ExternalLoggingObject.getExtLogContentEntity(extLogContentEntiies, ExtLogFileEntity.LT_ENF_CLIENT_ACT_LOG);
        return e == null || e.getOptEnable() == null ? false : e.getOptEnable();
    }

    public void setExtLogContentEntityForEnforcerClientActivityLog(boolean enabled) {
        this.setExtLogContentEntity(ExtLogFileEntity.LT_ENF_CLIENT_ACT_LOG, enabled, null);
    }

    public static void print(ExternalLoggingObject o, PrintStream p) {
        PrintStream oldOut = null;
        if (o == null) {
            System.out.println("==== ExternalLoggingObject is null!");
            return;
        }
        if (null != p) {
            oldOut = System.out;
            System.setOut(p);
        }
        System.out.println("================================================");
        System.out.println("==== ExternalLogging Properties: Begin");
        System.out.println("MasterLoggingServer=" + o.getMasterLoggingServer());
        System.out.println("UpdateFrequency=" + o.getUpdateFrequency());
        System.out.println("SyslogServer enabled=" + o.isSyslogServerEnabled());
        System.out.println("SyslogServer address=" + o.getSyslogServerAddress());
        System.out.println("SyslogServer protocol=" + o.getSyslogServerPotocol() + "(" + o.getSyslogServerPotocolDisplayString() + ")");
        System.out.println("SyslogServer port=" + o.getSyslogServerPort());
        System.out.println("SyslogServer facility number=" + o.getSyslogServerFacilityNumber());
        System.out.println("SyslogServer line separator=" + o.getSyslogServerLineSeparator());
        System.out.println("ExtLogFileDump enabled=" + o.isExtLogFileDumpEnabled());
        System.out.println("ExtLogFileDump LimitDumpFileRecords=" + o.isLimitDumpFileRecords());
        Vector<ExtLogFileEntity> extLogFileEntities = o.getExtLogFileEntities();
        System.out.println("ExtLogFileDump ExtLogFileEntities=" + extLogFileEntities.size());
        for (int i = 0; i < extLogFileEntities.size(); ++i) {
            ExtLogFileEntity e = extLogFileEntities.get(i);
            System.out.println("\t" + i + ", type=" + e.getLogType().toString() + ", max log size=" + (e.getOptMaxLogSize() == null ? "<unknown>" : e.getOptMaxLogSize().toString()));
        }
        Vector<ExtLogContentEntity> extLogContentEntities = o.getExtLogContentEntities();
        System.out.println("ExtLogContent entities=" + extLogFileEntities.size());
        for (int i = 0; i < extLogContentEntities.size(); ++i) {
            ExtLogContentEntity e = extLogContentEntities.get(i);
            System.out.println("\t" + i + ", type=" + e.getLogType().toString() + ", enabled=" + (e.getOptEnable() == null ? "<unknown>" : e.getOptEnable().toString()) + ", severity=" + (e.getOptSeverity() == null ? "<unknown>" : e.getOptSeverity().toString()));
        }
        System.out.println("==== ExternalLogging Properties: End");
        System.out.println("================================================");
        if (null != oldOut) {
            System.setOut(oldOut);
        }
    }
}

