/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.configobject.schema.ExternalCommunication;
import com.sygate.scm.common.configobject.schema.LuFtpProxy;
import com.sygate.scm.common.configobject.schema.LuHttpProxy;
import com.sygate.scm.common.configobject.schema.LuHttpsProxy;
import com.sygate.scm.common.configobject.schema.MacProxySettings;
import com.sygate.scm.common.configobject.schema.PrivateInsightServer;
import com.sygate.scm.common.configobject.schema.PrivateInsightServerGroup;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LowBandwidthObject;
import com.sygate.scm.console.logicobject.MacProxySettingsObject;
import com.sygate.scm.console.logicobject.PrivateInsightServerGroupObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuFtpProxyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuHttpProxyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuHttpsProxyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.MacLuHttpProxyObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Vector;

public class ExternalCommunicationObject
extends AbstractUIObject {
    ExternalCommunication externalCommunication;
    LuHttpProxyObject httpProxyObj;
    LuHttpsProxyObject httpsProxyObj;
    LuFtpProxyObject ftpProxyObj;
    LowBandwidthObject lowBandwidthObj;
    MacLuHttpProxyObject macHttpProxyObj;
    MacProxySettingsObject macProxySettingsObj;

    public ExternalCommunicationObject() {
        this.externalCommunication = this.getEmptyExternalCommunication();
        this.httpProxyObj = new LuHttpProxyObject(this.getHttpProxy());
        this.httpsProxyObj = new LuHttpsProxyObject(this.getHttpsProxy());
        this.ftpProxyObj = new LuFtpProxyObject(this.getFtpProxy());
        this.lowBandwidthObj = new LowBandwidthObject(this.getLowBandwidth());
        this.macProxySettingsObj = new MacProxySettingsObject(this.getMacProxySettings());
        this.macHttpProxyObj = new MacLuHttpProxyObject(this.getMacHttpProxy());
    }

    public ExternalCommunicationObject(ExternalCommunication externalCommunication) {
        this.externalCommunication = externalCommunication == null ? this.getEmptyExternalCommunication() : externalCommunication;
        this.httpProxyObj = new LuHttpProxyObject(this.getHttpProxy());
        this.httpsProxyObj = new LuHttpsProxyObject(this.getHttpsProxy());
        this.ftpProxyObj = new LuFtpProxyObject(this.getFtpProxy());
        this.lowBandwidthObj = new LowBandwidthObject(this.getLowBandwidth());
        this.macProxySettingsObj = new MacProxySettingsObject(this.getMacProxySettings());
        this.macHttpProxyObj = new MacLuHttpProxyObject(this.getMacHttpProxy());
    }

    public ExternalCommunicationObject getClone() throws ConsoleException {
        try {
            ExternalCommunication newCommunication = (ExternalCommunication)PolicyHandler.getCopyOfObj((ConfigObject)this.externalCommunication);
            ExternalCommunicationObject newObject = new ExternalCommunicationObject(newCommunication);
            return newObject;
        }
        catch (ConsoleException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public LuHttpProxyObject getHttpProxyObject() {
        return this.httpProxyObj;
    }

    public LuHttpsProxyObject getHttpsProxyObject() {
        return this.httpsProxyObj;
    }

    public LuFtpProxyObject getFtpProxyObject() {
        return this.ftpProxyObj;
    }

    public LowBandwidthObject getLowBandwidthObject() {
        return this.lowBandwidthObj;
    }

    public ExternalCommunication getExternalCommunication() {
        return this.externalCommunication;
    }

    public boolean isSubmissionsEnabled() {
        if (this.externalCommunication.getOptEnableSubmissions() == null) {
            return this.externalCommunication.getDefEnableSubmissions();
        }
        return this.externalCommunication.getOptEnableSubmissions();
    }

    public void setSubmissionsSetting(boolean submission) {
        this.externalCommunication.setOptEnableSubmissions(Boolean.valueOf(submission));
    }

    public boolean isMrCleanSubmissionsEnabled() {
        if (this.externalCommunication.getOptEnableMrCleanSubmissions() == null) {
            return this.externalCommunication.getDefEnableMrCleanSubmissions();
        }
        return this.externalCommunication.getOptEnableMrCleanSubmissions();
    }

    public void setMrCleanSubmissionSetting(boolean mrCleanReputationInfo) {
        this.externalCommunication.setOptEnableMrCleanSubmissions(Boolean.valueOf(mrCleanReputationInfo));
    }

    public boolean isAvSubmissionsEnabled() {
        if (this.externalCommunication.getOptEnableAVSubmissions() == null) {
            return this.externalCommunication.getDefEnableAVSubmissions();
        }
        return this.externalCommunication.getOptEnableAVSubmissions();
    }

    public void setAvSubmissionSetting(boolean avSampleSubmission) {
        this.externalCommunication.setOptEnableAVSubmissions(Boolean.valueOf(avSampleSubmission));
    }

    public boolean isAvSilentSubmissionsEnabled() {
        if (this.externalCommunication.getOptEnableAVSilentSubmissions() == null) {
            return this.externalCommunication.getDefEnableAVSilentSubmissions();
        }
        return this.externalCommunication.getOptEnableAVSilentSubmissions();
    }

    public void setAvSilentSubmissionSetting(boolean avSilentSubmission) {
        this.externalCommunication.setOptEnableAVSilentSubmissions(Boolean.valueOf(avSilentSubmission));
    }

    public boolean isSONARBadSubmissionsEnable() {
        if (this.externalCommunication.getOptEnableSONARBadSubmissions() == null) {
            return this.externalCommunication.getDefEnableSONARBadSubmissions();
        }
        return this.externalCommunication.getOptEnableSONARBadSubmissions();
    }

    public void setEnableSONARBadSubmissions(boolean badSubmissions) {
        this.externalCommunication.setOptEnableSONARBadSubmissions(Boolean.valueOf(badSubmissions));
    }

    public boolean isSONARGoodSubmissionsEnable() {
        if (this.externalCommunication.getOptEnableSONARGoodSubmissions() == null) {
            return this.externalCommunication.getDefEnableSONARGoodSubmissions();
        }
        return this.externalCommunication.getOptEnableSONARGoodSubmissions();
    }

    public boolean isSONARAdvGoodSubmissionsEnable() {
        if (this.externalCommunication.getOptEnableSONARAdvGoodSubmissions() == null) {
            return this.externalCommunication.getDefEnableSONARAdvGoodSubmissions();
        }
        return this.externalCommunication.getOptEnableSONARAdvGoodSubmissions();
    }

    public boolean isIntrusionPrevSubmissionsEnable() {
        if (this.externalCommunication.getOptEnableIntrusionPrevSubmissions() == null) {
            return this.externalCommunication.getDefEnableIntrusionPrevSubmissions();
        }
        return this.externalCommunication.getOptEnableIntrusionPrevSubmissions();
    }

    public boolean isClientDataSubmissionsEnable() {
        if (this.externalCommunication.getOptEnableClientDataSubmissions() == null) {
            return this.externalCommunication.getDefEnableClientDataSubmissions();
        }
        return this.externalCommunication.getOptEnableClientDataSubmissions();
    }

    public void setEnableSONARGoodSubmissions(boolean goodSubmissions) {
        this.externalCommunication.setOptEnableSONARGoodSubmissions(Boolean.valueOf(goodSubmissions));
    }

    public void setEnableSONARAdvGoodSubmissions(boolean advGoodSubmissions) {
        this.externalCommunication.setOptEnableSONARAdvGoodSubmissions(Boolean.valueOf(advGoodSubmissions));
    }

    public void setEnableIntrusionPrevSubmissions(boolean intrusionPrevSubmissions) {
        this.externalCommunication.setOptEnableIntrusionPrevSubmissions(Boolean.valueOf(intrusionPrevSubmissions));
    }

    public void setEnableClientDataSubmissions(boolean clientDataSubmissions) {
        this.externalCommunication.setOptEnableClientDataSubmissions(Boolean.valueOf(clientDataSubmissions));
    }

    public boolean isPrivateInsightServerEnable() {
        if (this.externalCommunication.getOptEnablePrivateInsightServer() == null) {
            return this.externalCommunication.getDefEnablePrivateInsightServer();
        }
        return this.externalCommunication.getOptEnablePrivateInsightServer();
    }

    public boolean isFailoverToSymantecServer() {
        if (this.externalCommunication.getOptEnableFailoverToSymantecServer() == null) {
            return this.externalCommunication.getDefEnableFailoverToSymantecServer();
        }
        return this.externalCommunication.getOptEnableFailoverToSymantecServer();
    }

    public void setEnablePrivateInsightServer(boolean enabled) {
        this.externalCommunication.setOptEnablePrivateInsightServer(Boolean.valueOf(enabled));
    }

    public boolean isStatPingsSubmissionsEnable() {
        if (this.externalCommunication.getOptEnableStatPings() == null) {
            return this.externalCommunication.getDefEnableStatPings();
        }
        return this.externalCommunication.getOptEnableStatPings();
    }

    public void setEnableStatPingsSubmission(boolean value) {
        this.externalCommunication.setOptEnableStatPings(Boolean.valueOf(value));
    }

    public boolean getLockEnableSubmissions() {
        return this.externalCommunication.getOptLockEnableSubmissions() == null ? this.externalCommunication.getDefLockEnableSubmissions() : this.externalCommunication.getOptLockEnableSubmissions();
    }

    public void setLockEnableSubmissions(boolean lockState) {
        this.externalCommunication.setOptLockEnableSubmissions(Boolean.valueOf(lockState));
    }

    public boolean isEnableFileSubmissions() {
        return Optional.ofNullable(this.externalCommunication.getOptEnableFileSubmissions()).orElse(this.externalCommunication.getDefEnableFileSubmissions());
    }

    public void setEnableFileSubmissions(boolean state) {
        this.externalCommunication.setOptEnableFileSubmissions(Boolean.valueOf(state));
    }

    public boolean isReputationEnabled() {
        if (this.externalCommunication.getOptEnableReputation() == null) {
            return this.externalCommunication.getDefEnableReputation();
        }
        return this.externalCommunication.getOptEnableReputation();
    }

    public void setReputationSetting(boolean reputation) {
        this.externalCommunication.setOptEnableReputation(Boolean.valueOf(reputation));
    }

    public boolean getLockEnableReputation() {
        return this.externalCommunication.getOptLockEnableReputation() == null ? this.externalCommunication.getDefLockEnableReputation() : this.externalCommunication.getOptLockEnableReputation();
    }

    public void setLockEnableReputation(boolean lockState) {
        this.externalCommunication.setOptLockEnableReputation(Boolean.valueOf(lockState));
    }

    public int getPrivateServerType() {
        return this.externalCommunication.getOptPrivateInsightServerType() == null ? this.externalCommunication.getDefPrivateInsightServerType().intValue() : this.externalCommunication.getOptPrivateInsightServerType().intValue();
    }

    public void setPrivateServerType(Integer value) {
        this.externalCommunication.setOptPrivateInsightServerType(value);
    }

    public void setOptEnableFailoverToSymantecServer(boolean enabled) {
        this.externalCommunication.setOptEnableFailoverToSymantecServer(Boolean.valueOf(enabled));
    }

    private ExternalCommunication getEmptyExternalCommunication() {
        ExternalCommunication extComm = new ExternalCommunication();
        return extComm;
    }

    private LuHttpProxy getHttpProxy() {
        LuHttpProxy http = this.externalCommunication.getOptLuHttpProxy();
        if (http == null) {
            http = new LuHttpProxy();
            http.setMode(LuHttpProxy.SYSTEM);
            this.externalCommunication.setOptLuHttpProxy(http);
        }
        return http;
    }

    private LuHttpsProxy getHttpsProxy() {
        LuHttpsProxy https = this.externalCommunication.getOptLuHttpsProxy();
        if (https == null) {
            https = new LuHttpsProxy();
            https.setMode(LuHttpProxy.SYSTEM);
            this.externalCommunication.setOptLuHttpsProxy(https);
        }
        return https;
    }

    private LuFtpProxy getFtpProxy() {
        LuFtpProxy ftp = this.externalCommunication.getOptLuFtpProxy();
        if (ftp == null) {
            ftp = new LuFtpProxy();
            ftp.setMode(LuFtpProxy.SYSTEM);
            this.externalCommunication.setOptLuFtpProxy(ftp);
        }
        return ftp;
    }

    private AmlLowBandwidth getLowBandwidth() {
        AmlLowBandwidth lowBandwidth = this.externalCommunication.getOptAmlLowBandwidth();
        if (lowBandwidth == null) {
            lowBandwidth = new AmlLowBandwidth();
            this.externalCommunication.setOptAmlLowBandwidth(lowBandwidth);
        }
        return lowBandwidth;
    }

    public MacLuHttpProxyObject getMacHttpProxyObject() {
        return this.macHttpProxyObj;
    }

    private LuHttpProxy getMacHttpProxy() {
        MacProxySettings macProxySettings = this.macProxySettingsObj.getSchemaObject();
        LuHttpProxy http = macProxySettings.getOptLuHttpProxy();
        if (http == null) {
            if (this.macProxySettingsObj.getCopyWindowsSettings().booleanValue()) {
                try {
                    http = (LuHttpProxy)PolicyHandler.getCopyOfObj((ConfigObject)this.externalCommunication.getOptLuHttpProxy());
                }
                catch (ConsoleException e) {
                    System.out.println("Exception while cloning Windows LU Proxy Settings");
                    LoggerUtilities.logException((Throwable)e);
                }
            }
            if (http == null) {
                http = new LuHttpProxy();
                http.setMode(MacLuHttpProxyObject.getDefaultMode());
            }
            macProxySettings.setOptLuHttpProxy(http);
        }
        return http;
    }

    private MacProxySettings getMacProxySettings() {
        MacProxySettings macProxySettings = this.externalCommunication.getOptMacProxySettings();
        if (macProxySettings == null) {
            macProxySettings = new MacProxySettings();
            macProxySettings.setOptUseWindowSettingsForMac(macProxySettings.getDefUseWindowSettingsForMac());
            this.externalCommunication.setOptMacProxySettings(macProxySettings);
        }
        return macProxySettings;
    }

    public MacProxySettingsObject getMacProxySettingsObject() {
        return this.macProxySettingsObj;
    }

    public PrivateInsightServerGroupObject[] getPrivateInsightServerGroupList() {
        int count = this.externalCommunication.getPrivateInsightServerGroupCount();
        Vector extGroup = this.externalCommunication.getPrivateInsightServerGroup();
        PrivateInsightServerGroupObject[] groupListObj = new PrivateInsightServerGroupObject[count];
        for (int i = 0; i < groupListObj.length; ++i) {
            groupListObj[i] = new PrivateInsightServerGroupObject(i, (PrivateInsightServerGroup)extGroup.get(i));
        }
        return groupListObj;
    }

    public void setAllServers(boolean bEnable) {
        for (PrivateInsightServerGroup serverGroup : this.externalCommunication.getPrivateInsightServerGroup()) {
            Vector serverList = serverGroup.getPrivateInsightServer();
            Enumeration e = serverList.elements();
            while (e.hasMoreElements()) {
                PrivateInsightServer server = (PrivateInsightServer)e.nextElement();
                server.setOptEnable(Boolean.valueOf(bEnable));
            }
        }
    }

    public void removePrivateInsightServerGroup(PrivateInsightServerGroup selectedGroup) {
        this.externalCommunication.removePrivateInsightServerGroup(selectedGroup);
    }

    public boolean hasPrivateInsightServer() {
        if (this.externalCommunication.getPrivateInsightServerGroupCount() > 0) {
            return this.externalCommunication.getPrivateInsightServerGroup(0).getPrivateInsightServer().size() > 0;
        }
        return false;
    }

    public boolean duplicateServerExists(String address) {
        for (PrivateInsightServerGroup serverGroup : this.externalCommunication.getPrivateInsightServerGroup()) {
            Vector serverList = serverGroup.getPrivateInsightServer();
            Enumeration e = serverList.elements();
            while (e.hasMoreElements()) {
                PrivateInsightServer extServer = (PrivateInsightServer)e.nextElement();
                if (!extServer.getAddress().equals(address)) continue;
                return true;
            }
        }
        return false;
    }

    public void addPrivateInsightServerGroup(PrivateInsightServerGroup newGroup) {
        this.externalCommunication.addPrivateInsightServerGroup(newGroup);
    }

    public void adjustPrivateInsightServerGroupList(PrivateInsightServerGroupObject groupObj) {
        PrivateInsightServerGroup group = groupObj.getPrivateInsightServerGroup();
        int index = groupObj.getPriority();
        this.externalCommunication.removePrivateInsightServerGroup(group);
        this.externalCommunication.addPrivateInsightServerGroup(index, group);
    }
}

