/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.Vlan;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.GUIDGenerator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class EnforcerVlanObject
extends AbstractUIObject {
    private static final Integer MIN_ARUBA_ID = 9000;
    private static final Integer MAX_ARUBA_ID = 9999;
    private static final String DEFAULT_ARUBA_NAME = "0000000000000000000000000000000000000000000000000000000000000000";
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    private Vlan vlan;
    private boolean isArubaModel;

    public EnforcerVlanObject(Vlan vlan) {
        this.vlan = vlan;
    }

    public static EnforcerVlanObject newInstance() {
        Vlan newVlan = new Vlan();
        newVlan.setId(new GUIDGenerator().getGUIDString());
        return new EnforcerVlanObject(newVlan);
    }

    protected Vlan getVlan() {
        return this.vlan;
    }

    private Integer getArubaVlanId(Collection<EnforcerVlanObject> allVlan) {
        ArrayList<Integer> arubaIds = new ArrayList<Integer>();
        for (EnforcerVlanObject vlanObj : allVlan) {
            Integer vlanId = vlanObj.getVlan().getVlanId();
            if (!this.isArubaId(vlanId)) continue;
            arubaIds.add(vlanId);
        }
        if (arubaIds.size() == 0) {
            return MIN_ARUBA_ID;
        }
        Collections.sort(arubaIds);
        int maxId = (Integer)arubaIds.get(arubaIds.size() - 1);
        if (maxId < MAX_ARUBA_ID) {
            return maxId + 1;
        }
        Integer id = MIN_ARUBA_ID;
        while (arubaIds.contains(id)) {
            id = id + 1;
        }
        return id;
    }

    private boolean isArubaId(Integer vlanId) {
        return vlanId >= MIN_ARUBA_ID && vlanId <= MAX_ARUBA_ID;
    }

    public void setArubaModel(boolean isArubaModel) {
        this.isArubaModel = isArubaModel;
    }

    public String toString() {
        if (this.isArubaModel) {
            String id = this.getVlanId(true);
            String name = this.getName();
            if (id.length() > 0 && name.length() > 0) {
                return MessageFormat.format(this.res.getString("EnforcerVlanObject.SwitchToVlanRole"), id, name);
            }
            if (id.length() > 0) {
                return MessageFormat.format(this.res.getString("EnforcerVlanObject.SwitchToVlan"), id);
            }
            if (name.length() > 0) {
                return MessageFormat.format(this.res.getString("EnforcerVlanObject.SwitchToRole"), name);
            }
            return "";
        }
        return MessageFormat.format(this.res.getString("EnforcerVlanObject.SwitchToVlan"), this.getName());
    }

    public String getId() {
        return this.vlan.getId();
    }

    public String getName() {
        String name = this.vlan.getName();
        return name == null || name.equals(DEFAULT_ARUBA_NAME) ? "" : name;
    }

    public String getCustomizedAttributes() {
        String attributes = this.vlan.getOptCustomizedAttributes();
        return attributes == null ? "" : attributes;
    }

    public boolean getEnableCustomizedAttributes() {
        Boolean enableCustomizedAttributes = this.vlan.getOptEnableCustomizedAttributes();
        if (enableCustomizedAttributes == null) {
            enableCustomizedAttributes = this.vlan.getDefEnableCustomizedAttributes();
        }
        return enableCustomizedAttributes;
    }

    public String getVlanId(boolean isDisplayMode) {
        Integer vlanId = this.vlan.getVlanId();
        return vlanId == null || isDisplayMode && this.isArubaId(vlanId) ? "" : vlanId.toString();
    }

    public void setName(String name) {
        if (!name.equals(this.vlan.getName())) {
            this.vlan.setName(name.length() == 0 ? DEFAULT_ARUBA_NAME : name);
        }
    }

    public void setCustomizedAttributes(String attributes) {
        if (!attributes.equals(this.getCustomizedAttributes())) {
            this.vlan.setOptCustomizedAttributes(attributes.length() == 0 ? null : attributes);
        }
    }

    public void setEnableCustomizedAttributes(boolean newValue) {
        this.vlan.setOptEnableCustomizedAttributes(Boolean.valueOf(newValue));
    }

    public void setVlanId(String id, Collection<EnforcerVlanObject> allVlan) {
        Integer vlanId = this.vlan.getVlanId();
        if (vlanId == null || !id.equals(this.vlan.getVlanId().toString())) {
            if (id.length() == 0) {
                this.vlan.setVlanId(this.getArubaVlanId(allVlan));
            } else {
                this.vlan.setVlanId(Integer.valueOf(id));
            }
        }
    }
}

