/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.common.configobject.schema.SeLog;
import com.sygate.scm.common.configobject.schema.SeSystemLogSetting;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class EnforcerSystemLogObject
extends AbstractUIObject {
    private SeSystemLogSetting log;

    public EnforcerSystemLogObject(SeSystemLogSetting log) {
        this.log = log;
    }

    public static EnforcerSystemLogObject newInstance(SeEnforcerPolicy policy) {
        SeLog log = policy.getSeLog();
        SeSystemLogSetting systemLog = new SeSystemLogSetting();
        log.setOptSeSystemLogSetting(systemLog);
        return new EnforcerSystemLogObject(systemLog);
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.log.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.log.getDefEnable();
        }
        return isEnabled;
    }

    public boolean isUpload() {
        Boolean isUpload = this.log.getOptUploadIt();
        if (isUpload == null) {
            isUpload = this.log.getDefUploadIt();
        }
        return isUpload;
    }

    public long getMaxLogSize() {
        Long size = this.log.getOptMaxLogSize();
        if (size == null) {
            size = this.log.getDefMaxLogSize();
        }
        long kbyte = size / 1024L;
        return kbyte;
    }

    public int getMaxLogDays() {
        Integer size = this.log.getOptMaxLogDays();
        return size == null ? -1 : size;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.log.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }

    public void setUpload(boolean isUpload) {
        if (isUpload != this.isUpload()) {
            this.log.setOptUploadIt(Boolean.valueOf(isUpload));
        }
    }

    public void setMaxLogSize(long maxLogSize) {
        if (maxLogSize < 0L) {
            maxLogSize = this.log.getDefMaxLogSize() / 1024L;
        }
        if (maxLogSize != this.getMaxLogSize()) {
            this.log.setOptMaxLogSize(Long.valueOf(maxLogSize * 1024L));
        }
    }

    public void setMaxLogDays(int maxLogDays) {
        if (maxLogDays != this.getMaxLogDays() && maxLogDays >= 0) {
            Integer logDays = maxLogDays;
            this.log.setOptMaxLogDays(logDays);
        }
    }
}

