/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.common.configobject.schema.SeLog;
import com.sygate.scm.common.configobject.schema.SeSyslogSetting;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class EnforcerSyslogObject
extends AbstractUIObject {
    private SeSyslogSetting sysLog = null;

    public EnforcerSyslogObject(SeSyslogSetting sysLogSetting) {
        this.sysLog = sysLogSetting;
    }

    public static EnforcerSyslogObject newInstance(SeEnforcerPolicy policy) {
        SeLog log = policy.getSeLog();
        SeSyslogSetting sysLog = new SeSyslogSetting();
        log.setOptSeSyslogSetting(sysLog);
        return new EnforcerSyslogObject(sysLog);
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.sysLog.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.sysLog.getDefEnable();
        }
        return isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.sysLog.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }

    public String getSyslogServer() {
        String logServer = this.sysLog.getOptSyslogServer();
        return logServer;
    }

    public void setSyslogServer(String value) {
        if (null != value && value.trim().length() > 0) {
            this.sysLog.setOptSyslogServer(value);
        }
    }

    public Integer getLevel() {
        Integer level = this.sysLog.getOptLevel();
        if (level == null) {
            level = this.sysLog.getDefLevel();
        }
        return level;
    }

    public void setLevel(Integer value) {
        if (null != value && value >= 0 && value < 8) {
            this.sysLog.setOptLevel(value);
        }
    }

    public Integer getOptFailureThreshhold() {
        Integer failureThreshhold = this.sysLog.getOptFailureThreshold();
        if (failureThreshhold == null) {
            failureThreshhold = this.sysLog.getDefFailureThreshold();
        }
        return failureThreshhold;
    }

    public void setOptFailureThreshhold(Integer value) {
        if (null != value && value >= 0) {
            this.sysLog.setOptFailureThreshold(value);
        }
    }

    public Integer getOptFailureInteval() {
        Integer failureInteval = this.sysLog.getOptFailureInterval();
        if (failureInteval == null) {
            failureInteval = this.sysLog.getDefFailureInterval();
        }
        return failureInteval;
    }

    public void setOptFailureInteval(Integer value) {
        if (null != value && value >= 0) {
            this.sysLog.setOptFailureInterval(value);
        }
    }

    public Integer getOptAliveInterval() {
        Integer aliveInterval = this.sysLog.getOptAliveInterval();
        if (aliveInterval == null) {
            aliveInterval = this.sysLog.getDefAliveInterval();
        }
        return aliveInterval;
    }

    public void setOptAliveInterval(Integer value) {
        if (null != value && value >= 0) {
            this.sysLog.setOptAliveInterval(value);
        }
    }

    public void reset() {
        this.sysLog = new SeSyslogSetting();
    }
}

