/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.SeSwitchEnforcementPolicy;
import com.sygate.scm.common.configobject.schema.SwitchEnforcementRule;
import com.sygate.scm.common.configobject.schema.SwitchEnforcementRuleSystem;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchRuleObject;
import com.sygate.scm.util.GUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class EnforcerSwitchPolicyObject
extends AbstractUIObject {
    private SeSwitchEnforcementPolicy policy;

    public EnforcerSwitchPolicyObject(SeSwitchEnforcementPolicy policy) {
        this.policy = policy;
    }

    public static EnforcerSwitchPolicyObject newInstance(String switchGroupName) {
        SeSwitchEnforcementPolicy newPolicy = new SeSwitchEnforcementPolicy();
        newPolicy.setId(new GUIDGenerator().getGUIDString());
        newPolicy.setName(switchGroupName);
        newPolicy.setSwitchEnforcementRuleSystem(new SwitchEnforcementRuleSystem());
        return new EnforcerSwitchPolicyObject(newPolicy);
    }

    public String getId() {
        return this.policy.getId();
    }

    public String getName() {
        String name = this.policy.getName();
        return name == null ? "" : name;
    }

    public Collection<EnforcerSwitchRuleObject> getSwitchRulesObj() {
        ArrayList<EnforcerSwitchRuleObject> rulesObj = new ArrayList<EnforcerSwitchRuleObject>();
        SwitchEnforcementRuleSystem rules = this.policy.getSwitchEnforcementRuleSystem();
        for (int i = 0; i < rules.getSwitchEnforcementRuleCount(); ++i) {
            rulesObj.add(new EnforcerSwitchRuleObject(rules.getSwitchEnforcementRule(i)));
        }
        return rulesObj;
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.policy.setName(name);
        }
    }

    public void setSwitchRulesObj(Collection<EnforcerSwitchRuleObject> rules) {
        SwitchEnforcementRuleSystem ruleSystem = this.policy.getSwitchEnforcementRuleSystem();
        Vector oldRules = ruleSystem.getSwitchEnforcementRule();
        int i = oldRules.size();
        while (--i >= 0) {
            ruleSystem.removeSwitchEnforcementRule((SwitchEnforcementRule)oldRules.get(i));
        }
        Iterator<EnforcerSwitchRuleObject> itr = rules.iterator();
        while (itr.hasNext()) {
            ruleSystem.addSwitchEnforcementRule(itr.next().getSwitchRule());
        }
    }

    public void updateVlanGUID(Map<String, String> idMap) {
        SwitchEnforcementRuleSystem ruleSystem = this.policy.getSwitchEnforcementRuleSystem();
        for (int i = 0; i < ruleSystem.getSwitchEnforcementRuleCount(); ++i) {
            String newId;
            SwitchEnforcementRule rule = ruleSystem.getSwitchEnforcementRule(i);
            if (rule.getAction().intValue() != SwitchEnforcementRule.ASSIGN_VLAN.intValue() || (newId = idMap.get(rule.getOptVlanGuid())) == null) continue;
            rule.setOptVlanGuid(newId);
        }
    }

    protected SeSwitchEnforcementPolicy getSwitchPolicy() {
        return this.policy;
    }
}

