/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.LanEnforcement;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroup;
import com.sygate.scm.common.configobject.schema.SeSwitchEnforcementPolicy;
import com.sygate.scm.common.configobject.schema.SwitchGroup;
import com.sygate.scm.common.configobject.schema.SwitchGroupTree;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchCharacteristicObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchGroupObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchPolicyObject;
import com.sygate.scm.console.logicobject.RadiusServerGroupObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EnforcerSwitchGroupTreeObject
extends AbstractUIObject {
    private SwitchGroupTree groupTree;

    public EnforcerSwitchGroupTreeObject(SwitchGroupTree groupTree) {
        this.groupTree = groupTree;
    }

    public static EnforcerSwitchGroupTreeObject newInstance(LanEnforcement lan) {
        SwitchGroupTree newGroupTree = new SwitchGroupTree();
        lan.setOptSwitchGroupTree(newGroupTree);
        return new EnforcerSwitchGroupTreeObject(newGroupTree);
    }

    public Collection<EnforcerSwitchGroupObject> getSwitchGroupsObject() {
        ArrayList<EnforcerSwitchGroupObject> groups = new ArrayList<EnforcerSwitchGroupObject>();
        for (int i = 0; i < this.groupTree.getSwitchGroupCount(); ++i) {
            groups.add(new EnforcerSwitchGroupObject(this.groupTree.getSwitchGroup(i)));
        }
        return groups;
    }

    public void setSwitchGroups(Collection<EnforcerSwitchGroupObject> groupObjs) {
        for (EnforcerSwitchGroupObject oldGroup : this.getSwitchGroupsObject()) {
            EnforcerSwitchGroupObject matchGroup = this.findMatchingGroup(oldGroup.getId(), groupObjs);
            if (matchGroup != null) {
                this.editSwitchGroup(matchGroup);
                groupObjs.remove(matchGroup);
                continue;
            }
            this.removeSwitchGroup(oldGroup.getSwitchGroup());
        }
        Iterator<EnforcerSwitchGroupObject> itr = groupObjs.iterator();
        while (itr.hasNext()) {
            this.addSwitchGroup(itr.next());
        }
    }

    public List<SeSwitchEnforcementPolicy> getSwitchEnforcementPolicies() {
        ArrayList<SeSwitchEnforcementPolicy> sePolicies = new ArrayList<SeSwitchEnforcementPolicy>();
        for (EnforcerSwitchGroupObject group : this.getSwitchGroupsObject()) {
            EnforcerSwitchPolicyObject switchPolicyObj = group.getSwitchPolicyObject(false);
            if (switchPolicyObj == null) continue;
            sePolicies.add(switchPolicyObj.getSwitchPolicy());
        }
        return sePolicies;
    }

    public List<SeRadiusServerGroup> getRadiusServerGroups() {
        ArrayList<SeRadiusServerGroup> rsGroups = new ArrayList<SeRadiusServerGroup>();
        ArrayList<String> exportedRS = new ArrayList<String>();
        for (EnforcerSwitchGroupObject group : this.getSwitchGroupsObject()) {
            SeRadiusServerGroup rsGroup;
            EnforcerSwitchCharacteristicObject switchCharObj = group.getSwitchCharacteristicObject();
            RadiusServerGroupObject rsGroupObj = switchCharObj.getRdiusServerGroupObject();
            if (rsGroupObj == null || (rsGroup = rsGroupObj.getRadiusServerGroup()) == null || exportedRS.contains(rsGroup.getId())) continue;
            rsGroups.add(rsGroup);
            exportedRS.add(rsGroup.getId());
        }
        return rsGroups;
    }

    private EnforcerSwitchGroupObject findMatchingGroup(String id, Collection<EnforcerSwitchGroupObject> groupObjs) {
        EnforcerSwitchGroupObject groupObj2 = null;
        for (EnforcerSwitchGroupObject groupObj2 : groupObjs) {
            if (!id.equals(groupObj2.getId())) continue;
            return groupObj2;
        }
        return null;
    }

    private void addSwitchGroup(EnforcerSwitchGroupObject group) {
        this.groupTree.addSwitchGroup(group.getSwitchGroup());
        EnforcerSwitchPolicyObject policyObj = group.getCachedSwitchPolicyObject();
        try {
            DataobjectManager.getInstance().addObject((TopLevelObject)policyObj.getSwitchPolicy());
        }
        catch (ConsoleException ex) {
            System.err.println("EnforcerGroupTreeObject->addSwitchGroup: can't add policy to database\n" + ex);
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void removeSwitchGroup(SwitchGroup group) {
        this.groupTree.removeSwitchGroup(group);
        try {
            ObjReference objRef = group.getObjReference();
            if (objRef != null) {
                SeSwitchEnforcementPolicy policy = (SeSwitchEnforcementPolicy)DataobjectManager.getInstance().getObjectByGUID("SeSwitchEnforcementPolicy", objRef.getTargetId());
                DataobjectManager.getInstance().deleteObject((TopLevelObject)policy);
            }
        }
        catch (ConsoleException ex) {
            System.err.println("EnforcerGroupTreeObject->removeSwitchGroup: can't delete switch policy from database\n" + ex);
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void editSwitchGroup(EnforcerSwitchGroupObject matchGroup) {
        try {
            SeSwitchEnforcementPolicy policy = matchGroup.getSwitchPolicyObject(false).getSwitchPolicy();
            if (policy != null) {
                DataobjectManager.getInstance().updateObject("Overwrite", (TopLevelObject)policy);
            }
        }
        catch (ConsoleException ex) {
            System.err.println("EnforcerGroupTreeObject->editSwitchGroup: can't update switch policy from database\n" + ex);
            LoggerUtilities.logException((Throwable)ex);
        }
    }
}

