/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SeSwitchEnforcementPolicy;
import com.sygate.scm.common.configobject.schema.SwitchAddressList;
import com.sygate.scm.common.configobject.schema.SwitchCharacteristic;
import com.sygate.scm.common.configobject.schema.SwitchGroup;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchAddressListObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchCharacteristicObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchPolicyObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;

public class EnforcerSwitchGroupObject
extends AbstractUIObject {
    private SwitchGroup group;
    private EnforcerSwitchPolicyObject policyObj;
    private boolean isEnabled;

    public EnforcerSwitchGroupObject(SwitchGroup group) {
        this.group = group;
        this.isEnabled = this.initializeEnabled();
    }

    public static EnforcerSwitchGroupObject newInstance() {
        SwitchGroup newGroup = new SwitchGroup();
        newGroup.setId(new GUIDGenerator().getGUIDString());
        newGroup.setSwitchCharacteristic(new SwitchCharacteristic());
        newGroup.setSwitchAddressList(new SwitchAddressList());
        return new EnforcerSwitchGroupObject(newGroup);
    }

    protected SwitchGroup getSwitchGroup() {
        if (this.isEnabled != this.initializeEnabled()) {
            this.group.setOptEnable(Boolean.valueOf(this.isEnabled));
        }
        return this.group;
    }

    private boolean initializeEnabled() {
        Boolean isEnabled = this.group.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.group.getDefEnable();
        }
        return isEnabled;
    }

    public EnforcerSwitchPolicyObject getCachedSwitchPolicyObject() {
        return this.policyObj;
    }

    public String getId() {
        return this.group.getId();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getName() {
        String name = this.group.getName();
        return name == null ? "" : name;
    }

    public EnforcerSwitchPolicyObject getSwitchPolicyObject(boolean alwaysGet) {
        block6: {
            ObjReference objRef = this.group.getObjReference();
            if (objRef == null) {
                if (alwaysGet) {
                    objRef = new ObjReference();
                    objRef.setName("AppliedSwitchPolicy");
                    objRef.setTargetType("SeSwitchEnforcementPolicy");
                    this.policyObj = EnforcerSwitchPolicyObject.newInstance(this.group.getName());
                    objRef.setTargetId(this.policyObj.getId());
                    this.group.setObjReference(objRef);
                } else {
                    return null;
                }
            }
            if (this.policyObj != null) {
                return this.policyObj;
            }
            try {
                SeSwitchEnforcementPolicy policy = (SeSwitchEnforcementPolicy)DataobjectManager.getInstance().getObjectByGUID("SeSwitchEnforcementPolicy", objRef.getTargetId());
                this.policyObj = policy == null ? null : new EnforcerSwitchPolicyObject(policy);
            }
            catch (ConsoleException ex) {
                if (!alwaysGet) break block6;
                this.policyObj = EnforcerSwitchPolicyObject.newInstance(this.group.getName());
                objRef.setTargetId(this.policyObj.getId());
            }
        }
        return this.policyObj;
    }

    public EnforcerSwitchCharacteristicObject getSwitchCharacteristicObject() {
        return new EnforcerSwitchCharacteristicObject(this.group.getSwitchCharacteristic());
    }

    public EnforcerSwitchAddressListObject getSwitchAddressListObject() {
        return new EnforcerSwitchAddressListObject(this.group.getSwitchAddressList());
    }

    public void setEnabled(boolean isEnabled) {
        this.group.setOptEnable(Boolean.valueOf(isEnabled));
        this.isEnabled = isEnabled;
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.group.setName(name);
            EnforcerSwitchPolicyObject policyObj = this.getSwitchPolicyObject(false);
            if (policyObj != null) {
                policyObj.setName(name);
            }
        }
    }
}

