/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroup;
import com.sygate.scm.common.configobject.schema.SwitchCharacteristic;
import com.sygate.scm.common.configobject.schema.Vlan;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerVlanObject;
import com.sygate.scm.console.logicobject.RadiusServerGroupObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class EnforcerSwitchCharacteristicObject
extends AbstractUIObject {
    private SwitchCharacteristic switchChar;

    public EnforcerSwitchCharacteristicObject(SwitchCharacteristic switchChar) {
        this.switchChar = switchChar;
    }

    public boolean updateRadiusServerReferenceIds(HashMap<String, String> rsGroupIdMap) {
        String id;
        ObjReference objRef = this.switchChar.getObjReference();
        if (objRef != null && rsGroupIdMap.containsKey(id = objRef.getTargetId())) {
            objRef.setTargetId(rsGroupIdMap.get(id));
            return true;
        }
        return false;
    }

    public int getModel() {
        Integer model = this.switchChar.getOptModel();
        if (model == null) {
            model = this.switchChar.getDefModel();
        }
        return model;
    }

    public String getModelValue() {
        try {
            String model = this.switchChar.getOptModelValue();
            model = model == null ? "OTHERS" : model;
            model = model.equals("SW_EXTERME") ? "SW_EXTREME" : model;
            return model;
        }
        catch (ValidationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return "OTHERS";
        }
    }

    public String getSharedSecret() {
        return this.switchChar.getSharedSecret();
    }

    public String getReauthTimeout() {
        Integer timeout = this.switchChar.getOptReauthTimeout();
        if (timeout == null) {
            timeout = this.switchChar.getDefReauthTimeout();
        }
        return timeout.toString();
    }

    public boolean getForwardNonEapAttribute() {
        Boolean attribute = this.switchChar.getOptForwardNonEapAttribute();
        if (attribute == null) {
            attribute = this.switchChar.getDefForwardNonEapAttribute();
        }
        return attribute;
    }

    public RadiusServerGroupObject getRdiusServerGroupObject() {
        ObjReference objRef = this.switchChar.getObjReference();
        if (objRef == null) {
            return null;
        }
        try {
            SeRadiusServerGroup radiusGroup = DataobjectManager.getInstance().getSeRadiusServerGroup(objRef.getTargetId());
            return new RadiusServerGroupObject(radiusGroup);
        }
        catch (ConsoleException ex) {
            System.err.println("EnforcerSwitchCharacteristicObject->getUsingRdiusServerGroupName: radius server group is null");
            return null;
        }
    }

    public String getUsingRdiusServerGroupId() {
        RadiusServerGroupObject rsGroupObj = this.getRdiusServerGroupObject();
        return rsGroupObj == null ? "" : rsGroupObj.getId();
    }

    public String getObjReferenceTargetId() {
        ObjReference objRef = this.switchChar.getObjReference();
        if (objRef == null) {
            return null;
        }
        return objRef.getTargetId();
    }

    public Collection<EnforcerVlanObject> getVlansObj() {
        ArrayList<EnforcerVlanObject> vlans = new ArrayList<EnforcerVlanObject>();
        for (int i = 0; i < this.switchChar.getVlanCount(); ++i) {
            vlans.add(new EnforcerVlanObject(this.switchChar.getVlan(i)));
        }
        return vlans;
    }

    public void setModel(int model) {
        if (model != this.getModel()) {
            this.switchChar.setOptModel(Integer.valueOf(model));
        }
    }

    public void setSharedSecret(String secret) {
        if (!secret.equals(this.getSharedSecret())) {
            this.switchChar.setSharedSecret(secret);
        }
    }

    public void setReauthTimeout(String timeout) {
        if (timeout.length() == 0) {
            timeout = this.switchChar.getDefReauthTimeout().toString();
        }
        if (!timeout.equals(this.getReauthTimeout())) {
            this.switchChar.setOptReauthTimeout(Integer.valueOf(timeout));
        }
    }

    public void setForwardNonEapAttribute(boolean attribute) {
        if (attribute != this.getForwardNonEapAttribute()) {
            this.switchChar.setOptForwardNonEapAttribute(Boolean.valueOf(attribute));
        }
    }

    public void setObjReference(String radiusServerGroupId) {
        ObjReference objRef = this.switchChar.getObjReference();
        if (objRef == null) {
            objRef = new ObjReference();
            objRef.setName("OrginalRadiusSrvForSwitch");
            objRef.setTargetType("SeRadiusServerGroup");
            this.switchChar.setObjReference(objRef);
        }
        if (!radiusServerGroupId.equals(objRef.getTargetId())) {
            objRef.setTargetId(radiusServerGroupId);
        }
    }

    public void setVlansObj(Collection<EnforcerVlanObject> vlans) {
        Vector oldVlans = this.switchChar.getVlan();
        int i = oldVlans.size();
        while (--i >= 0) {
            this.switchChar.removeVlan((Vlan)oldVlans.get(i));
        }
        Iterator<EnforcerVlanObject> itr = vlans.iterator();
        while (itr.hasNext()) {
            this.switchChar.addVlan(itr.next().getVlan());
        }
    }
}

