/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.configobject.schema.SwitchAddressList;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.IpAddressRangeSubNetObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class EnforcerSwitchAddressListObject
extends AbstractUIObject {
    private SwitchAddressList switchAddressList;

    public EnforcerSwitchAddressListObject(SwitchAddressList switchAddressList) {
        this.switchAddressList = switchAddressList;
    }

    public String getAllAddressesString() {
        StringBuffer buf = new StringBuffer();
        Iterator<IpAddressRangeSubNetObject> addresses = this.getAllAddresses().iterator();
        while (addresses.hasNext()) {
            buf.append("; " + addresses.next().getAddressString());
        }
        return buf.length() > 0 ? buf.substring(2) : "";
    }

    public Collection<IpAddressRangeSubNetObject> getAllAddresses() {
        int i;
        ArrayList<IpAddressRangeSubNetObject> address = new ArrayList<IpAddressRangeSubNetObject>();
        for (i = 0; i < this.switchAddressList.getIpAddressCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.switchAddressList.getIpAddress(i)));
        }
        for (i = 0; i < this.switchAddressList.getSubNetCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.switchAddressList.getSubNet(i)));
        }
        for (i = 0; i < this.switchAddressList.getIpRangeCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.switchAddressList.getIpRange(i)));
        }
        return address;
    }

    public void setAllAddress(Collection<IpAddressRangeSubNetObject> address) {
        Vector oldAddress = this.switchAddressList.getIpAddress();
        int i = oldAddress.size();
        while (--i >= 0) {
            this.switchAddressList.removeIpAddress((IpAddress)oldAddress.get(i));
        }
        Vector subnet = this.switchAddressList.getSubNet();
        int i2 = subnet.size();
        while (--i2 >= 0) {
            this.switchAddressList.removeSubNet((SubNet)subnet.get(i2));
        }
        Vector ipRange = this.switchAddressList.getIpRange();
        int i3 = ipRange.size();
        while (--i3 >= 0) {
            this.switchAddressList.removeIpRange((IpRange)ipRange.get(i3));
        }
        Iterator<IpAddressRangeSubNetObject> itr = address.iterator();
        while (itr.hasNext()) {
            Object item = itr.next().getAddress();
            if (item instanceof IpAddress) {
                this.switchAddressList.addIpAddress((IpAddress)item);
                continue;
            }
            if (item instanceof SubNet) {
                this.switchAddressList.addSubNet((SubNet)item);
                continue;
            }
            this.switchAddressList.addIpRange((IpRange)item);
        }
    }
}

