/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ExternalNicInfo;
import com.sygate.scm.common.configobject.schema.InternalNicInfo;
import com.sygate.scm.common.configobject.schema.SemEnforcerState;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.IpAddressRangeSubNetObject;
import com.sygate.scm.util.LoggerUtilities;

public class EnforcerStateObject
extends AbstractUIObject {
    private SemEnforcerState state;

    public EnforcerStateObject(SemEnforcerState state) {
        this.state = state;
    }

    public String getVersion() {
        String version = this.state.getOptSemEnforcerProductVersion();
        return version == null ? "" : version;
    }

    public String getOS() {
        String os = this.state.getOptOS();
        return os == null ? "" : os;
    }

    public String getStatus() {
        return this.getStatusString(this.isOnline());
    }

    private String getStatusString(boolean isOnline) {
        return isOnline ? "Online" : "Offline";
    }

    public boolean isOnline() {
        Integer status = this.state.getOptStatus();
        System.out.println("status = " + (String)(status == null ? "null" : "" + status));
        return SemEnforcerState.ONLINE.equals(status) && !this.isTimeExpired();
    }

    private boolean isTimeExpired() {
        boolean isTimeExpired = false;
        Long checkedTime = this.state.getOptLastCheckpointTime();
        long currentTime = TimeUtil.getServerTime();
        isTimeExpired = checkedTime != null && currentTime > checkedTime + 300000L;
        System.out.println(isTimeExpired ? "Time expired" : "Time not expired");
        return isTimeExpired;
    }

    public String getOptOperationModeValue() {
        try {
            String status = this.state.getOptOperationModeValue();
            return status == null ? "" : status;
        }
        catch (ValidationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return "";
        }
    }

    public String getInternalIPAddresses() {
        StringBuffer buf = new StringBuffer();
        InternalNicInfo info = this.state.getOptInternalNicInfo();
        if (info != null && info.getIpAddressCount() > 0) {
            for (int i = 0; i < info.getIpAddressCount(); ++i) {
                buf.append("; " + new IpAddressRangeSubNetObject(info.getIpAddress(i)).getAddressString());
            }
        }
        return buf.length() > 0 ? buf.substring(2) : "";
    }

    public String getExternalIPAddresses() {
        StringBuffer buf = new StringBuffer();
        ExternalNicInfo info = this.state.getOptExternalNicInfo();
        if (info != null && info.getIpAddressCount() > 0) {
            for (int i = 0; i < info.getIpAddressCount(); ++i) {
                buf.append("; " + new IpAddressRangeSubNetObject(info.getIpAddress(i)).getAddressString());
            }
        }
        return buf.length() > 0 ? buf.substring(2) : "";
    }

    public String getInternalMACAddress() {
        String macAddress = null;
        InternalNicInfo info = this.state.getOptInternalNicInfo();
        if (info != null) {
            macAddress = info.getOptMacAddress();
        }
        return macAddress == null ? "" : macAddress;
    }

    public String getExternalMACAddress() {
        String macAddress = null;
        ExternalNicInfo info = this.state.getOptExternalNicInfo();
        if (info != null) {
            macAddress = info.getOptMacAddress();
        }
        return macAddress == null ? "" : macAddress;
    }

    public String getInternalNicDescription() {
        String nicDesc = null;
        InternalNicInfo info = this.state.getOptInternalNicInfo();
        if (info != null) {
            nicDesc = info.getOptNicDescription();
        }
        return nicDesc == null ? "" : nicDesc;
    }

    public String getExternalNicDescription() {
        String nicDesc = null;
        ExternalNicInfo info = this.state.getOptExternalNicInfo();
        if (info != null) {
            nicDesc = info.getOptNicDescription();
        }
        return nicDesc == null ? "" : nicDesc;
    }
}

