/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AuthSection;
import com.sygate.scm.common.configobject.schema.EnforceSpecifiedClientOnly;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.IpAddressRangeSubNetObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class EnforcerSpecifiedClientOnlyObject
extends AbstractUIObject {
    private EnforceSpecifiedClientOnly clientOnly;

    public EnforcerSpecifiedClientOnlyObject(EnforceSpecifiedClientOnly clientOnly) {
        this.clientOnly = clientOnly;
    }

    public static EnforcerSpecifiedClientOnlyObject newInstance(AuthSection authSection) {
        EnforceSpecifiedClientOnly newClientOnly = new EnforceSpecifiedClientOnly();
        authSection.setOptEnforceSpecifiedClientOnly(newClientOnly);
        return new EnforcerSpecifiedClientOnlyObject(newClientOnly);
    }

    public String getAllAddressString() {
        StringBuffer buf = new StringBuffer();
        Iterator<IpAddressRangeSubNetObject> itr = this.getAllAddresses().iterator();
        while (itr.hasNext()) {
            buf.append("; " + itr.next().getAddressString());
        }
        return buf.length() > 0 ? buf.substring(2) : "";
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.clientOnly.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.clientOnly.getDefEnable();
        }
        return isEnabled;
    }

    public Collection<IpAddressRangeSubNetObject> getAllAddresses() {
        int i;
        ArrayList<IpAddressRangeSubNetObject> address = new ArrayList<IpAddressRangeSubNetObject>();
        for (i = 0; i < this.clientOnly.getIpAddressCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.clientOnly.getIpAddress(i)));
        }
        for (i = 0; i < this.clientOnly.getSubNetCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.clientOnly.getSubNet(i)));
        }
        for (i = 0; i < this.clientOnly.getIpRangeCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.clientOnly.getIpRange(i)));
        }
        return address;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.clientOnly.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }

    public void setAllAddress(Collection<IpAddressRangeSubNetObject> address) {
        Vector oldAddress1 = this.clientOnly.getIpAddress();
        int i = oldAddress1.size();
        while (--i >= 0) {
            this.clientOnly.removeIpAddress((IpAddress)oldAddress1.get(i));
        }
        Vector oldAddress2 = this.clientOnly.getSubNet();
        int i2 = oldAddress2.size();
        while (--i2 >= 0) {
            this.clientOnly.removeSubNet((SubNet)oldAddress2.get(i2));
        }
        Vector oldAddress3 = this.clientOnly.getIpRange();
        int i3 = oldAddress3.size();
        while (--i3 >= 0) {
            this.clientOnly.removeIpRange((IpRange)oldAddress3.get(i3));
        }
        Iterator<IpAddressRangeSubNetObject> itr = address.iterator();
        while (itr.hasNext()) {
            Object item = itr.next().getAddress();
            if (item instanceof IpAddress) {
                this.clientOnly.addIpAddress((IpAddress)item);
                continue;
            }
            if (item instanceof SubNet) {
                this.clientOnly.addSubNet((SubNet)item);
                continue;
            }
            this.clientOnly.addIpRange((IpRange)item);
        }
    }
}

