/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.DhcpEnforcement;
import com.sygate.scm.common.configobject.schema.GatewayEnforcement;
import com.sygate.scm.common.configobject.schema.IntegratedEnforcement;
import com.sygate.scm.common.configobject.schema.LanEnforcement;
import com.sygate.scm.common.configobject.schema.ManagementServerList;
import com.sygate.scm.common.configobject.schema.NAPEnforcement;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.SeClientActivityLogSetting;
import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.common.configobject.schema.SeLog;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroup;
import com.sygate.scm.common.configobject.schema.SeSwitchEnforcementPolicy;
import com.sygate.scm.common.configobject.schema.SeSyslogSetting;
import com.sygate.scm.common.configobject.schema.SeSystemLogSetting;
import com.sygate.scm.common.configobject.schema.SeTrafficLogSetting;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.DhcpEnforcementObject;
import com.sygate.scm.console.logicobject.EnforcerClientActivityLogObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchCharacteristicObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchGroupObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchGroupTreeObject;
import com.sygate.scm.console.logicobject.EnforcerSyslogObject;
import com.sygate.scm.console.logicobject.EnforcerSystemLogObject;
import com.sygate.scm.console.logicobject.EnforcerTrafficLogObject;
import com.sygate.scm.console.logicobject.GatewayEnforcementObject;
import com.sygate.scm.console.logicobject.IntegratedEnforcementObject;
import com.sygate.scm.console.logicobject.LanEnforcementObject;
import com.sygate.scm.console.logicobject.NAPEnforcementObject;
import com.sygate.scm.console.logicobject.RadiusServerGroupPoolObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EnforcerPolicyObject
extends AbstractUIObject {
    private SeEnforcerPolicy policy;
    private static final int LOG_TYPE_SYSTEM = 0;
    private static final int LOG_TYPE_CLIENT = 1;
    private static final int LOG_TYPE_TRAFFIC = 2;
    private static final int LOG_TYPE_SYSLOG = 3;
    private Map<String, PhysicalFile> addedAddressBlock = new HashMap<String, PhysicalFile>();
    private Map<String, PhysicalFile> updatedAddressBlock = new HashMap<String, PhysicalFile>();
    private Map<String, PhysicalFile> deletedAddressBlock = new HashMap<String, PhysicalFile>();

    public EnforcerPolicyObject(SeEnforcerPolicy policy) {
        this.policy = policy;
    }

    public void updatePolicy(SiteObject site) throws ConsoleException {
        this.updateAddressBlocksForBinary(false);
        ArrayList<DataobjectManager.UpdateObjectEntry> list = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        this.updateAddressBlocksForMetadata(list);
        list.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)this.policy, 0));
        list.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)site.getSemSite(), 0));
        DataobjectManager.getInstance().updateObject("Overwrite", list);
        this.updateAddressBlocksForBinary(true);
        this.addedAddressBlock.clear();
        this.updatedAddressBlock.clear();
        this.deletedAddressBlock.clear();
    }

    public String getId() {
        return this.policy.getId();
    }

    public void addNewRefMacAddressBlock(PhysicalFile file) {
        this.addedAddressBlock.put(file.getId(), file);
    }

    public void addNewRefMabAddressBlock(PhysicalFile file) {
        this.addedAddressBlock.put(file.getId(), file);
    }

    public void updateRefMacAddressBlock(PhysicalFile file) {
        if (this.addedAddressBlock.containsKey(file.getId())) {
            this.addedAddressBlock.put(file.getId(), file);
        } else {
            this.updatedAddressBlock.put(file.getId(), file);
        }
    }

    public void updateRefMabAddressBlock(PhysicalFile file) {
        if (this.addedAddressBlock.containsKey(file.getId())) {
            this.addedAddressBlock.put(file.getId(), file);
        } else {
            this.updatedAddressBlock.put(file.getId(), file);
        }
    }

    public void deleteRefMacAddressBlock(PhysicalFile file) {
        this.deletedAddressBlock.put(file.getId(), file);
        this.addedAddressBlock.remove(file.getId());
        this.updatedAddressBlock.remove(file.getId());
    }

    public void deleteRefMabAddressBlock(PhysicalFile file) {
        this.deletedAddressBlock.put(file.getId(), file);
        this.addedAddressBlock.remove(file.getId());
        this.updatedAddressBlock.remove(file.getId());
    }

    public boolean isGatewayPolicy() {
        return this.policy.getOptGatewayEnforcement() != null;
    }

    public boolean isLanPolicy() {
        return this.policy.getOptLanEnforcement() != null;
    }

    public boolean isDhcpPolicy() {
        return this.policy.getOptDhcpEnforcement() != null;
    }

    public boolean isIntegratedPolicy() {
        return this.policy.getOptIntegratedEnforcement() != null;
    }

    public boolean isNAPPolicy() {
        return this.policy.getOptNAPEnforcement() != null;
    }

    public boolean isReferRadiusServerGroup(String groupId) {
        LanEnforcementObject lanObj = this.getLanEnforcementObject(false);
        if (lanObj == null) {
            return false;
        }
        EnforcerSwitchGroupTreeObject groupTreeObj = lanObj.getSwitchGroupTreeObject(false);
        if (groupTreeObj != null) {
            Iterator<EnforcerSwitchGroupObject> groupsObj = groupTreeObj.getSwitchGroupsObject().iterator();
            while (groupsObj.hasNext()) {
                EnforcerSwitchCharacteristicObject charObj = groupsObj.next().getSwitchCharacteristicObject();
                String rsGroupId = charObj.getUsingRdiusServerGroupId();
                if (!rsGroupId.equals(groupId)) continue;
                return true;
            }
        }
        return false;
    }

    public SchemaContainer export() {
        SchemaContainer container = new SchemaContainer();
        container.addChild((AbstractSchema)this.policy);
        LanEnforcementObject lanObj = this.getLanEnforcementObject(false);
        if (lanObj != null) {
            List<SeSwitchEnforcementPolicy> sePolicies = lanObj.getSwitchEnforcementPolicies();
            for (int i = 0; i < sePolicies.size(); ++i) {
                container.addChild((AbstractSchema)sePolicies.get(i));
            }
            List<SeRadiusServerGroup> rsGroup = lanObj.getRadiusServerGroups();
            for (int i = 0; i < rsGroup.size(); ++i) {
                container.addChild((AbstractSchema)rsGroup.get(i));
            }
        }
        return container;
    }

    public void importLANEnforcerReference(SiteObject siteObj, HashMap<String, AbstractSchema> refObjs) throws ConsoleException {
        Iterator<AbstractSchema> refs = refObjs.values().iterator();
        ArrayList<SeRadiusServerGroup> groupList = new ArrayList<SeRadiusServerGroup>();
        while (refs.hasNext()) {
            AbstractSchema schema = refs.next();
            int objType = schema.getObjectType();
            if (objType == 567) {
                DataobjectManager.getInstance().addSeSwitchEnforcementPolicy((SeSwitchEnforcementPolicy)schema);
                continue;
            }
            if (objType != 570) continue;
            SeRadiusServerGroup rs = (SeRadiusServerGroup)schema;
            rs.setOptEnforcerGroupName(this.getName());
            groupList.add(rs);
        }
        if (groupList.size() > 0) {
            RadiusServerGroupPoolObject groupPoolObject = siteObj.getRadiusServerGroupPoolObject(true);
            groupPoolObject.addRadiusServerGroup(groupList);
        }
    }

    public void deleteSwitchEnforcementPolicies() {
        LanEnforcementObject lanObj = this.getLanEnforcementObject(false);
        if (lanObj != null) {
            lanObj.deleteSwitchEnforcementPolicies();
        }
    }

    public void deleteRadiusServerGroups(SiteObject site) {
        LanEnforcementObject lanObj = this.getLanEnforcementObject(false);
        if (lanObj != null) {
            lanObj.deleteRadiusServerGroups(site);
        }
    }

    public String getEnforcerPolicyType() {
        if (this.isGatewayPolicy()) {
            return "Gateway Enforcer Policy";
        }
        if (this.isLanPolicy()) {
            return "LAN Enforcer Policy";
        }
        if (this.isDhcpPolicy()) {
            return "DHCP Enforcer Policy";
        }
        if (this.isNAPPolicy()) {
            return "NAP Enforcer Policy";
        }
        return "Integrated Enforcer Policy";
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        String name = this.policy.getName();
        return name == null ? "" : name;
    }

    public String getDescription() {
        String description = this.policy.getOptDescription();
        return description == null ? "" : description;
    }

    public GatewayEnforcementObject getGatewayEnforcementObject(boolean alwaysGet) {
        GatewayEnforcement gateway = this.policy.getOptGatewayEnforcement();
        if (gateway == null) {
            if (alwaysGet) {
                return GatewayEnforcementObject.newInstance(this.policy);
            }
            return null;
        }
        return new GatewayEnforcementObject(gateway);
    }

    public DhcpEnforcementObject getDhcpEnforcementObject(boolean alwaysGet) {
        DhcpEnforcement dhcp = this.policy.getOptDhcpEnforcement();
        if (dhcp == null) {
            if (alwaysGet) {
                return DhcpEnforcementObject.newInstance(this.policy);
            }
            return null;
        }
        return new DhcpEnforcementObject(dhcp);
    }

    public IntegratedEnforcementObject getIntegratedEnforcementObject(boolean alwaysGet) {
        IntegratedEnforcement integrated = this.policy.getOptIntegratedEnforcement();
        if (integrated == null) {
            if (alwaysGet) {
                return IntegratedEnforcementObject.newInstance(this.policy);
            }
            return null;
        }
        return new IntegratedEnforcementObject(integrated);
    }

    public LanEnforcementObject getLanEnforcementObject(boolean alwaysGet) {
        LanEnforcement lan = this.policy.getOptLanEnforcement();
        if (lan == null) {
            if (alwaysGet) {
                return LanEnforcementObject.newInstance(this.policy);
            }
            return null;
        }
        return new LanEnforcementObject(lan);
    }

    public NAPEnforcementObject getNAPEnforcementObject(boolean alwaysGet) {
        NAPEnforcement nap = this.policy.getOptNAPEnforcement();
        if (nap == null) {
            if (alwaysGet) {
                return NAPEnforcementObject.newInstance(this.policy);
            }
            return null;
        }
        return new NAPEnforcementObject(nap);
    }

    public void setNAPEnforcementObject(NAPEnforcementObject nap) {
        if (nap != null) {
            this.policy.setOptNAPEnforcement(nap.getNAPEnforcement());
        }
    }

    public EnforcerSystemLogObject getSystemLogSetting() {
        SeLog log = this.policy.getSeLog();
        SeSystemLogSetting setting = log.getOptSeSystemLogSetting();
        if (setting == null) {
            return null;
        }
        return new EnforcerSystemLogObject(setting);
    }

    public EnforcerClientActivityLogObject getClientActivityLogSetting() {
        SeLog log = this.policy.getSeLog();
        SeClientActivityLogSetting setting = log.getOptSeClientActivityLogSetting();
        if (setting == null) {
            return null;
        }
        return new EnforcerClientActivityLogObject(setting);
    }

    public EnforcerTrafficLogObject getTrafficLogSetting() {
        SeLog log = this.policy.getSeLog();
        SeTrafficLogSetting setting = log.getOptSeTrafficLogSetting();
        if (setting == null) {
            return null;
        }
        return new EnforcerTrafficLogObject(setting);
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.policy.setName(name);
        }
    }

    public void setDescription(String description) {
        if (!description.equals(this.getDescription())) {
            this.policy.setOptDescription(description.length() == 0 ? null : description);
        }
    }

    public void setSystemLogSetting(boolean isLogEnabled, boolean isUpload, long maxLogSize, int maxLogDays) {
        EnforcerSystemLogObject logObj = (EnforcerSystemLogObject)this.getEnforcerLogObject(0);
        if (isLogEnabled) {
            if (logObj == null) {
                logObj = (EnforcerSystemLogObject)this.createNewEnforcerLogObject(0);
            }
            logObj.setEnabled(isLogEnabled);
            logObj.setUpload(isUpload);
            logObj.setMaxLogSize(maxLogSize);
            logObj.setMaxLogDays(maxLogDays);
        } else if (logObj != null) {
            logObj.setEnabled(isLogEnabled);
            logObj.setUpload(isUpload);
        }
    }

    public void setClientActivityLogSetting(boolean isLogEnabled, boolean isUpload, long maxLogSize, int maxLogDays) {
        EnforcerClientActivityLogObject logObj = (EnforcerClientActivityLogObject)this.getEnforcerLogObject(1);
        if (isLogEnabled) {
            if (logObj == null) {
                logObj = (EnforcerClientActivityLogObject)this.createNewEnforcerLogObject(1);
            }
            logObj.setEnabled(isLogEnabled);
            logObj.setUpload(isUpload);
            logObj.setMaxLogSize(maxLogSize);
            logObj.setMaxLogDays(maxLogDays);
        } else if (logObj != null) {
            logObj.setEnabled(isLogEnabled);
            logObj.setUpload(isUpload);
        }
    }

    public void setTrafficLogSetting(boolean isLogEnabled, boolean isUpload, long maxLogSize, int maxLogDays, int uploadFilter) {
        EnforcerTrafficLogObject logObj = (EnforcerTrafficLogObject)this.getEnforcerLogObject(2);
        if (isLogEnabled) {
            if (logObj == null) {
                logObj = (EnforcerTrafficLogObject)this.createNewEnforcerLogObject(2);
            }
            logObj.setEnabled(isLogEnabled);
            logObj.setUpload(isUpload);
            logObj.setMaxLogSize(maxLogSize);
            logObj.setMaxLogDays(maxLogDays);
            logObj.setUploadFilter(uploadFilter);
        } else if (logObj != null) {
            logObj.setEnabled(isLogEnabled);
            logObj.setUpload(isUpload);
        }
    }

    public String getAuthServerListId() {
        ObjReference ref = this.policy.getOptObjReference();
        if (ref != null) {
            return ref.getTargetId();
        }
        return null;
    }

    public String getMgrServerListId() {
        ManagementServerList msl = this.policy.getOptManagementServerList();
        if (msl != null) {
            ObjReference objRef = msl.getObjReference();
            if (objRef != null) {
                return objRef.getTargetId();
            }
            return this.getAuthServerListId();
        }
        return this.getAuthServerListId();
    }

    public void setAuthServerList(SemServerList serverList, boolean isDefServerList) {
        ObjReference ref = this.policy.getOptObjReference();
        if (ref == null) {
            ref = new ObjReference();
            this.policy.setOptObjReference(ref);
        }
        ref.setTargetId(serverList.getId());
        ref.setTargetType(serverList.getObjectTypeName());
        if (isDefServerList) {
            ref.setName("DefaultServerList");
        } else {
            ref.setName("SemServerListLink");
        }
    }

    public void setMgrServerList(SemServerList serverList, boolean isDefServerList) {
        ObjReference ref;
        ManagementServerList msl = this.policy.getOptManagementServerList();
        if (msl == null) {
            msl = new ManagementServerList();
            this.policy.setOptManagementServerList(msl);
        }
        if ((ref = msl.getObjReference()) == null) {
            ref = new ObjReference();
            msl.setObjReference(ref);
        }
        ref.setTargetId(serverList.getId());
        ref.setTargetType(serverList.getObjectTypeName());
        if (isDefServerList) {
            ref.setName("DefaultServerList");
        } else {
            ref.setName("SemServerListLink");
        }
    }

    private AbstractUIObject getEnforcerLogObject(int type) {
        AbstractUIObject logObj = null;
        switch (type) {
            case 0: {
                logObj = this.getSystemLogSetting();
                break;
            }
            case 1: {
                logObj = this.getClientActivityLogSetting();
                break;
            }
            case 2: {
                logObj = this.getTrafficLogSetting();
                break;
            }
            case 3: {
                logObj = this.getSyslogSetting();
                break;
            }
        }
        return logObj;
    }

    private AbstractUIObject createNewEnforcerLogObject(int type) {
        AbstractUIObject logObj = null;
        switch (type) {
            case 0: {
                logObj = EnforcerSystemLogObject.newInstance(this.policy);
                break;
            }
            case 1: {
                logObj = EnforcerClientActivityLogObject.newInstance(this.policy);
                break;
            }
            case 2: {
                logObj = EnforcerTrafficLogObject.newInstance(this.policy);
                break;
            }
            case 3: {
                logObj = EnforcerSyslogObject.newInstance(this.policy);
                break;
            }
        }
        return logObj;
    }

    private void updateAddressBlocksForMetadata(List<DataobjectManager.UpdateObjectEntry> list) throws ConsoleException {
        Iterator<PhysicalFile> itrAdd = this.addedAddressBlock.values().iterator();
        while (itrAdd.hasNext()) {
            DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)itrAdd.next(), 1);
            list.add(entry);
        }
        Iterator<PhysicalFile> itrUpdate = this.updatedAddressBlock.values().iterator();
        while (itrUpdate.hasNext()) {
            DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)itrUpdate.next(), 0);
            list.add(entry);
        }
        Iterator<PhysicalFile> itrDelete = this.deletedAddressBlock.values().iterator();
        while (itrDelete.hasNext()) {
            DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)itrDelete.next(), 2);
            list.add(entry);
        }
    }

    private void updateAddressBlocksForBinary(boolean isDelete) throws ConsoleException {
        if (!isDelete) {
            for (PhysicalFile file : this.addedAddressBlock.values()) {
                GUIManager.addFile(file.getObjReference().getTargetId(), file.getFileName());
            }
            for (PhysicalFile file : this.updatedAddressBlock.values()) {
                GUIManager.updateFile(file.getObjReference().getTargetId(), file.getFileName());
            }
        } else {
            for (PhysicalFile file : this.deletedAddressBlock.values()) {
                GUIManager.deleteFile(file.getObjReference().getTargetId());
            }
        }
    }

    public EnforcerSyslogObject getSyslogSetting() {
        SeLog log = this.policy.getSeLog();
        SeSyslogSetting setting = log.getOptSeSyslogSetting();
        if (setting == null) {
            return null;
        }
        return new EnforcerSyslogObject(setting);
    }

    public void setSyslogSetting(boolean isLogEnabled, String sysLogServer, int logLevel, int failureThreshold, int failureInterval, int aliveInterval) {
        EnforcerSyslogObject logObj = (EnforcerSyslogObject)this.getEnforcerLogObject(3);
        if (logObj == null) {
            logObj = (EnforcerSyslogObject)this.createNewEnforcerLogObject(3);
        }
        logObj.setEnabled(isLogEnabled);
        logObj.setSyslogServer(sysLogServer);
        logObj.setLevel(logLevel);
        logObj.setOptFailureThreshhold(failureThreshold);
        logObj.setOptFailureInteval(failureInterval);
        logObj.setOptAliveInterval(aliveInterval);
    }
}

