/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.SemEnforcer;
import com.sygate.scm.common.configobject.schema.SemEnforcerState;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerStateObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;

public class EnforcerObject
extends AbstractUIObject
implements TreeItem {
    private SemEnforcer enforcer;
    private int enforcerType;

    public EnforcerObject(SemEnforcer enforcer, int enforcerType) {
        this.enforcer = enforcer;
        this.enforcerType = enforcerType;
    }

    public void deleteEnforcer() throws ConsoleException {
        EnforcerGroup group = (EnforcerGroup)this.enforcer.getParent();
        group.removeSemEnforcer(this.enforcer);
        this.updateTopLevelSite();
    }

    public EnforcerGroup getEnforcerGroup() {
        return (EnforcerGroup)this.enforcer.getParent();
    }

    public void updateTopLevelSite() throws ConsoleException {
        SemSite site = (SemSite)this.enforcer.getTopLevelObject();
        DataobjectManager.getInstance().updateObject("Overwrite", (TopLevelObject)site);
    }

    public EnforcerStateObject getEnforcerStateObject() {
        try {
            SemEnforcerState state = DataobjectManager.getInstance().getSemEnforcerState(this.enforcer.getId());
            System.out.println("enforcer ID = " + this.enforcer.getId());
            return new EnforcerStateObject(state);
        }
        catch (ConsoleException ex) {
            System.err.println("EnforcerObject->getEnforcerStateObject: can't get Enforcer state object");
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    @Override
    public int getItemType() {
        return 0;
    }

    @Override
    public String getId() {
        return this.enforcer.getId();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.enforcer.getName();
    }

    public String getDescription() {
        String desc = this.enforcer.getOptDescription();
        return desc == null ? "" : desc;
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.enforcer.setName(name);
        }
    }

    public void setDescription(String desc) {
        if (!desc.equals(this.getDescription())) {
            this.enforcer.setOptDescription(desc);
        }
    }

    public int getEnforcerType() {
        return this.enforcerType;
    }
}

