/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.EapAuthentication;
import com.sygate.scm.common.configobject.schema.EnforcerClient;
import com.sygate.scm.common.configobject.schema.EnforcerNotification;
import com.sygate.scm.common.configobject.schema.NAPEnforcer;
import com.sygate.scm.util.Utility;

public class EnforcerNotificationObject {
    private EnforcerClient _enforcerClient;
    private EnforcerNotification _enforcerNotification;
    private EapAuthentication _eapAuthentication;
    private NAPEnforcer _napEnforcer;

    public EnforcerNotificationObject() {
        this._enforcerNotification = new EnforcerNotification();
    }

    public EnforcerNotificationObject(EnforcerClient enforce) {
        this._enforcerClient = enforce;
        if (enforce != null) {
            this._enforcerNotification = enforce.getOptEnforcerNotification();
            this._eapAuthentication = enforce.getOptEapAuthentication();
            this._napEnforcer = enforce.getOptNAPEnforcer();
        }
    }

    public boolean isEnabled() {
        if (this._enforcerNotification != null) {
            if (this._enforcerNotification.getOptEnable() == null) {
                return this._enforcerNotification.getDefEnable();
            }
            return this._enforcerNotification.getOptEnable();
        }
        return false;
    }

    public String getAddtionTxt() {
        if (this._enforcerNotification != null) {
            return this._enforcerNotification.getOptAdditionalText();
        }
        return null;
    }

    public EnforcerClient getEnforcerClient() {
        return this._enforcerClient;
    }

    public void setEnabled(boolean isEnabled) {
        this.getMyEnforcerNotification().setOptEnable(Boolean.valueOf(isEnabled));
    }

    public void setAdditionTxt(String txt) {
        this.getMyEnforcerNotification().setOptAdditionalText(txt);
    }

    private EnforcerNotification getMyEnforcerNotification() {
        if (this._enforcerNotification == null) {
            this._enforcerNotification = new EnforcerNotification();
            this.getMyEnforcerClient().setOptEnforcerNotification(this._enforcerNotification);
        }
        return this._enforcerNotification;
    }

    private EnforcerClient getMyEnforcerClient() {
        if (this._enforcerClient == null) {
            this._enforcerClient = new EnforcerClient();
        }
        return this._enforcerClient;
    }

    public boolean getEnableEapAuthentication() {
        if (this._eapAuthentication != null) {
            Boolean enable = this._eapAuthentication.getOptEnable();
            if (enable == null) {
                enable = this._eapAuthentication.getDefEnable();
            }
            return enable;
        }
        return false;
    }

    public boolean getEnableSupplicantMode() {
        if (this._eapAuthentication != null) {
            return this._eapAuthentication.getEnableTransparentMode();
        }
        return false;
    }

    public boolean getEnableNPWaitTimeoutMode() {
        if (this._eapAuthentication != null) {
            return Utility.getBooleanValue((Boolean)this._eapAuthentication.getOptEnableNPWaitTimeoutMode(), (Boolean)this._eapAuthentication.getDefEnableNPWaitTimeoutMode());
        }
        return false;
    }

    public int getNPWaitTimeout() {
        if (this._eapAuthentication != null) {
            Integer time = this._eapAuthentication.getOptNPWaitTimeout();
            if (time == null) {
                time = this._eapAuthentication.getDefNPWaitTimeout();
            }
            return time;
        }
        return 3;
    }

    public boolean getEnableSupplicant() {
        if (this._eapAuthentication != null) {
            return Utility.getBooleanValue((Boolean)this._eapAuthentication.getOptEnableSupplicant(), (Boolean)this._eapAuthentication.getDefEnableSupplicant());
        }
        return false;
    }

    public void setEnableEapAuthentication(boolean newValue) {
        this.getEapAuthentication().setOptEnable(Boolean.valueOf(newValue));
    }

    public void setEnableSupplicantMode(boolean newValue) {
        this.getEapAuthentication().setEnableTransparentMode(Boolean.valueOf(newValue));
    }

    public void setEnableSupplicant(boolean enableSupplicant) {
        this.getEapAuthentication().setOptEnableSupplicant(Boolean.valueOf(enableSupplicant));
    }

    private EapAuthentication getEapAuthentication() {
        if (this._eapAuthentication == null) {
            this._eapAuthentication = new EapAuthentication();
            this.getMyEnforcerClient().setOptEapAuthentication(this._eapAuthentication);
        }
        return this._eapAuthentication;
    }

    public boolean getEnableNetworkAccessControl() {
        if (this._enforcerClient != null && this._enforcerClient.getOptEnableNetworkAccessControl() != null) {
            Boolean enable = this._enforcerClient.getOptEnableNetworkAccessControl();
            if (enable != null) {
                return enable;
            }
            return this._enforcerClient.getOptEnableNetworkAccessControl();
        }
        return false;
    }

    public void setEnableNetworkAccessControl(boolean enableNACFlag) {
        if (this._enforcerClient != null) {
            this._enforcerClient.setOptEnableNetworkAccessControl(Boolean.valueOf(enableNACFlag));
        }
    }

    public boolean getEnableAlternateEnforcerCommunication() {
        if (this._enforcerClient != null && this._enforcerClient.getOptUseAlternateCommunicationMethodWithEnforcer() != null) {
            Boolean enable = this._enforcerClient.getOptUseAlternateCommunicationMethodWithEnforcer();
            if (enable != null) {
                return enable;
            }
            return this._enforcerClient.getOptUseAlternateCommunicationMethodWithEnforcer();
        }
        return false;
    }

    public void setEnableAlternateEnforcerCommunication(boolean b) {
        if (this._enforcerClient != null) {
            this._enforcerClient.setOptUseAlternateCommunicationMethodWithEnforcer(Boolean.valueOf(b));
        }
    }

    public boolean getEnableNapEnforcer() {
        if (this._napEnforcer != null) {
            Boolean enable = this._napEnforcer.getOptEnable();
            if (enable == null) {
                enable = this._napEnforcer.getDefEnable();
            }
            return enable;
        }
        return false;
    }

    private NAPEnforcer getNAPEnforcer() {
        if (this._napEnforcer == null) {
            this._napEnforcer = new NAPEnforcer();
            this.getMyEnforcerClient().setOptNAPEnforcer(this._napEnforcer);
        }
        return this._napEnforcer;
    }

    public void setEnableNapEnforcer(boolean tf) {
        this.getNAPEnforcer().setOptEnable(Boolean.valueOf(tf));
    }

    public void setEnableNPWaitTimeoutMode(boolean mode) {
        this.getEapAuthentication().setOptEnableNPWaitTimeoutMode(Boolean.valueOf(mode));
    }

    public void setNPWaitTimeout(int timeout) {
        this.getEapAuthentication().setOptNPWaitTimeout(Integer.valueOf(timeout));
    }
}

