/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AuthSection;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.configobject.schema.TrustedInternalIpRange;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.IpAddressRangeSubNetObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class EnforcerInternalIpRangeObject
extends AbstractUIObject {
    private TrustedInternalIpRange ipRange;

    public EnforcerInternalIpRangeObject(TrustedInternalIpRange ipRange) {
        this.ipRange = ipRange;
    }

    public static EnforcerInternalIpRangeObject newInstance(AuthSection authSection) {
        TrustedInternalIpRange newIpRange = new TrustedInternalIpRange();
        authSection.setOptTrustedInternalIpRange(newIpRange);
        return new EnforcerInternalIpRangeObject(newIpRange);
    }

    public String getAllAddressString() {
        StringBuffer buf = new StringBuffer();
        Iterator<IpAddressRangeSubNetObject> itr = this.getAllAddresses().iterator();
        while (itr.hasNext()) {
            buf.append("; " + itr.next().getAddressString());
        }
        return buf.length() > 0 ? buf.substring(2) : "";
    }

    public Collection<IpAddressRangeSubNetObject> getAllAddresses() {
        int i;
        ArrayList<IpAddressRangeSubNetObject> address = new ArrayList<IpAddressRangeSubNetObject>();
        for (i = 0; i < this.ipRange.getIpAddressCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.ipRange.getIpAddress(i)));
        }
        for (i = 0; i < this.ipRange.getSubNetCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.ipRange.getSubNet(i)));
        }
        for (i = 0; i < this.ipRange.getIpRangeCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.ipRange.getIpRange(i)));
        }
        return address;
    }

    public void setAllAddress(Collection<IpAddressRangeSubNetObject> address) {
        Vector oldAddress1 = this.ipRange.getIpAddress();
        int i = oldAddress1.size();
        while (--i >= 0) {
            this.ipRange.removeIpAddress((IpAddress)oldAddress1.get(i));
        }
        Vector oldAddress2 = this.ipRange.getSubNet();
        int i2 = oldAddress2.size();
        while (--i2 >= 0) {
            this.ipRange.removeSubNet((SubNet)oldAddress2.get(i2));
        }
        Vector oldAddress3 = this.ipRange.getIpRange();
        int i3 = oldAddress3.size();
        while (--i3 >= 0) {
            this.ipRange.removeIpRange((IpRange)oldAddress3.get(i3));
        }
        Iterator<IpAddressRangeSubNetObject> itr = address.iterator();
        while (itr.hasNext()) {
            Object item = itr.next().getAddress();
            if (item instanceof IpAddress) {
                this.ipRange.addIpAddress((IpAddress)item);
                continue;
            }
            if (item instanceof SubNet) {
                this.ipRange.addSubNet((SubNet)item);
                continue;
            }
            this.ipRange.addIpRange((IpRange)item);
        }
    }
}

