/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AuthSection;
import com.sygate.scm.common.configobject.schema.HttpRedirect;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class EnforcerHttpRedirectObject
extends AbstractUIObject {
    private HttpRedirect httpRedirect;

    public EnforcerHttpRedirectObject(HttpRedirect httpRedirect) {
        this.httpRedirect = httpRedirect;
    }

    public static EnforcerHttpRedirectObject newInstance(AuthSection authSection) {
        HttpRedirect newHttpRedirect = new HttpRedirect();
        authSection.setOptHttpRedirect(newHttpRedirect);
        return new EnforcerHttpRedirectObject(newHttpRedirect);
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.httpRedirect.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.httpRedirect.getDefEnable();
        }
        return isEnabled;
    }

    public String getUrl() {
        String url = this.httpRedirect.getUrl();
        return url == null ? "" : url;
    }

    public Integer getPort() {
        Integer port = this.httpRedirect.getOptPort();
        return port == null ? this.httpRedirect.getDefPort() : port;
    }

    public HttpRedirect getSchemaObject() {
        return this.httpRedirect;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.httpRedirect.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }

    public void setUrl(String url) {
        if (!url.equals(this.getUrl())) {
            this.httpRedirect.setUrl(url);
        }
    }

    public void setPort(Integer port) {
        if (!port.equals(this.getPort())) {
            this.httpRedirect.setOptPort(port);
        }
    }
}

