/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.common.configobject.schema.SeSwitchEnforcementPolicy;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerObject;
import com.sygate.scm.console.logicobject.EnforcerPolicyObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchPolicyObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.WashIdHelper;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class EnforcerGroupObject
extends AbstractUIObject
implements TreeItem {
    public static final int KBYTE = 1024;
    private static final String IMPORT_ERROR = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "EnforcerGroupObject.importError");
    private int itemType = 0;
    private EnforcerGroup group;
    private SeEnforcerPolicy policy;
    private DataobjectManager dbManager = DataobjectManager.getInstance();

    public EnforcerGroupObject(EnforcerGroup group) {
        this.group = group;
        try {
            ObjReference objRef = group.getObjReference();
            this.policy = this.dbManager.getSeEnforcerPolicy(objRef.getTargetId());
        }
        catch (ConsoleException ex) {
            System.err.println("EnforcerGroupObject->Constructor: policy == null");
        }
    }

    public EnforcerGroupObject(EnforcerGroup group, SeEnforcerPolicy SePolicy) {
        this.group = group;
        try {
            this.policy = SePolicy;
        }
        catch (Exception ex) {
            System.err.println("EnforcerGroupObject->Constructor: policy == null");
        }
    }

    public SiteObject getSiteObject() {
        return new SiteObject((SemSite)this.group.getTopLevelObject());
    }

    public void deleteEnforcerGroup() throws ConsoleException {
        SemSite site = (SemSite)this.group.getTopLevelObject();
        EnforcerGroup rootGroup = (EnforcerGroup)this.group.getParent();
        rootGroup.removeEnforcerGroup(this.group);
        this.dbManager.updateObject("Overwrite", (TopLevelObject)site);
    }

    public boolean importEnforcerPolicy(SeEnforcerPolicy impEPolicy, HashMap<String, AbstractSchema> refObjs) throws ConsoleException {
        ObjReference objReference;
        if (!this.isSameType(impEPolicy)) {
            return false;
        }
        this.washId(impEPolicy, refObjs);
        boolean resetObjReferenceFlag = true;
        if (impEPolicy.getOptObjReference() != null && (objReference = impEPolicy.getOptObjReference()) != null) {
            String targetId = objReference.getTargetId();
            if (objReference.getTargetType().equals("SemServerList")) {
                try {
                    SemServerList authenticationServerList = this.dbManager.getSemServerList(targetId);
                    if (null != authenticationServerList) {
                        resetObjReferenceFlag = false;
                    }
                }
                catch (Exception e) {
                    try {
                        SemSite defaultServer = this.dbManager.getSemSite(targetId);
                        if (null != defaultServer) {
                            resetObjReferenceFlag = false;
                        }
                    }
                    catch (Exception e1) {
                        LoggerUtilities.logException((Throwable)e1);
                    }
                }
            }
        }
        if (resetObjReferenceFlag) {
            impEPolicy.setOptObjReference(null);
        }
        this.setEnforcerPolicy(impEPolicy);
        this.getEnforcePolicyObject().importLANEnforcerReference(this.getSiteObject(), refObjs);
        this.dbManager.updateObject("Overwrite", this.group.getTopLevelObject());
        return true;
    }

    private boolean isSameType(SeEnforcerPolicy impEPolicy) {
        String curEPType;
        String impEPType = new EnforcerPolicyObject(impEPolicy).getEnforcerPolicyType();
        if (!impEPType.equals(curEPType = this.getEnforcePolicyObject().getEnforcerPolicyType())) {
            String errorMsg = MessageFormat.format(IMPORT_ERROR, curEPType, impEPType);
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, "Error", 0);
            return false;
        }
        return true;
    }

    private void setEnforcerPolicy(SeEnforcerPolicy impEPolicy) throws ConsoleException {
        this.group.setModifiedTime(Long.valueOf(System.currentTimeMillis()));
        impEPolicy.setName(this.getName());
        this.dbManager.addSeEnforcerPolicy(impEPolicy);
        ObjReference refObj = this.group.getObjReference();
        if (refObj == null) {
            refObj = new ObjReference();
        }
        refObj.setName("EnforcerPolicyApplied");
        refObj.setTargetId(impEPolicy.getId());
        refObj.setTargetType("SeEnforcerPolicy");
        this.group.setObjReference(refObj);
        this.getEnforcePolicyObject().deleteSwitchEnforcementPolicies();
        this.getEnforcePolicyObject().deleteRadiusServerGroups(this.getSiteObject());
        this.dbManager.deleteSeEnforcerPolicy(this.policy);
        this.policy = impEPolicy;
    }

    private void washId(SeEnforcerPolicy impEPolicy, HashMap<String, AbstractSchema> refObjs) {
        Map idMap = WashIdHelper.washIdList((ConfigObject)impEPolicy, refObjs);
        for (AbstractSchema schema : refObjs.values()) {
            if (schema.getObjectType() != 567) continue;
            new EnforcerSwitchPolicyObject((SeSwitchEnforcementPolicy)schema).updateVlanGUID(idMap);
        }
    }

    public int getEnforcerCount() {
        return this.group.getSemEnforcerCount();
    }

    public EnforcerGroup getEnforcerGroup() {
        return this.group;
    }

    @Override
    public int getItemType() {
        return this.itemType;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this.group.getId();
    }

    @Override
    public String getName() {
        String name = this.group.getName();
        return name == null ? "" : name;
    }

    public String getDescription() {
        String desc = this.group.getOptDescription();
        return desc == null ? "" : desc;
    }

    public String getCreator() {
        String creator = this.group.getCreator();
        return creator == null ? "" : creator;
    }

    public String getCreationTime() {
        String cTime = this.group.getCreationTime().toString();
        return cTime;
    }

    public String getModifiedTime() {
        String mTime = this.group.getModifiedTime().toString();
        return mTime;
    }

    public EnforcerPolicyObject getEnforcePolicyObject() {
        return new EnforcerPolicyObject(this.policy);
    }

    public EnforcerPolicyObject getEnforcePolicyObjectForExport() {
        return new EnforcerPolicyObject((SeEnforcerPolicy)this.policy.clone());
    }

    public DefaultMutableTreeNode getEnforcerNode() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this);
        for (int i = 0; i < this.group.getSemEnforcerCount(); ++i) {
            EnforcerObject enforcerObject = new EnforcerObject(this.group.getSemEnforcer(i), this.itemType);
            root.add(new DefaultMutableTreeNode(enforcerObject));
        }
        return root;
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.group.setName(name);
        }
    }

    public void setDescription(String description) {
        if (!description.equals(this.getDescription())) {
            this.group.setOptDescription(description.length() == 0 ? null : description);
        }
    }

    public void setModifiedTime(Long value) {
        if (value != null && !value.equals(this.group.getModifiedTime())) {
            this.group.setModifiedTime(value);
        }
    }
}

