/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.DhcpEnforcement;
import com.sygate.scm.common.configobject.schema.EnforcerFailover;
import com.sygate.scm.common.configobject.schema.GatewayEnforcement;
import com.sygate.scm.common.configobject.schema.IntegratedEnforcement;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class EnforcerFailoverObject
extends AbstractUIObject {
    private EnforcerFailover failover;

    public EnforcerFailoverObject(EnforcerFailover failover) {
        this.failover = failover;
    }

    public static EnforcerFailoverObject newInstance(GatewayEnforcement gateway) {
        EnforcerFailover failover = new EnforcerFailover();
        gateway.setOptEnforcerFailover(failover);
        return new EnforcerFailoverObject(failover);
    }

    public static EnforcerFailoverObject newInstance(DhcpEnforcement dhcp) {
        EnforcerFailover failover = new EnforcerFailover();
        dhcp.setOptEnforcerFailover(failover);
        return new EnforcerFailoverObject(failover);
    }

    public static EnforcerFailoverObject newInstance(IntegratedEnforcement integrated) {
        EnforcerFailover failover = new EnforcerFailover();
        integrated.setOptEnforcerFailover(failover);
        return new EnforcerFailoverObject(failover);
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.failover.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.failover.getDefEnable();
        }
        return isEnabled;
    }

    public String getPort() {
        Integer port = this.failover.getOptPort();
        if (port == null) {
            port = this.failover.getDefPort();
        }
        return port.toString();
    }

    public int getSensitiveLevel() {
        Integer level = this.failover.getOptSensitiveLevel();
        if (level == null) {
            level = this.failover.getDefSensitiveLevel();
        }
        return level;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.failover.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }

    public void setPort(String port) {
        if (port.length() == 0) {
            port = this.failover.getDefPort().toString();
        }
        if (!port.equals(this.getPort())) {
            this.failover.setOptPort(Integer.valueOf(port));
        }
    }

    public void setSensitiveLevel(int level) {
        if (level != this.getSensitiveLevel()) {
            this.failover.setOptSensitiveLevel(Integer.valueOf(level));
        }
    }
}

