/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AuthSection;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.configobject.schema.TrustedExternalIpRange;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.IpAddressRangeSubNetObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class EnforcerExternalIpRangeObject
extends AbstractUIObject {
    private TrustedExternalIpRange ipRange;

    public EnforcerExternalIpRangeObject(TrustedExternalIpRange ipRange) {
        this.ipRange = ipRange;
    }

    public static EnforcerExternalIpRangeObject newInstance(AuthSection authSection) {
        TrustedExternalIpRange newIpRange = new TrustedExternalIpRange();
        authSection.setOptTrustedExternalIpRange(newIpRange);
        return new EnforcerExternalIpRangeObject(newIpRange);
    }

    public String getAllAddressString() {
        StringBuffer buf = new StringBuffer();
        Iterator<IpAddressRangeSubNetObject> itr = this.getAllAddresses().iterator();
        while (itr.hasNext()) {
            buf.append("; " + itr.next().getAddressString());
        }
        return buf.length() > 0 ? buf.substring(2) : "";
    }

    public Collection<IpAddressRangeSubNetObject> getAllAddresses() {
        int i;
        ArrayList<IpAddressRangeSubNetObject> address = new ArrayList<IpAddressRangeSubNetObject>();
        for (i = 0; i < this.ipRange.getIpAddressCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.ipRange.getIpAddress(i)));
        }
        for (i = 0; i < this.ipRange.getSubNetCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.ipRange.getSubNet(i)));
        }
        for (i = 0; i < this.ipRange.getIpRangeCount(); ++i) {
            address.add(new IpAddressRangeSubNetObject(this.ipRange.getIpRange(i)));
        }
        return address;
    }

    public void setAllAddress(Collection<IpAddressRangeSubNetObject> address) {
        Vector oldAddress = this.ipRange.getIpAddress();
        int i = oldAddress.size();
        while (--i >= 0) {
            this.ipRange.removeIpAddress((IpAddress)oldAddress.get(i));
        }
        Vector oldSubNet = this.ipRange.getSubNet();
        int i2 = oldSubNet.size();
        while (--i2 >= 0) {
            this.ipRange.removeSubNet((SubNet)oldSubNet.get(i2));
        }
        Vector oldIpRange = this.ipRange.getIpRange();
        int i3 = oldIpRange.size();
        while (--i3 >= 0) {
            this.ipRange.removeIpRange((IpRange)oldIpRange.get(i3));
        }
        Iterator<IpAddressRangeSubNetObject> itr = address.iterator();
        while (itr.hasNext()) {
            Object item = itr.next().getAddress();
            if (item instanceof IpAddress) {
                this.ipRange.addIpAddress((IpAddress)item);
                continue;
            }
            if (item instanceof SubNet) {
                this.ipRange.addSubNet((SubNet)item);
                continue;
            }
            this.ipRange.addIpRange((IpRange)item);
        }
    }
}

