/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AuthSection;
import com.sygate.scm.common.configobject.schema.DhcpAuthSection;
import com.sygate.scm.common.configobject.schema.EnforcerClientNotification;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class EnforcerClientNotificationObject
extends AbstractUIObject {
    private EnforcerClientNotification clientNtf;

    public EnforcerClientNotificationObject(EnforcerClientNotification clientNtf) {
        this.clientNtf = clientNtf;
    }

    public static EnforcerClientNotificationObject newInstance(AuthSection authSection) {
        EnforcerClientNotification newNtf = new EnforcerClientNotification();
        authSection.setOptEnforcerClientNotification(newNtf);
        return new EnforcerClientNotificationObject(newNtf);
    }

    public static EnforcerClientNotificationObject newInstance(DhcpAuthSection authSection) {
        EnforcerClientNotification newNtf = new EnforcerClientNotification();
        authSection.setOptEnforcerClientNotification(newNtf);
        return new EnforcerClientNotificationObject(newNtf);
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.clientNtf.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.clientNtf.getDefEnable();
        }
        return isEnabled;
    }

    public String getInterval() {
        Integer interval = this.clientNtf.getOptInterval();
        if (interval == null) {
            interval = this.clientNtf.getDefInterval();
        }
        return interval.toString();
    }

    public String getAdditionalText() {
        String text = this.clientNtf.getOptAdditionalText();
        return text == null ? "" : text;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.clientNtf.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }

    public void setInterval(String interval) {
        if (interval.length() == 0) {
            interval = this.clientNtf.getDefInterval().toString();
        }
        if (!interval.equals(this.getInterval())) {
            this.clientNtf.setOptInterval(Integer.valueOf(interval));
        }
    }

    public void setAdditionalText(String text) {
        if (!text.equals(this.getAdditionalText())) {
            text = text.length() == 0 ? null : text;
            this.clientNtf.setOptAdditionalText(text);
        }
    }
}

