/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AllowNonWindows;
import com.sygate.scm.common.configobject.schema.AuthSection;
import com.sygate.scm.common.configobject.schema.CheckProfileSn;
import com.sygate.scm.common.configobject.schema.EnforceSpecifiedClientOnly;
import com.sygate.scm.common.configobject.schema.EnforcerClientNotification;
import com.sygate.scm.common.configobject.schema.HttpRedirect;
import com.sygate.scm.common.configobject.schema.TrustedExternalIpRange;
import com.sygate.scm.common.configobject.schema.TrustedInternalIpRange;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerAllowNonWindowsObject;
import com.sygate.scm.console.logicobject.EnforcerAuthParameterObject;
import com.sygate.scm.console.logicobject.EnforcerCheckProfileSnObject;
import com.sygate.scm.console.logicobject.EnforcerClientNotificationObject;
import com.sygate.scm.console.logicobject.EnforcerExternalIpRangeObject;
import com.sygate.scm.console.logicobject.EnforcerHttpRedirectObject;
import com.sygate.scm.console.logicobject.EnforcerInternalIpRangeObject;
import com.sygate.scm.console.logicobject.EnforcerSpecifiedClientOnlyObject;
import com.sygate.scm.console.logicobject.IpAddressRangeSubNetObject;
import java.util.Collection;

public class EnforcerAuthSectionObject
extends AbstractUIObject {
    private AuthSection authSection;

    public EnforcerAuthSectionObject(AuthSection authSection) {
        this.authSection = authSection;
    }

    public EnforcerAuthParameterObject getAuthParameterObject() {
        return new EnforcerAuthParameterObject(this.authSection.getAuthParameter());
    }

    public EnforcerAllowNonWindowsObject getAllowNonWindowsObject() {
        AllowNonWindows nonWindows = this.authSection.getOptAllowNonWindows();
        if (nonWindows == null) {
            return null;
        }
        return new EnforcerAllowNonWindowsObject(nonWindows);
    }

    public EnforcerCheckProfileSnObject getCheckProfileSnObject() {
        CheckProfileSn sn = this.authSection.getOptCheckProfileSn();
        if (sn == null) {
            return null;
        }
        return new EnforcerCheckProfileSnObject(sn);
    }

    public EnforcerClientNotificationObject getClientNotificationObject() {
        EnforcerClientNotification clientNotif = this.authSection.getOptEnforcerClientNotification();
        if (clientNotif == null) {
            return null;
        }
        return new EnforcerClientNotificationObject(clientNotif);
    }

    public EnforcerHttpRedirectObject getHttpRedirectObject() {
        HttpRedirect httpRedirect = this.authSection.getOptHttpRedirect();
        if (httpRedirect == null) {
            return null;
        }
        return new EnforcerHttpRedirectObject(httpRedirect);
    }

    public EnforcerSpecifiedClientOnlyObject getSpecifiedClientOnlyObject() {
        EnforceSpecifiedClientOnly clientOnly = this.authSection.getOptEnforceSpecifiedClientOnly();
        if (clientOnly == null) {
            return null;
        }
        return new EnforcerSpecifiedClientOnlyObject(clientOnly);
    }

    public EnforcerInternalIpRangeObject getInternalIpRangeObject() {
        TrustedInternalIpRange range = this.authSection.getOptTrustedInternalIpRange();
        if (range == null) {
            return null;
        }
        return new EnforcerInternalIpRangeObject(range);
    }

    public EnforcerExternalIpRangeObject getExternalIpRangeObject() {
        TrustedExternalIpRange range = this.authSection.getOptTrustedExternalIpRange();
        if (range == null) {
            return null;
        }
        return new EnforcerExternalIpRangeObject(range);
    }

    public void setAuthParameterObject(String authPort, String authPacket, String packetInterval, String rejectTime, String allowTime) {
        EnforcerAuthParameterObject authParaObj = this.getAuthParameterObject();
        authParaObj.setAuthPort(authPort);
        authParaObj.setAuthPacket(authPacket);
        authParaObj.setPacketInterval(packetInterval);
        authParaObj.setRejectTime(rejectTime);
        authParaObj.setAllowTime(allowTime);
    }

    public void setAllowNonWindowsObject(boolean isEnabled) {
        EnforcerAllowNonWindowsObject nonWindowsObj = this.getAllowNonWindowsObject();
        if (nonWindowsObj == null) {
            nonWindowsObj = EnforcerAllowNonWindowsObject.newInstance(this.authSection);
        }
        nonWindowsObj.setEnabled(isEnabled);
    }

    public void setCheckProfileSnObject(boolean isEnabled) {
        EnforcerCheckProfileSnObject profileSnObj = this.getCheckProfileSnObject();
        if (profileSnObj == null) {
            profileSnObj = EnforcerCheckProfileSnObject.newInstance(this.authSection);
        }
        profileSnObj.setEnabled(isEnabled);
    }

    public void setClientNotificationObject(boolean isEnabled, String interval, String additionalText) {
        EnforcerClientNotificationObject clientNtfObj = this.getClientNotificationObject();
        if (clientNtfObj == null) {
            clientNtfObj = EnforcerClientNotificationObject.newInstance(this.authSection);
        }
        clientNtfObj.setEnabled(isEnabled);
        clientNtfObj.setInterval(interval);
        clientNtfObj.setAdditionalText(additionalText);
    }

    public void setHttpRedirectObject(boolean isEnabled, String url, Integer port) {
        EnforcerHttpRedirectObject httpRedirectObj = this.getHttpRedirectObject();
        if (httpRedirectObj == null) {
            httpRedirectObj = EnforcerHttpRedirectObject.newInstance(this.authSection);
            this.authSection.setOptHttpRedirect(httpRedirectObj.getSchemaObject());
        }
        httpRedirectObj.setEnabled(isEnabled);
        httpRedirectObj.setUrl(url != null && url.length() > 0 ? url : "");
        httpRedirectObj.setPort(port == null ? Integer.valueOf(-1) : port);
    }

    public void setSpecifiedClientOnlyObject(boolean isEnabled, Collection<IpAddressRangeSubNetObject> address) {
        EnforcerSpecifiedClientOnlyObject clientOnlyObj = this.getSpecifiedClientOnlyObject();
        if (clientOnlyObj == null) {
            clientOnlyObj = EnforcerSpecifiedClientOnlyObject.newInstance(this.authSection);
        }
        clientOnlyObj.setEnabled(isEnabled);
        clientOnlyObj.setAllAddress(address);
    }

    public void setInternalIpRangeObject(Collection<IpAddressRangeSubNetObject> address) {
        EnforcerInternalIpRangeObject ipRangeObj = this.getInternalIpRangeObject();
        if (ipRangeObj == null) {
            ipRangeObj = EnforcerInternalIpRangeObject.newInstance(this.authSection);
        }
        ipRangeObj.setAllAddress(address);
    }

    public void setExternalIpRangeObject(Collection<IpAddressRangeSubNetObject> address) {
        EnforcerExternalIpRangeObject ipRangeObj = this.getExternalIpRangeObject();
        if (ipRangeObj == null) {
            ipRangeObj = EnforcerExternalIpRangeObject.newInstance(this.authSection);
        }
        ipRangeObj.setAllAddress(address);
    }
}

