/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.util.LoggerUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ElsLicenseObject
extends AbstractUIObject
implements TreeItem {
    private static final String PAID_AWS_LICENSE_SERIAL_NUMBER = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ElsLicenseObject.awsName");
    private ElsLicense elsLicense;

    public ElsLicenseObject(ElsLicense licenseObject) {
        this.elsLicense = licenseObject;
    }

    public ElsLicense getElsLicense() {
        return this.elsLicense;
    }

    public int getCount() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptMeterCount();
        }
        return 0;
    }

    public long getStartDate() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptStartDate();
        }
        return 0L;
    }

    public long getEndDate() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptEndDate();
        }
        return 0L;
    }

    public int getGraceCountPct() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptGraceCountPct();
        }
        return 0;
    }

    public String getSerialNumber() {
        if (this.elsLicense != null) {
            String sn = this.getLicenseCategory() == 6 ? PAID_AWS_LICENSE_SERIAL_NUMBER : this.elsLicense.getOptSerialNumber();
            return sn;
        }
        return "";
    }

    public String getFulfillmentID() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptFulfillmentID();
        }
        return "";
    }

    public String getSerialID() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptSerialID();
        }
        return "";
    }

    public long getWarnPolicy() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptWarmPolicy();
        }
        return 0L;
    }

    public long getGracePolicy() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptGracePoicy();
        }
        return 0L;
    }

    public String getProductID() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptProductID();
        }
        return "";
    }

    public String getProductType() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptProductType();
        }
        return "";
    }

    public String getProductName() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptProductName();
        }
        return "";
    }

    public boolean getDeleted() {
        if (this.elsLicense != null && this.elsLicense.getOptDeleted() != null) {
            return this.elsLicense.getOptDeleted();
        }
        return false;
    }

    @Override
    public String getId() {
        if (this.elsLicense != null) {
            return this.elsLicense.getId();
        }
        return null;
    }

    public String getVersion() {
        if (this.elsLicense != null) {
            return this.elsLicense.getOptVersion();
        }
        return "";
    }

    public int getGraceCount() {
        return LicenseUtils.getGraceCount((ElsLicense)this.getElsLicense());
    }

    public long getExpireDate() {
        return LicenseUtils.getExpireDate((ElsLicense)this.getElsLicense());
    }

    public long getWarnDate() {
        return LicenseUtils.getWarnDate((ElsLicense)this.getElsLicense());
    }

    @Override
    public int getItemType() {
        return 165;
    }

    public boolean isSEPLicense() {
        try {
            return "SEP".equalsIgnoreCase(this.elsLicense.getOptClientProductTypeValue());
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            return true;
        }
    }

    public boolean isSNACLicense() {
        return !this.isSEPLicense();
    }

    @Override
    public String getName() {
        Object[] obj = new Object[]{this.getCount(), ElsLicenseObject.getDateStr(this.getExpireDate())};
        String msg = null;
        msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ElsLicenseObject.name");
        return MessageFormat.format(msg, obj);
    }

    public int getLicenseCategory() {
        if (this.elsLicense != null) {
            Integer category = this.elsLicense.getOptLicenseCategory();
            return category == null ? -1 : category;
        }
        return -1;
    }

    public static String getDateStr(long date) {
        return LicenseUtils.getDateStrInyyyy((long)date);
    }

    public static List<ElsLicense> getElsLicenses(List<ElsLicenseObject> licenseObjects) {
        ArrayList<ElsLicense> result = new ArrayList<ElsLicense>();
        for (ElsLicenseObject l : licenseObjects) {
            result.add(l.getElsLicense());
        }
        return result;
    }
}

