/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemDomainState;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;

public class DomainStateObject {
    SemDomainState domainState = null;

    public DomainStateObject(SemDomainState domainState) {
        this.domainState = domainState;
    }

    public static DomainStateObject retrieveDomainStateObject(String id) {
        DomainStateObject state = new DomainStateObject(DomainStateObject.retrieveDomainState(id));
        DomainStateObject.print(state);
        return state;
    }

    public static SemDomainState retrieveDomainState(String id) {
        SemDomainState state = null;
        try {
            state = DataobjectManager.getInstance().getSemDomainState(id);
        }
        catch (Exception ex) {
            System.out.println("DomainStateObject>> retrieveDomainState: Error-> Failed to get domain state. id=" + id);
            LoggerUtilities.logException((Throwable)ex);
        }
        return state;
    }

    public static SemDomainState createDomainState(SemDomain domain) {
        if (domain == null) {
            return null;
        }
        SemDomainState state = new SemDomainState();
        GUIDGenerator guidGenerator = new GUIDGenerator();
        state.setId(guidGenerator.getGUIDString());
        state.setOwnerId(domain.getId());
        return state;
    }

    public boolean isValid() {
        return this.domainState != null;
    }

    public SemDomainState getSemDomainState() {
        return this.domainState;
    }

    public String getId() {
        return this.domainState != null ? this.domainState.getId() : "";
    }

    public String getOwnerId() {
        return this.domainState != null ? this.domainState.getOwnerId() : "";
    }

    public void print() {
        DomainStateObject.print(this);
    }

    public static void print(DomainStateObject state) {
        if (state == null) {
            System.out.println("==== DomainStateObject is null!");
            return;
        }
        System.out.println("================================================");
        System.out.println("==== Domain State Properties: Begin");
        System.out.println("valid=" + state.isValid());
        System.out.println("id=" + state.getId());
        System.out.println("owner id=" + state.getOwnerId());
        System.out.println("==== Domain State Properties: End");
        System.out.println("================================================");
    }
}

