/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.AdditionalUserInfoCollector;
import com.sygate.scm.common.configobject.schema.AdministrativeConfig;
import com.sygate.scm.common.configobject.schema.LoginBanner;
import com.sygate.scm.common.configobject.schema.LoginBannerText;
import com.sygate.scm.common.configobject.schema.LoginConfig;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.AdditionalUserInfoCollectorObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.util.Utility;

public class DomainObject
extends AbstractSelectableUIObject
implements TreeItem {
    public static final int DOMAINNAME_MAXLENGTH = 256;
    public static final int COMPANYNAME_MAXLENGTH = 1024;
    public static final int CONTACTLIST_MAXLENGTH = 2048;
    public static final int LOGIN_BANNER_TITLE_MAXLENGTH = 256;
    public static final int LOGIN_BANNER_TEXT_MAXLENGTH = 2048;
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    private String enable;
    private String disable;
    private SemDomain semDomain;

    public DomainObject() {
    }

    public DomainObject(SemDomain semDomain) {
        this.semDomain = semDomain;
    }

    public void print() {
        DomainObject.print(this);
    }

    public static void print(DomainObject domain) {
        if (domain == null) {
            System.out.println("==== DomainObject is null!");
            return;
        }
        System.out.println("================================================");
        System.out.println("==== Domain Properties: Begin");
        System.out.println("id=" + domain.getId());
        System.out.println("name" + domain.getName());
        System.out.println("company name=" + domain.getCompanyName());
        System.out.println("contact list=" + domain.getContactList());
        System.out.println("creation time=" + domain.getCreationTime() + " (" + domain.getCreationTimeDisplayString() + ")");
        System.out.println("description=" + domain.getDescription());
        System.out.println("enabled=" + domain.getEnableStatusDisplayString());
        System.out.println("group tree id=" + domain.getGroupTreeId());
        System.out.println("==== Domain Properties: End");
        System.out.println("================================================");
    }

    private LoginBanner createLoginBanner() {
        LoginBanner banner = new LoginBanner();
        LoginBannerText txt = new LoginBannerText();
        txt.setOptContent(this.res.getString("DomainObject.defaultLoginBannerText"));
        banner.setOptLoginBannerTitle(this.res.getString("DomainObject.defaultLoginBannerTitle"));
        banner.setLoginBannerText(txt);
        banner.setDisplay(Boolean.FALSE);
        return banner;
    }

    @Override
    public int getItemType() {
        return 40;
    }

    public String getDescription() {
        String description = this.semDomain.getOptDescription();
        return description == null ? "" : description;
    }

    public void setDescription(String value) {
        this.semDomain.setOptDescription(value);
    }

    @Override
    public String getId() {
        return this.semDomain.getId();
    }

    @Override
    public String getName() {
        return this.semDomain.getName();
    }

    public void setId(String string) {
        this.semDomain.setId(string);
    }

    public void setName(String string) {
        this.semDomain.setName(string);
    }

    public boolean isEnabled() {
        if (this.semDomain == null) {
            return false;
        }
        if (this.semDomain.getOptEnable() == null) {
            return true;
        }
        return this.semDomain.getOptEnable();
    }

    public void setEnabled(boolean value) {
        if (this.semDomain == null) {
            return;
        }
        this.semDomain.setOptEnable(Boolean.valueOf(value));
    }

    public boolean isCQEnabled() {
        if (this.semDomain == null) {
            return false;
        }
        if (this.semDomain.getOptCQEnabled() == null) {
            return false;
        }
        return this.semDomain.getOptCQEnabled();
    }

    public void setCQEnabled(boolean value) {
        if (this.semDomain == null) {
            return;
        }
        this.semDomain.setOptCQEnabled(Boolean.valueOf(value));
    }

    public String getEnableStatusDisplayString() {
        if (this.enable == null) {
            this.enable = this.res.getString("DomainObject.Enabled");
        }
        if (this.semDomain == null) {
            return this.enable;
        }
        if (this.disable == null) {
            this.disable = this.res.getString("DomainObject.Disabled");
        }
        return this.isEnabled() ? this.enable : this.disable;
    }

    public String toString() {
        return this.getName();
    }

    public SemDomain getSemDomain() {
        return this.semDomain;
    }

    public LoginConfig getLoginConfig() {
        AdministrativeConfig adminConfig = this.semDomain.getAdministrativeConfig();
        if (adminConfig == null) {
            System.out.println("DomainObject>> getLoginConfig: Error-> failed to get AdministrativeConfig. domain=" + this.semDomain.getName() + ", " + this.semDomain.getId());
            return null;
        }
        return adminConfig.getLoginConfig();
    }

    public String getCompanyName() {
        if (this.semDomain == null) {
            return "";
        }
        String companyName = this.semDomain.getOptCompanyName();
        return companyName == null ? "" : companyName;
    }

    public void setCompanyName(String companyName) {
        if (this.semDomain == null || companyName == null) {
            return;
        }
        this.semDomain.setOptCompanyName(companyName);
    }

    public String getContactList() {
        if (this.semDomain == null) {
            return "";
        }
        String contactList = this.semDomain.getOptContactInfo();
        return contactList == null ? "" : contactList;
    }

    public void setContactList(String contactList) {
        if (this.semDomain == null || contactList == null) {
            return;
        }
        this.semDomain.setOptContactInfo(contactList);
    }

    public long getCreationTime() {
        return this.semDomain != null ? this.semDomain.getCreationTime() : -1L;
    }

    public String getCreationTimeDisplayString() {
        if (this.semDomain == null) {
            return "";
        }
        long time = this.getCreationTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public boolean setCreationTime(long time) {
        if (this.semDomain == null) {
            return false;
        }
        this.semDomain.setCreationTime(Long.valueOf(time));
        return true;
    }

    public boolean setCreationTime() {
        return this.setCreationTime(TimeUtil.getServerTime());
    }

    public AdditionalUserInfoCollectorObject getAdditionalUserInfoCollectorObject(boolean alwayGet) {
        AdditionalUserInfoCollector collector = this.semDomain.getOptAdditionalUserInfoCollector();
        if (collector == null && alwayGet) {
            collector = new AdditionalUserInfoCollector();
            this.semDomain.setOptAdditionalUserInfoCollector(collector);
        }
        return collector == null ? null : new AdditionalUserInfoCollectorObject(collector);
    }

    public String getChecksum() {
        if (this.semDomain == null) {
            return null;
        }
        return this.semDomain.getMetadataAttributes().getChecksum();
    }

    public boolean isChecksumEqualSame(SemDomain domain) {
        if (this.semDomain == null || domain == null) {
            return false;
        }
        String cs1 = this.semDomain.getMetadataAttributes().getChecksum();
        String cs2 = domain.getMetadataAttributes().getChecksum();
        return cs1.equals(cs2);
    }

    public String getGroupTreeId() {
        if (this.semDomain == null) {
            return null;
        }
        return this.semDomain.getObjReference().getTargetId();
    }

    public String getLoginBannerText() {
        if (this.semDomain == null) {
            return null;
        }
        LoginBanner loginBanner = this.semDomain.getOptLoginBanner();
        if (loginBanner == null) {
            return null;
        }
        return loginBanner.getLoginBannerText().getOptContent();
    }

    public String getLoginBannerTitle() {
        if (this.semDomain == null) {
            return null;
        }
        LoginBanner loginBanner = this.semDomain.getOptLoginBanner();
        if (loginBanner == null) {
            return null;
        }
        return loginBanner.getOptLoginBannerTitle();
    }

    public boolean isDisplayLoginBanner() {
        if (this.semDomain == null) {
            return false;
        }
        LoginBanner loginBanner = this.semDomain.getOptLoginBanner();
        if (loginBanner == null) {
            return false;
        }
        return loginBanner.getDisplay();
    }

    public void setLoginBannerTitle(String loginBannerTitle) {
        LoginBanner banner = this.semDomain.getOptLoginBanner();
        if (banner == null) {
            banner = this.createLoginBanner();
            this.semDomain.setOptLoginBanner(banner);
        }
        banner.setOptLoginBannerTitle(loginBannerTitle);
    }

    public void setLoginBannerText(String loginBannerText) {
        LoginBanner banner = this.semDomain.getOptLoginBanner();
        if (banner == null) {
            banner = this.createLoginBanner();
            this.semDomain.setOptLoginBanner(banner);
        }
        banner.getLoginBannerText().setOptContent(loginBannerText);
    }

    public void setDisplayLoginBanner(boolean displayLoginBanner) {
        LoginBanner banner = this.semDomain.getOptLoginBanner();
        if (banner == null) {
            banner = this.createLoginBanner();
            this.semDomain.setOptLoginBanner(banner);
        }
        banner.setDisplay(Boolean.valueOf(displayLoginBanner));
    }

    public void setOptRememberPassword(boolean rememberPassword) {
        this.semDomain.setOptRememberPassword(Boolean.valueOf(rememberPassword));
    }

    public void setOptAllowNeverExpiringPassword(boolean allowNeverExpiringPassword) {
        this.semDomain.setOptAllowNeverExpiringPassword(Boolean.valueOf(allowNeverExpiringPassword));
    }

    public void setOptAutoDeleteIdleClient(boolean status) {
        this.semDomain.setOptAutoDeleteIdleClient(Boolean.valueOf(status));
    }

    public void setOptAutoDeleteIdleNPVDIClient(boolean status) {
        this.semDomain.setOptAutoDeleteIdleNPVDIClient(Boolean.valueOf(status));
    }

    public void setOptMaxClientIdleTime(int duration) {
        this.semDomain.setOptMaxClientIdleTime(Integer.valueOf(duration));
    }

    public void setOptMaxNPVDIClientIdleTime(int duration) {
        this.semDomain.setOptMaxNPVDIClientIdleTime(Integer.valueOf(duration));
    }

    public boolean getAutoDeleteIdleClient() {
        return this.semDomain.getOptAutoDeleteIdleClient() == null ? this.semDomain.getDefAutoDeleteIdleClient() : this.semDomain.getOptAutoDeleteIdleClient();
    }

    public boolean getAutoDeleteIdleNPVDIClient() {
        return this.semDomain.getOptAutoDeleteIdleNPVDIClient() == null ? this.semDomain.getDefAutoDeleteIdleNPVDIClient() : this.semDomain.getOptAutoDeleteIdleNPVDIClient();
    }

    public int getMaxClientIdleTime() {
        return this.semDomain.getOptMaxClientIdleTime() == null ? 2592000 : this.semDomain.getOptMaxClientIdleTime();
    }

    public int getMaxNPVDIClientIdleTime() {
        return this.semDomain.getOptMaxNPVDIClientIdleTime() == null ? this.semDomain.getDefMaxNPVDIClientIdleTime() : this.semDomain.getOptMaxNPVDIClientIdleTime();
    }
}

