/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.DhcpAuthSection;
import com.sygate.scm.common.configobject.schema.DhcpTrustedHostArray;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class DhcpTrustedHostArrayObject {
    private DhcpTrustedHostArray trustedHostArray;

    public DhcpTrustedHostArrayObject(DhcpTrustedHostArray trustedHostArray) {
        this.trustedHostArray = trustedHostArray;
    }

    public static DhcpTrustedHostArrayObject newInstance(DhcpAuthSection authSection) {
        DhcpTrustedHostArray trustedHostArray = new DhcpTrustedHostArray();
        authSection.setOptDhcpTrustedHostArray(trustedHostArray);
        return new DhcpTrustedHostArrayObject(trustedHostArray);
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.trustedHostArray.getOptEnable();
        if (isEnabled == null) {
            isEnabled = this.trustedHostArray.getDefEnable();
        }
        return isEnabled;
    }

    public Vector<MacAddress> getMacAddress() {
        return this.trustedHostArray.getMacAddress();
    }

    public ObjReference getOptMacAddressBlockReference() {
        return this.trustedHostArray.getOptObjReference();
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.trustedHostArray.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }

    public void setAllAddress(Collection<MacAddress> address) {
        Vector oldAddress = this.trustedHostArray.getMacAddress();
        int i = oldAddress.size();
        while (--i >= 0) {
            this.trustedHostArray.removeMacAddress((MacAddress)oldAddress.get(i));
        }
        Iterator<MacAddress> itr = address.iterator();
        while (itr.hasNext()) {
            this.trustedHostArray.addMacAddress(itr.next());
        }
    }

    public void setOptMacAddressBlockReference(ObjReference ref, int totalMacCount) {
        if (ref != null) {
            ref.setOptDescription(String.valueOf(totalMacCount));
        }
        this.trustedHostArray.setOptObjReference(ref);
    }

    public void deleteMacAddressBlockReference() {
        if (this.trustedHostArray != null) {
            this.trustedHostArray.setOptObjReference(null);
        }
    }
}

