/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.DhcpEnforcement;
import com.sygate.scm.common.configobject.schema.DhcpEnforcerMode;
import com.sygate.scm.common.configobject.schema.IntegratedEnforcement;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.LoggerUtilities;

public class DhcpEnforcerModeObject
extends AbstractUIObject {
    private DhcpEnforcerMode dhcpMode;

    public DhcpEnforcerModeObject(DhcpEnforcerMode dhcpMode) {
        this.dhcpMode = dhcpMode;
    }

    public static DhcpEnforcerModeObject newInstance(DhcpEnforcement dhcp) {
        DhcpEnforcerMode newMode = new DhcpEnforcerMode();
        dhcp.setOptDhcpEnforcerMode(newMode);
        return new DhcpEnforcerModeObject(newMode);
    }

    public static DhcpEnforcerModeObject newInstance(IntegratedEnforcement integrated) {
        DhcpEnforcerMode newMode = new DhcpEnforcerMode();
        integrated.setOptDhcpEnforcerMode(newMode);
        return new DhcpEnforcerModeObject(newMode);
    }

    public String getModeString() {
        try {
            String mode = this.dhcpMode.getOptModeValue();
            return mode == null ? "ENFORCE" : mode;
        }
        catch (ValidationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return "";
        }
    }

    public int getMode() {
        Integer mode = this.dhcpMode.getOptMode();
        if (mode == null) {
            mode = this.dhcpMode.getDefMode();
        }
        return mode;
    }

    public void setMode(int mode) {
        if (mode != this.getMode()) {
            this.dhcpMode.setOptMode(Integer.valueOf(mode));
        }
    }
}

