/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AllowNonWindows;
import com.sygate.scm.common.configobject.schema.CheckProfileSn;
import com.sygate.scm.common.configobject.schema.DhcpAuthSection;
import com.sygate.scm.common.configobject.schema.DhcpTrustedHostArray;
import com.sygate.scm.common.configobject.schema.DhcpTrustedHostLearning;
import com.sygate.scm.common.configobject.schema.EnforcerClientNotification;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.DhcpEnforcerAuthParameterObject;
import com.sygate.scm.console.logicobject.DhcpTrustedHostArrayObject;
import com.sygate.scm.console.logicobject.DhcpTrustedHostLearningObject;
import com.sygate.scm.console.logicobject.EnforcerAllowNonWindowsObject;
import com.sygate.scm.console.logicobject.EnforcerCheckProfileSnObject;
import com.sygate.scm.console.logicobject.EnforcerClientNotificationObject;
import java.util.Collection;

public class DhcpEnforcerAuthSectionObject
extends AbstractUIObject {
    private DhcpAuthSection authSection;

    public DhcpEnforcerAuthSectionObject(DhcpAuthSection authSection) {
        this.authSection = authSection;
    }

    public DhcpEnforcerAuthParameterObject getAuthParameterObject() {
        return new DhcpEnforcerAuthParameterObject(this.authSection.getDhcpAuthParameter());
    }

    public EnforcerAllowNonWindowsObject getAllowNonWindowsObject() {
        AllowNonWindows nonWindows = this.authSection.getOptAllowNonWindows();
        if (nonWindows == null) {
            return null;
        }
        return new EnforcerAllowNonWindowsObject(nonWindows);
    }

    public EnforcerCheckProfileSnObject getCheckProfileSnObject() {
        CheckProfileSn sn = this.authSection.getOptCheckProfileSn();
        if (sn == null) {
            return null;
        }
        return new EnforcerCheckProfileSnObject(sn);
    }

    public EnforcerClientNotificationObject getClientNotificationObject() {
        EnforcerClientNotification clientNotif = this.authSection.getOptEnforcerClientNotification();
        if (clientNotif == null) {
            return null;
        }
        return new EnforcerClientNotificationObject(clientNotif);
    }

    public DhcpTrustedHostLearningObject getTrustedHostLearningObject() {
        DhcpTrustedHostLearning trustedHostLearning = this.authSection.getOptDhcpTrustedHostLearning();
        if (trustedHostLearning == null) {
            return null;
        }
        return new DhcpTrustedHostLearningObject(trustedHostLearning);
    }

    public DhcpTrustedHostArrayObject getTrustedHostArrayObject() {
        DhcpTrustedHostArray trustedHostArray = this.authSection.getOptDhcpTrustedHostArray();
        if (trustedHostArray == null) {
            return null;
        }
        return new DhcpTrustedHostArrayObject(trustedHostArray);
    }

    public void setAuthParameterObject(String authPort, String authPacket, String packetInterval, String authenticationTimeout, String dhcpMessageTimeout) {
        DhcpEnforcerAuthParameterObject authParaObj = this.getAuthParameterObject();
        authParaObj.setAuthPort(authPort);
        authParaObj.setAuthPacket(authPacket);
        authParaObj.setPacketInterval(packetInterval);
        if (authenticationTimeout != null) {
            authParaObj.setAuthenticationTimeout(authenticationTimeout);
        }
        if (dhcpMessageTimeout != null) {
            authParaObj.setDhcpMessageTimeout(dhcpMessageTimeout);
        }
    }

    public void setAllowNonWindowsObject(boolean isEnabled) {
        EnforcerAllowNonWindowsObject nonWindowsObj = this.getAllowNonWindowsObject();
        if (nonWindowsObj == null) {
            nonWindowsObj = EnforcerAllowNonWindowsObject.newInstance(this.authSection);
        }
        nonWindowsObj.setEnabled(isEnabled);
    }

    public void setCheckProfileSnObject(boolean isEnabled) {
        EnforcerCheckProfileSnObject profileSnObj = this.getCheckProfileSnObject();
        if (profileSnObj == null) {
            profileSnObj = EnforcerCheckProfileSnObject.newInstance(this.authSection);
        }
        profileSnObj.setEnabled(isEnabled);
    }

    public void setClientNotificationObject(boolean isEnabled, String interval, String additionalText) {
        EnforcerClientNotificationObject clientNtfObj = this.getClientNotificationObject();
        if (clientNtfObj == null) {
            clientNtfObj = EnforcerClientNotificationObject.newInstance(this.authSection);
        }
        clientNtfObj.setEnabled(isEnabled);
        clientNtfObj.setInterval(interval);
        clientNtfObj.setAdditionalText(additionalText);
    }

    public void setTrustedHostLearningObject(boolean isEnabled) {
        DhcpTrustedHostLearningObject trustedHostLearningObj = this.getTrustedHostLearningObject();
        if (trustedHostLearningObj == null) {
            trustedHostLearningObj = DhcpTrustedHostLearningObject.newInstance(this.authSection);
        }
        trustedHostLearningObj.setEnabled(isEnabled);
    }

    public void setMacAddressBlockRef(ObjReference block, int totalMacCount) {
        DhcpTrustedHostArrayObject trustedHostArrayObj = this.getTrustedHostArrayObject();
        if (trustedHostArrayObj == null) {
            trustedHostArrayObj = DhcpTrustedHostArrayObject.newInstance(this.authSection);
        }
        if (block == null) {
            trustedHostArrayObj.setOptMacAddressBlockReference(null, 0);
        } else {
            trustedHostArrayObj.setOptMacAddressBlockReference(block, totalMacCount);
        }
    }

    public void setTrustedHostArrayObject(Collection<MacAddress> macAddress) {
        DhcpTrustedHostArrayObject trustedHostArrayObj = this.getTrustedHostArrayObject();
        if (trustedHostArrayObj == null && macAddress != null) {
            trustedHostArrayObj = DhcpTrustedHostArrayObject.newInstance(this.authSection);
        }
        if (macAddress != null && trustedHostArrayObj != null) {
            trustedHostArrayObj.setAllAddress(macAddress);
        }
        if (trustedHostArrayObj == null) {
            this.authSection.setOptDhcpTrustedHostArray(null);
        }
    }
}

