/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.ExtendedOpDevice;
import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class DeviceObject
extends AbstractUIObject
implements TableRow,
Serializable {
    private static final long serialVersionUID = -9155073682995659078L;
    public static final int INDEX_NAME = 0;
    public static final int INDEX_INDEFICATION = 2;
    public static final int INDEX_ID = 1;
    public static final int INDEX_VENDOR = 4;
    public static final int INDEX_MODEL = 5;
    public static final int INDEX_PERMISSION = 3;
    public static final int INDEX_PLATFORM = 6;
    public static final int INDEX_SERIALNUMBER = 7;
    static final int SYSTEM = 1;
    protected OpDevice opDevice = null;
    private String deviceModel = "";
    private String deviceVendor = "";
    private Integer permission = null;
    private String serialNumber = "";
    private HashMap<Integer, ImageIcon> iconMap = new HashMap();
    private HashMap<Integer, String> platformMap = new HashMap();
    private static final Map<Integer, String> permissionMap = new HashMap<Integer, String>();

    private void initOsMap() {
        this.iconMap.put(OpDevice.WINDOWS, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("windowsIcon.png"))));
        this.iconMap.put(OpDevice.MAC, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("appleIcon.png"))));
        this.platformMap.put(OpDevice.WINDOWS, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "DeviceObject.WindowsOsColumn"));
        this.platformMap.put(OpDevice.MAC, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "DeviceObject.MacOsColumn"));
    }

    public static String getPermssionMessage(Integer permission) {
        return permission == null ? permissionMap.get(ExtendedOpDevice.READONLY) : permissionMap.get(permission);
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getDeviceVendor() {
        return this.deviceVendor;
    }

    public void setDeviceVendor(String deviceVendor) {
        this.deviceVendor = deviceVendor;
    }

    public Integer getPermission() {
        return this.permission;
    }

    public void setPermission(Integer permission) {
        this.permission = permission;
    }

    public DeviceObject() {
        this.initOsMap();
    }

    public DeviceObject(OpDevice opDevice) {
        this.opDevice = opDevice;
        this.initOsMap();
    }

    public DeviceObject(String name, String deviceClassId, String deviceInstanceId, String description) {
        this.opDevice = new OpDevice();
        this.opDevice.setId(new GUIDGenerator().getGUIDString());
        this.opDevice.setName(name);
        this.opDevice.setOptDescription(description);
        this.opDevice.setOptDeviceClassGuid(deviceClassId);
        this.opDevice.setOptDeviceInstanceId(deviceInstanceId);
        this.initOsMap();
    }

    public boolean isValid() {
        return this.opDevice != null;
    }

    public void setOpDevice(OpDevice opDevice) {
        this.opDevice = opDevice;
    }

    public void setName(String name) {
        if (!this.isValid()) {
            return;
        }
        this.opDevice.setName(name);
    }

    public void setDeviceClassId(String id) {
        if (!this.isValid()) {
            return;
        }
        this.opDevice.setOptDeviceClassGuid(id);
    }

    public void setDeviceInstanceId(String id) {
        if (!this.isValid()) {
            return;
        }
        this.opDevice.setOptDeviceInstanceId(id);
    }

    public Integer getPlatform() {
        Integer ret = this.opDevice.getOptPlatform();
        return ret == null ? this.opDevice.getDefPlatform() : ret;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.opDevice != null ? this.opDevice.getName() : "";
    }

    public String getDescription() {
        return this.opDevice != null && this.opDevice.getOptDescription() != null ? this.opDevice.getOptDescription() : "";
    }

    public OpDevice getDevice() {
        return this.opDevice;
    }

    public String getId() {
        return this.opDevice != null ? this.opDevice.getId() : "";
    }

    public String getDeviceClassId() {
        return this.opDevice != null && this.opDevice.getOptDeviceClassGuid() != null ? this.opDevice.getOptDeviceClassGuid() : "";
    }

    public String getDeviceInstanceId() {
        return this.opDevice != null && this.opDevice.getOptDeviceInstanceId() != null ? this.opDevice.getOptDeviceInstanceId() : "";
    }

    public boolean equals(Object obj) {
        if (!this.isValid() || obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceObject)) {
            return false;
        }
        DeviceObject o = (DeviceObject)obj;
        if (!o.isValid()) {
            return false;
        }
        return this.getId().equals(o.getId());
    }

    public boolean isEqualsWithExtraFields(DeviceObject obj) {
        boolean ret = this.equals(obj);
        if (ret) {
            ret = Utility.isIntegerEquals((Integer)obj.getPermission(), (Integer)this.permission) && StringUtilities.isEqualIgnoreCase((String)obj.getDeviceModel(), (String)this.getDeviceModel()) && StringUtilities.isEqualIgnoreCase((String)obj.getDeviceVendor(), (String)this.getDeviceVendor()) && StringUtilities.isEqualIgnoreCase((String)obj.getSerialNumber(), (String)this.getSerialNumber());
        }
        return ret;
    }

    public int hashCode() {
        return this.getId().hashCode() & this.getName().hashCode() & this.getDescription().hashCode();
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getName();
            }
            case 1: {
                if (this.getDeviceInstanceId() == null || this.getDeviceInstanceId().equals("")) {
                    return this.getDeviceClassId();
                }
                return this.getDeviceInstanceId();
            }
            case 2: {
                if (this.getDeviceInstanceId() == null || this.getDeviceInstanceId().equals("")) {
                    return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "DeviceObject.column.Identification.Class") + "         " + this.getDeviceClassId();
                }
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "DeviceObject.column.Identification.Instance") + "         " + this.getDeviceInstanceId();
            }
            case 4: {
                return StringUtilities.isEmpty((String)this.deviceVendor) ? ".*" : this.deviceVendor;
            }
            case 5: {
                return StringUtilities.isEmpty((String)this.deviceModel) ? ".*" : this.deviceModel;
            }
            case 3: {
                return DeviceObject.getPermssionMessage(this.permission);
            }
            case 6: {
                return this.getPlatformLabel();
            }
            case 7: {
                return StringUtilities.isEmpty((String)this.serialNumber) ? ".*" : this.serialNumber;
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 6: {
                return JLabel.class;
            }
        }
        return String.class;
    }

    private JLabel getPlatformLabel() {
        JLabel label = new JLabel();
        label.setIcon(this.iconMap.get(this.getPlatform()));
        label.setText(this.platformMap.get(this.getPlatform()));
        return label;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public boolean isSystem() {
        Integer attribute;
        return this.opDevice != null && (attribute = this.opDevice.getOptObjAttributes()) != null && attribute == 1;
    }

    public OpDevice getCopyOfPolicyObject() throws ConsoleException {
        return (OpDevice)PolicyHandler.getCopyOfObj((ConfigObject)this.opDevice);
    }

    public void setPlatform(int platform) {
        this.opDevice.setOptPlatform(Integer.valueOf(platform));
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    static {
        permissionMap.put(ExtendedOpDevice.READONLY, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.Permission.ReadOnly"));
        permissionMap.put(ExtendedOpDevice.READEXECUTE, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.Permission.ReadExecute"));
        permissionMap.put(ExtendedOpDevice.READWRITE, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.Permission.ReadWrite"));
        permissionMap.put(ExtendedOpDevice.ALL, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "MacDeviceSelectDialog.Permission.All"));
    }
}

