/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.Database;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DatabaseObject
extends AbstractUIObject
implements TreeItem {
    private Database database;
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");

    public DatabaseObject(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getItemType() {
        return 15;
    }

    @Override
    public String getId() {
        return this.database.getId();
    }

    @Override
    public String getName() {
        return this.database.getName();
    }

    public String getDescription() {
        String string = this.database.getOptDescription();
        return string == null ? "" : string.trim();
    }

    public String getServerAddress() {
        String string = this.database.getServerAddress();
        return string == null ? "" : string.trim();
    }

    public String getDBOperatorUserName() {
        String string = this.database.getDBOperatorUserName();
        return string == null ? "" : string.trim();
    }

    public String getProductName() {
        String string = this.database.getDatabaseProductName();
        if ("Microsoft SQL Server Express".equals(string)) {
            string = Boolean.TRUE.equals(this.database.getOptDatabaseInstanceEmbedded()) ? MSGRES.getString("DatabaseObject.DbType.sqlexpress.embedded") : MSGRES.getString("DatabaseObject.DbType.sqlexpress");
        } else if ("Microsoft SQL Server".equals(string)) {
            string = Boolean.TRUE.equals(this.database.getOptDatabaseInstanceEmbedded()) ? MSGRES.getString("DatabaseObject.DbType.sqlserver.embedded") : MSGRES.getString("DatabaseObject.DbType.sqlserver");
        }
        return string;
    }

    public String getDatabaseInstancePort() {
        String displayValue = "";
        if (this.database.getOptDatabaseInstancePort() != null) {
            displayValue = String.valueOf(this.database.getOptDatabaseInstancePort());
        }
        return displayValue;
    }

    public String getProductVersion() {
        String string = this.database.getDatabaseProductVersion();
        return string == null ? "" : string.trim();
    }

    public String getDatabaseInstanceId() {
        String string = this.database.getDatabaseInstanceId();
        return string == null ? "" : string.trim();
    }

    public String getCreationTime() {
        Long time = this.database.getCreationTime();
        if (time == null || time == 0L) {
            return "Not Available";
        }
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        return format.format(new Date(time));
    }

    public String getDisplayCreationTime() {
        Long time = this.database.getCreationTime();
        if (time == null || time == 0L) {
            return "";
        }
        DateFormat format = DateFormat.getDateTimeInstance(0, 1, Locale.getDefault());
        format.setTimeZone(Utility.getLocalTimeZone());
        return format.format(new Date(time));
    }

    public String toString() {
        return this.getName();
    }
}

