/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuFile;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.awt.Toolkit;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class CurrentPackageObject
extends AbstractUIObject
implements TableRow {
    public static final int PACKAGE_NAME = 0;
    public static final int PACKAGE_PLATFORM = 1;
    public static final int PACKAGE_TYPE = 2;
    public static final int VERSION = 3;
    public static final int LATEST_PACKAGE = 4;
    public static final int CREATED_TIME = 5;
    public static final int DESCRIPTION = 6;
    SoftwarePackage softwarePackage = null;
    private static final Map<String, String> PLATFORM_NAME_MAP;
    private static final Map<String, ImageIcon> PLATFORM_ICON_MAP;
    private static final MessageResourcesFile MSG_RES;
    private String srcDirectory = "";
    SemServerList importServerList = null;

    public CurrentPackageObject(SoftwarePackage sp) {
        this.softwarePackage = sp;
    }

    public SoftwarePackage getSoftwarePackage() {
        return this.softwarePackage;
    }

    public SoftwarePackageObject getSoftwarePackageObject() {
        return new SoftwarePackageObject(this.softwarePackage);
    }

    public CurrentPackageObject(String name, String description) {
        this(SoftwarePackageObject.newSoftwarePackage(name, description));
    }

    public void setSoftwarePackage(SoftwarePackage sp) {
        this.softwarePackage = sp;
    }

    public void setSrcDirectory(String dir) {
        this.srcDirectory = dir;
    }

    public String getSrcDirectory() {
        return this.srcDirectory;
    }

    public void setImportServerList(SemServerList serverList) {
        this.importServerList = serverList;
    }

    public SemServerList getImportServerList() {
        return this.importServerList;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public JLabel getPlatformLabelForSwPackage() {
        JLabel label = new JLabel();
        String packagePlatform = this.getPackagePlatformString();
        label.setIcon(CurrentPackageObject.getPlatformIcon(packagePlatform));
        label.setText(CurrentPackageObject.getPlatformName(packagePlatform));
        return label;
    }

    public JLabel getPlatformLabelForSwPackageWithType() {
        JLabel label = new JLabel();
        String packagePlatform = this.getPackagePlatformString();
        label.setIcon(CurrentPackageObject.getPlatformIcon(packagePlatform));
        label.setText(this.getPlatformNameWithType(packagePlatform));
        return label;
    }

    public String getPackagePlatformString() {
        return this.getSoftwarePackageObject().getPackagePlatformString();
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.softwarePackage.getName();
            }
            case 1: {
                return this.getPlatformLabelForSwPackageWithType();
            }
            case 2: {
                return SoftwarePackageObject.getTypeDisplayString(this.softwarePackage.getPackageInfo().getType());
            }
            case 3: {
                String version = null;
                version = PackageUtil.isLinuxStub((String)this.softwarePackage.getPackageInfo().getOptPlatformType()) ? Utility.getFormattedClientVersion((String)this.getSoftwarePackageObject().getPackageInfo().getVersion(), (boolean)true) : (this.getSoftwarePackageObject().isSecurityFixContent() ? this.getSoftwarePackageObject().getVersion() : Utility.getFormattedClientVersion((String)this.getSoftwarePackageObject().getVersion(), (boolean)false));
                return version;
            }
            case 5: {
                return UIUtilities.formatDate(this.softwarePackage.getCreationTime());
            }
            case 6: {
                return this.getDescription();
            }
            case 4: {
                String[] versions;
                String version = this.getSoftwarePackageObject().getPackageInfo().getVersion();
                String importTime = UIUtilities.formatDate(this.softwarePackage.getCreationTime());
                SecurityFixContentInfoObject latestSecurityFix = this.getSoftwarePackageObject().getLatestSecurityFixContentInfoObject();
                if (latestSecurityFix != null) {
                    version = latestSecurityFix.getSecurityFixContentInfo().getProductBuildNum();
                    importTime = UIUtilities.formatDate(latestSecurityFix.getSecurityFixContentInfo().getT());
                }
                if ((versions = version.split("\\.")).length == 4 && Utility.compareVersion((String)version, (String)"14.2.0.1000") >= 0) {
                    version = versions[2];
                }
                return MessageFormat.format(MSG_RES.getString("CurrentPackageObject.latest.package.desc"), version, importTime);
            }
        }
        return null;
    }

    static String getPlatformName(String packagePlatform) {
        String platform = ConstantValue.getPlatformsSupportedByIndex((int)1);
        if ("Mac".equals(packagePlatform)) {
            platform = ConstantValue.getPlatformsSupportedByIndex((int)2);
        }
        if (ConstantValue.isLinuxPlatform((String)packagePlatform) || ConstantValue.isLinuxStubPlatform((String)packagePlatform)) {
            platform = ConstantValue.getPlatformsSupportedByIndex((int)3);
        }
        if ("LINUXSTUB_ARM64".equalsIgnoreCase(packagePlatform)) {
            platform = "Linux_ARM64";
        }
        return PLATFORM_NAME_MAP.get(platform);
    }

    String getPlatformNameWithType(String packagePlatform) {
        String type = null;
        if ("Mac".equals(packagePlatform)) {
            String platform = ConstantValue.getPlatformsSupportedByIndex((int)2);
            type = PLATFORM_NAME_MAP.get(platform);
        } else if ("WIN32BIT".equals(this.softwarePackage.getPackageInfo().getOptPlatformType())) {
            type = MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Win_32bit");
        } else if ("WIN64BIT".equals(this.softwarePackage.getPackageInfo().getOptPlatformType())) {
            type = MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Win_64bit");
        } else if ("LINUXRPM".equals(this.softwarePackage.getPackageInfo().getOptPlatformType())) {
            type = MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_rpm");
        } else if ("LINUXDPKG".equals(this.softwarePackage.getPackageInfo().getOptPlatformType())) {
            type = MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_dpkg");
        } else if ("LINUXSTUB".equals(this.softwarePackage.getPackageInfo().getOptPlatformType())) {
            type = MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_stub");
            if (type.contains("Stub")) {
                type = type.replace("Stub", "");
            }
        } else if ("LINUXSTUB_ARM64".equals(this.softwarePackage.getPackageInfo().getOptPlatformType())) {
            type = MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_ARM64");
        }
        return type;
    }

    static ImageIcon getPlatformIcon(String packagePlatform) {
        String platform = ConstantValue.getPlatformsSupportedByIndex((int)1);
        if ("Mac".equals(packagePlatform)) {
            platform = ConstantValue.getPlatformsSupportedByIndex((int)2);
        }
        if (ConstantValue.isLinuxPlatform((String)packagePlatform) || ConstantValue.isLinuxStubPlatform((String)packagePlatform)) {
            platform = ConstantValue.getPlatformsSupportedByIndex((int)3);
        }
        if ("LINUXSTUB_ARM64".equals(packagePlatform)) {
            platform = "LINUXSTUB_ARM64";
        }
        return PLATFORM_ICON_MAP.get(platform);
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return JLabel.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 5: {
                return Date.class;
            }
            case 6: {
                return String.class;
            }
        }
        return null;
    }

    public String getPackageName() {
        return this.softwarePackage.getName();
    }

    public int getPackageType() {
        return this.softwarePackage.getPackageInfo().getType();
    }

    public long getSize() {
        return this.softwarePackage.getPackageInfo().getSize();
    }

    public long getUnZippedSize() {
        return this.getSoftwarePackageObject().getUnZippedSize();
    }

    public long getCreatedTime() {
        return this.softwarePackage.getCreationTime();
    }

    public String getDescription() {
        return this.softwarePackage.getOptDescription();
    }

    public InstallationOption getInstallationOption() {
        return this.softwarePackage.getOptInstallationOption();
    }

    public InstallationOption cloneInstallationOption() {
        return this.getSoftwarePackageObject().cloneInstallationOption();
    }

    public void setInstallationOption(InstallationOption option) {
        if (option == null) {
            return;
        }
        this.softwarePackage.setOptInstallationOption(option);
    }

    public void setCommunicationOption(CommunicationOption option) {
        this.softwarePackage.setOptCommunicationOption(option);
    }

    public CommunicationOption cloneCommunicationOption() {
        return this.getSoftwarePackageObject().cloneCommunicationOption();
    }

    public CommunicationOption getCommunicationOption() {
        return this.softwarePackage.getOptCommunicationOption();
    }

    public void setDescription(String description) {
        this.softwarePackage.setOptDescription(description);
    }

    public void setName(String name) {
        this.softwarePackage.setName(name);
    }

    public String getNameFromSrcDirectory() {
        File filePackageSource = new File(this.srcDirectory);
        return filePackageSource.getName();
    }

    public String getId() {
        if (this.softwarePackage == null) {
            return "";
        }
        return this.softwarePackage.getId();
    }

    public String getServerListId() {
        return this.getSoftwarePackageObject().getServerListId();
    }

    public String toString() {
        return this.softwarePackage.getName();
    }

    public String getServerMoniker() {
        if (this.softwarePackage == null) {
            return "";
        }
        PackageInfo pkgInfo = this.softwarePackage.getPackageInfo();
        PackageLuInfo luInfo = pkgInfo.getOptPackageLuInfo();
        String moniker = null;
        if (luInfo != null) {
            moniker = luInfo.getServerMoniker();
        }
        return moniker;
    }

    public long getSequenceNumber() {
        if (this.softwarePackage == null) {
            return 0L;
        }
        PackageInfo pkgInfo = this.softwarePackage.getPackageInfo();
        PackageLuInfo luInfo = pkgInfo.getOptPackageLuInfo();
        long seqNum = 0L;
        if (luInfo != null) {
            try {
                seqNum = Long.parseLong(luInfo.getSequenceNumber());
            }
            catch (NumberFormatException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return seqNum;
    }

    public boolean isMacNormalPackage() {
        return this.getSoftwarePackageObject().isMacNormalPackage();
    }

    public String getPackageVersion() {
        return this.softwarePackage.getPackageInfo().getVersion();
    }

    public String getPlatformType() {
        return this.softwarePackage.getPackageInfo().getOptPlatformType();
    }

    public PackageLuFile getPackageLuFile(String luFilename) {
        PackageInfo pInfo = this.softwarePackage.getPackageInfo();
        for (PackageLuFile luFile : pInfo.getPackageLuFile()) {
            if (!luFile.getFileName().equalsIgnoreCase(luFilename)) continue;
            return luFile;
        }
        return null;
    }

    static {
        MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.av.logicobject.avlogicobject");
        HashMap<String, String> platformNameMap = new HashMap<String, String>();
        for (String platform : ConstantValue.getPlatformsSupported()) {
            if (platform.equals(ConstantValue.getPlatformsSupportedByIndex((int)0))) continue;
            platformNameMap.put(platform, MSG_RES.getString("CurrentPackageObject.platform.columnHeader." + platform));
        }
        PLATFORM_NAME_MAP = Collections.unmodifiableMap(platformNameMap);
        HashMap<String, ImageIcon> platformIconMap = new HashMap<String, ImageIcon>();
        platformIconMap.put("Win", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("windowsIcon.png"))));
        platformIconMap.put("Mac", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("appleIcon.png"))));
        platformIconMap.put("Linux", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("icon_os_linux.png"))));
        platformIconMap.put("LINUXSTUB_ARM64", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("icon_os_linux.png"))));
        PLATFORM_ICON_MAP = Collections.unmodifiableMap(platformIconMap);
    }
}

