/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.util.GUIDGenerator;
import javax.swing.Icon;

public class ComputerObject
extends ClientObject {
    public static final int POLICY_MODE_INT = 1;
    public static final Integer POLICY_MODE = 1;

    public ComputerObject() {
    }

    public ComputerObject(String groupId, String name, String description, String domainName) {
        this.client = new SemClient();
        this.client.setClientId(new GUIDGenerator().getGUIDString());
        this.client.setOptDomainId(Manager.getCurrentDomainId());
        this.client.setOptGroupId(groupId);
        this.client.setOptComputerName(name);
        this.client.setOptDescription(description);
        this.client.setOptComputerDomainName(domainName);
        this.client.setOptPolicyMode(POLICY_MODE);
        this.client.setOptCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setOptCreator(Integer.valueOf(0));
        this.client.setTimeStamp(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setUSN(Long.valueOf(0L));
        this.client.setDeleted(Integer.valueOf(0));
    }

    public ComputerObject(SemClient client) {
        if (client == null) {
            client = new SemClient();
        }
        this.client = client;
    }

    public void setSemClient(SemClient client) {
        this.client = client;
    }

    @Override
    public String getName() {
        return this.getComputerName();
    }

    @Override
    public void setName(String string) {
        this.setComputerName(string);
    }

    @Override
    public String getDomainName() {
        return this.getComputerDomainName();
    }

    @Override
    public void setDomainName(String value) {
        this.setComputerDomainName(value);
    }

    @Override
    public String getLoginName() {
        return this.getUserName();
    }

    @Override
    public void setLoginName(String value) {
        this.setUserName(value);
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public Icon getOnlineIconForLocal() {
        if (this.isLanSensor()) {
            return ConsoleMain.lanSensorOnIcon;
        }
        return ConsoleMain.computerOnIcon;
    }

    @Override
    public Icon getInstallErrorIcon() {
        return ConsoleMain.installErrorIcon;
    }

    @Override
    public Icon getOnlineIconForRemoteServer() {
        if (this.isLanSensor()) {
            return ConsoleMain.lanSensorOnIcon;
        }
        return ConsoleMain.computerOnIcon;
    }

    @Override
    public Icon getOnlineIconForRemoteSite() {
        if (this.isLanSensor()) {
            return ConsoleMain.lanSensorOnRemoteIcon;
        }
        return ConsoleMain.computerOnRemoteIcon;
    }

    @Override
    public Icon getOfflineIcon() {
        if (this.isLanSensor()) {
            return ConsoleMain.lanSensorIcon;
        }
        return ConsoleMain.computerIcon;
    }
}

