/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.AdditionalAllowedFile;
import com.sygate.scm.common.configobject.schema.AdditionalAllowedFileArray;
import com.sygate.scm.common.configobject.schema.AppliedImage;
import com.sygate.scm.common.configobject.schema.AppliedImageArray;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.configobject.schema.ComputerLockdownNotification;
import com.sygate.scm.common.configobject.schema.ComputerLockdownProtection;
import com.sygate.scm.common.configobject.schema.LockdownSet;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LockdownExceptionObject;
import com.sygate.scm.console.logicobject.LockdownFileListObject;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ComputerLockdownProtectionObject
extends AbstractUIObject {
    public static final int MAX_COUNT_APPLIEDIMAGES = 512;
    public static final int MAX_COUNT_EXTRAFILES = 512;
    public static final int POLICYMODE_DISABLED = 0;
    public static final int POLICYMODE_ENABLED = 1;
    public static final int POLICYMODE_TESTING = 2;
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    ComputerLockdownProtection lockdown = null;

    public ComputerLockdownProtectionObject() {
    }

    public ComputerLockdownProtectionObject(ComputerLockdownProtection lockdown) {
        this.lockdown = lockdown;
    }

    public static ComputerLockdownProtectionObject newInstance() {
        ComputerLockdownProtection lockdown = new ComputerLockdownProtection();
        lockdown.setOptEnable(Boolean.TRUE);
        lockdown.setOptTestItemsLastModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
        return new ComputerLockdownProtectionObject(lockdown);
    }

    protected void addWhiteList(LockdownFileListObject o, LockdownSet set) {
        AppliedImage image;
        if (set == null || o == null || !o.isWhiteList()) {
            return;
        }
        AppliedImageArray array = set.getOptAppliedImageArray();
        if (array == null) {
            array = new AppliedImageArray();
            set.setOptAppliedImageArray(array);
        }
        if ((image = o.generateAppliedImage()) != null) {
            array.addAppliedImage(image);
        }
    }

    protected void addExtraFile(LockdownFileListObject o, LockdownSet set) {
        AdditionalAllowedFile file;
        if (set == null || o == null || o.isWhiteList()) {
            return;
        }
        AdditionalAllowedFileArray array = set.getOptAdditionalAllowedFileArray();
        if (array == null) {
            array = new AdditionalAllowedFileArray();
            set.setOptAdditionalAllowedFileArray(array);
        }
        if ((file = o.generateAdditionalAllowedFile()) != null) {
            array.addAdditionalAllowedFile(file);
        }
    }

    public ComputerLockdownProtection getComputerLockdownProtection() {
        return this.lockdown;
    }

    public boolean isValid() {
        return this.lockdown != null;
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    public boolean isEnabled() {
        if (!this.isValid()) {
            return false;
        }
        return this.lockdown.getOptEnable() == null ? this.lockdown.getDefEnable() : this.lockdown.getOptEnable();
    }

    public boolean isBlacklistEnabled() {
        if (!this.isValid()) {
            return false;
        }
        return this.lockdown.getOptBlacklistEnabled() == null ? this.lockdown.getDefBlacklistEnabled() : this.lockdown.getOptBlacklistEnabled();
    }

    public void setBlacklistEnabled(boolean enabled) {
        this.lockdown.setOptBlacklistEnabled(Boolean.valueOf(enabled));
    }

    public boolean isTestMode() {
        if (!this.isValid()) {
            return true;
        }
        Integer mode = this.lockdown.getOptMode();
        if (mode == null) {
            mode = this.lockdown.getDefMode();
        }
        return mode.equals(ComputerLockdownProtection.TEST);
    }

    public boolean isNormalMode() {
        return !this.isTestMode();
    }

    public boolean isPolicyDisabled() {
        return this.isDisabled();
    }

    public boolean isPolicyTesting() {
        return !this.isEnabled() ? false : this.isTestMode();
    }

    public boolean isPolicyActivated() {
        return !this.isEnabled() ? false : this.isNormalMode();
    }

    public int getPolicyMode() {
        int result = 0;
        if (this.isPolicyActivated()) {
            result = 1;
        } else if (this.isPolicyTesting()) {
            result = 2;
        }
        return result;
    }

    public void setPolicyMode(int mode) {
        if (!this.isValid()) {
            return;
        }
        switch (mode) {
            case 0: {
                this.lockdown.setOptEnable(Boolean.FALSE);
                break;
            }
            case 1: {
                this.lockdown.setOptEnable(Boolean.TRUE);
                this.lockdown.setOptMode(ComputerLockdownProtection.NORMAL);
                break;
            }
            case 2: {
                this.lockdown.setOptEnable(Boolean.TRUE);
                this.lockdown.setOptMode(ComputerLockdownProtection.TEST);
                break;
            }
        }
    }

    public boolean needNotifyUser() {
        if (!this.isValid()) {
            return false;
        }
        if (this.lockdown.getOptComputerLockdownNotification() == null) {
            return false;
        }
        ComputerLockdownNotification notify = this.lockdown.getOptComputerLockdownNotification();
        if (notify != null) {
            return (notify.getOptEnable() != null || notify.getDefEnable() != false) && notify.getOptEnable() != false;
        }
        return false;
    }

    public String getExtraMessage() {
        if (!this.isValid()) {
            return "";
        }
        if (this.lockdown.getOptComputerLockdownNotification() == null) {
            return "";
        }
        ComputerLockdownNotification notify = this.lockdown.getOptComputerLockdownNotification();
        if (notify != null) {
            return notify.getOptAdditionalText() == null ? "" : notify.getOptAdditionalText();
        }
        return "";
    }

    public void setNotifyUser(boolean enabled, String message) {
        if (!this.isValid()) {
            return;
        }
        ComputerLockdownNotification notify = this.lockdown.getOptComputerLockdownNotification();
        if (notify == null) {
            notify = new ComputerLockdownNotification();
            this.lockdown.setOptComputerLockdownNotification(notify);
        }
        notify.setOptEnable(Boolean.valueOf(enabled));
        notify.setOptAdditionalText(message);
    }

    public boolean hasActiveAppInActiveMode() {
        if (!this.isValid()) {
            return false;
        }
        if (!this.isPolicyActivated()) {
            return false;
        }
        return this.hasExtraFilesForNoTest() || this.hasWhiteListForNoTest();
    }

    public boolean hasTestRunning() {
        if (!this.isValid()) {
            return false;
        }
        return this.isTestMode() || this.hasExtraFilesForTest() || this.hasWhiteListForTest();
    }

    public long getLastTestModifiedTime() {
        if (!this.isValid()) {
            return 0L;
        }
        if (this.lockdown.getOptTestItemsLastModifiedTime() == null) {
            return 0L;
        }
        return this.lockdown.getOptTestItemsLastModifiedTime();
    }

    public long getTestElapsedTime() {
        long lastTestModifiedTime = this.getLastTestModifiedTime();
        long elapsedTime = TimeUtil.getServerTime() - lastTestModifiedTime;
        return elapsedTime;
    }

    public String getLastTestModifiedTimeDisplayString() {
        long lastTestModifiedTime = this.getLastTestModifiedTime();
        long elapsedTime = TimeUtil.getServerTime() - lastTestModifiedTime;
        System.out.println("ComputerLockdownProtectionObject>> getLastTestModifiedTimeDisplayString: lastTestModifiedTime=" + lastTestModifiedTime + ", elapsedTime=" + elapsedTime);
        if (elapsedTime < 0L) {
            return "";
        }
        return Utility.getTimeDurationString((long)elapsedTime);
    }

    public void resetLastTestModifiedTime() {
        this.setLastTestModifiedTime(TimeUtil.getServerTime());
    }

    public void setLastTestModifiedTime(long time) {
        if (!this.isValid()) {
            return;
        }
        System.out.println("ComputerLockdownProtectionObject>> setLastTestModifiedTime: time=" + time + " (" + Utility.getDateTimeString((long)time, null, null) + ")");
        this.lockdown.setOptTestItemsLastModifiedTime(Long.valueOf(time));
    }

    public String getStatusDisplayString(String[] groupId) {
        long[] exceptionRet = this.getExceptionCount(groupId);
        long exceptionCount = exceptionRet[0];
        long elapsedTime = exceptionRet[1];
        if (this.isDisabled() || !this.hasTestRunning() || elapsedTime < 0L) {
            return this.res.getString("ComputerLockdownProtectionObject.noTestRunning");
        }
        String time = Utility.getTimeDurationString((long)elapsedTime);
        if (exceptionCount > 1L) {
            return MessageFormat.format(this.res.getString("ComputerLockdownProtectionObject.runningWithExceptions"), time, exceptionCount);
        }
        if (exceptionCount == 1L) {
            return MessageFormat.format(this.res.getString("ComputerLockdownProtectionObject.runningWithOneException"), time);
        }
        return MessageFormat.format(this.res.getString("ComputerLockdownProtectionObject.runningNoException"), time);
    }

    public long[] getExceptionCount(String[] groupId) {
        long[] ret = new long[2];
        long beginTime = this.getLastTestModifiedTime();
        long count = 0L;
        long elapsedTime = -1L;
        if (beginTime > 0L) {
            elapsedTime = TimeUtil.getServerTime() - beginTime;
            try {
                count = WhiteListHandler.getExceptionCount(beginTime, groupId);
            }
            catch (Throwable ex) {
                LoggerUtilities.logException((Throwable)ex);
                count = 0L;
            }
        }
        ret[0] = count;
        ret[1] = elapsedTime;
        return ret;
    }

    public ArrayList<LockdownExceptionObject> getExceptionList(String[] groupId) {
        long beginTime = this.getLastTestModifiedTime();
        if (beginTime < 1L) {
            return null;
        }
        ArrayList<LockdownExceptionObject> list = null;
        try {
            list = WhiteListHandler.getExceptionList(beginTime, groupId);
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return list;
    }

    public boolean isTestMode(AppliedImage image) {
        if (image == null) {
            return true;
        }
        Integer mode = image.getOptMode();
        if (mode == null) {
            mode = image.getDefMode();
        }
        return mode.equals(AppliedImage.TEST_FOR_REMOVE);
    }

    public ArrayList<ConfigObject> getAppliedImages() {
        if (!this.isValid()) {
            return null;
        }
        LockdownSet set = this.lockdown.getOptLockdownSet();
        if (set == null) {
            return null;
        }
        AppliedImageArray array = set.getOptAppliedImageArray();
        if (array == null || array.getAppliedImageCount() < 1) {
            return null;
        }
        ArrayList<ConfigObject> list = new ArrayList<ConfigObject>(array.getAppliedImageCount());
        for (int i = 0; i < array.getAppliedImageCount(); ++i) {
            AppliedImage image = array.getAppliedImage(i);
            list.add((ConfigObject)image);
        }
        return list;
    }

    public ArrayList<LockdownFileListObject> getWhiteList() {
        ArrayList<ConfigObject> list = this.getAppliedImages();
        if (list == null || list.size() < 1) {
            return null;
        }
        ArrayList<LockdownFileListObject> whitelist = new ArrayList<LockdownFileListObject>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            AppliedImage image = (AppliedImage)list.get(i);
            try {
                boolean test = this.isTestMode(image);
                ComputerImage ci = DataobjectManager.getInstance().getComputerImage(image.getObjReference().getTargetId());
                if (ci == null) continue;
                whitelist.add(new LockdownFileListObject(ci, test));
                continue;
            }
            catch (Throwable ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return whitelist;
    }

    public AppliedImage getWhiteListById(String whitelistId) {
        ArrayList<ConfigObject> list = this.getAppliedImages();
        if (list == null || list.size() < 1) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            AppliedImage image = (AppliedImage)list.get(i);
            if (!image.getObjReference().getTargetId().equals(whitelistId)) continue;
            return image;
        }
        return null;
    }

    public String[] getFingerprintListIds() {
        ArrayList<ConfigObject> list;
        String[] imageIds = null;
        if (this.isEnabled() && (list = this.getAppliedImages()) != null && list.size() > 0) {
            imageIds = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AppliedImage image = (AppliedImage)list.get(i);
                imageIds[i] = image.getObjReference().getTargetId();
            }
        }
        return imageIds;
    }

    public boolean hasWhiteListForTest() {
        ArrayList<ConfigObject> list = this.getAppliedImages();
        if (list == null || list.size() < 1) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            AppliedImage image = (AppliedImage)list.get(i);
            if (!this.isTestMode(image)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWhiteListForNoTest() {
        ArrayList<ConfigObject> list = this.getAppliedImages();
        if (list == null || list.size() < 1) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            AppliedImage image = (AppliedImage)list.get(i);
            if (this.isTestMode(image)) continue;
            return true;
        }
        return false;
    }

    public boolean isTestMode(AdditionalAllowedFile file) {
        if (file == null) {
            return true;
        }
        Integer mode = file.getOptMode();
        if (mode == null) {
            mode = file.getDefMode();
        }
        return mode.equals(AdditionalAllowedFile.TEST_FOR_REMOVE);
    }

    public ArrayList<AdditionalAllowedFile> getAdditionalAllowedFiles() {
        if (!this.isValid()) {
            return null;
        }
        LockdownSet set = this.lockdown.getOptLockdownSet();
        if (set == null) {
            return null;
        }
        AdditionalAllowedFileArray array = set.getOptAdditionalAllowedFileArray();
        if (array == null || array.getAdditionalAllowedFileCount() < 1) {
            return null;
        }
        ArrayList<AdditionalAllowedFile> list = new ArrayList<AdditionalAllowedFile>(array.getAdditionalAllowedFileCount());
        for (int i = 0; i < array.getAdditionalAllowedFileCount(); ++i) {
            AdditionalAllowedFile file = array.getAdditionalAllowedFile(i);
            list.add(file);
        }
        return list;
    }

    public boolean hasExtraFilesForTest() {
        ArrayList<AdditionalAllowedFile> list = this.getAdditionalAllowedFiles();
        if (list == null || list.size() < 1) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            AdditionalAllowedFile file = list.get(i);
            if (!this.isTestMode(file)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExtraFilesForNoTest() {
        ArrayList<AdditionalAllowedFile> list = this.getAdditionalAllowedFiles();
        if (list == null || list.size() < 1) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            AdditionalAllowedFile file = list.get(i);
            if (this.isTestMode(file)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<LockdownFileListObject> getExtraFiles() {
        ArrayList<AdditionalAllowedFile> list = this.getAdditionalAllowedFiles();
        if (list == null || list.size() < 1) {
            return null;
        }
        ArrayList<LockdownFileListObject> extraFiles = new ArrayList<LockdownFileListObject>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            AdditionalAllowedFile file = list.get(i);
            try {
                boolean test = this.isTestMode(file);
                extraFiles.add(new LockdownFileListObject(file.getOpFileNameMatchEntity(), test));
                continue;
            }
            catch (Throwable ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return extraFiles;
    }

    public boolean hasDeletedItem(List<LockdownFileListObject> whitelist, List<LockdownFileListObject> extraFiles) {
        ArrayList<AdditionalAllowedFile> listCurrent1;
        boolean found;
        if (!this.isValid()) {
            return false;
        }
        ArrayList listCurrent = (ArrayList)Cast.cast(this.getAppliedImages());
        if (listCurrent != null && listCurrent.size() > 0) {
            if (whitelist == null || whitelist.size() < 1) {
                System.out.println("ComputerLockdownProtectionObject>> hasDeletedItem: the whitelist got empty");
                return true;
            }
            for (AppliedImage image : listCurrent) {
                found = false;
                for (LockdownFileListObject o : whitelist) {
                    if (!o.getId().equals(image.getObjReference().getTargetId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println("ComputerLockdownProtectionObject>> hasDeletedItem: delete whitelist=" + image.getObjReference().getTargetId());
                return true;
            }
        }
        if ((listCurrent1 = this.getAdditionalAllowedFiles()) != null && listCurrent1.size() > 0) {
            if (extraFiles == null || extraFiles.size() < 1) {
                System.out.println("ComputerLockdownProtectionObject>> hasDeletedItem: the extraFiles got empty");
                return true;
            }
            for (int i = 0; i < listCurrent1.size(); ++i) {
                found = false;
                AdditionalAllowedFile file = listCurrent1.get(i);
                if (file.getOpFileNameMatchEntity() == null) continue;
                for (LockdownFileListObject o : extraFiles) {
                    if (!o.getName().equals(file.getOpFileNameMatchEntity().getKeyString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println("ComputerLockdownProtectionObject>> hasDeletedItem: delete extrafile=" + file.getOpFileNameMatchEntity().getKeyString());
                return true;
            }
        }
        return false;
    }

    public List<List<ConfigObject>> getDeletedItems(List<LockdownFileListObject> whitelist, List<LockdownFileListObject> extraFiles) {
        ArrayList<AdditionalAllowedFile> listCurrent1;
        ArrayList<List<ConfigObject>> ret = new ArrayList<List<ConfigObject>>(2);
        if (!this.isValid()) {
            return ret;
        }
        ArrayList listCurrent = (ArrayList)Cast.cast(this.getAppliedImages());
        if (listCurrent != null && listCurrent.size() > 0) {
            ret.add(0, new ArrayList(listCurrent));
            if (whitelist != null && whitelist.size() >= 1) {
                block0: for (AppliedImage image : listCurrent) {
                    for (LockdownFileListObject o : whitelist) {
                        if (!o.getId().equals(image.getObjReference().getTargetId())) continue;
                        ((List)ret.get(0)).remove(image);
                        continue block0;
                    }
                }
            }
        } else {
            ret.add(0, null);
        }
        if ((listCurrent1 = this.getAdditionalAllowedFiles()) != null && listCurrent1.size() > 0) {
            ArrayList<AdditionalAllowedFile> lst = new ArrayList<AdditionalAllowedFile>(listCurrent1);
            ret.add(1, lst);
            if (extraFiles != null && extraFiles.size() >= 1) {
                block2: for (AdditionalAllowedFile file : listCurrent1) {
                    if (file.getOpFileNameMatchEntity() == null) continue;
                    for (LockdownFileListObject o : extraFiles) {
                        if (!o.getName().equals(file.getOpFileNameMatchEntity().getKeyString())) continue;
                        ((List)ret.get(1)).remove(file);
                        continue block2;
                    }
                }
            }
        } else {
            ret.add(1, null);
        }
        return ret;
    }

    public boolean hasChangeItem(List<LockdownFileListObject> whitelist, List<LockdownFileListObject> extraFiles) {
        ArrayList<AdditionalAllowedFile> listCurrentAgain;
        if (!this.isValid()) {
            return true;
        }
        ArrayList<ConfigObject> listCurrent = this.getAppliedImages();
        if (listCurrent != null && listCurrent.size() > 0) {
            if (whitelist == null || whitelist.size() < 1) {
                System.out.println("ComputerLockdownProtectionObject>> hasChangeItem: the whitelist got empty");
                return true;
            }
            for (int i = 0; i < listCurrent.size(); ++i) {
                AppliedImage image = (AppliedImage)listCurrent.get(i);
                LockdownFileListObject found = null;
                for (int ii = 0; ii < whitelist.size(); ++ii) {
                    LockdownFileListObject o = whitelist.get(ii);
                    if (!o.getId().equals(image.getObjReference().getTargetId())) continue;
                    found = o;
                    break;
                }
                if (found == null) {
                    System.out.println("ComputerLockdownProtectionObject>> hasChangeItem: delete whitelist=" + image.getObjReference().getTargetId());
                    return true;
                }
                if (this.isTestMode(image) == found.isTest()) continue;
                System.out.println("ComputerLockdownProtectionObject>> hasChangeItem: test mode changed. whitelist=" + image.getObjReference().getTargetId());
                return true;
            }
        }
        if ((listCurrentAgain = this.getAdditionalAllowedFiles()) != null && listCurrentAgain.size() > 0) {
            if (extraFiles == null || extraFiles.size() < 1) {
                System.out.println("ComputerLockdownProtectionObject>> hasChangeItem: the extraFiles got empty");
                return true;
            }
            for (int i = 0; i < listCurrentAgain.size(); ++i) {
                AdditionalAllowedFile file = listCurrentAgain.get(i);
                if (file.getOpFileNameMatchEntity() == null) continue;
                LockdownFileListObject found = null;
                for (int ii = 0; ii < extraFiles.size(); ++ii) {
                    LockdownFileListObject o = extraFiles.get(ii);
                    if (!o.getName().equals(file.getOpFileNameMatchEntity().getKeyString())) continue;
                    found = o;
                    break;
                }
                if (found == null) {
                    System.out.println("ComputerLockdownProtectionObject>> hasChangeItem: delete extrafile=" + file.getOpFileNameMatchEntity().getKeyString());
                    return true;
                }
                if (this.isTestMode(file) == found.isTest()) continue;
                System.out.println("ComputerLockdownProtectionObject>> hasChangeItem: test mode changed. extrafile=" + file.getOpFileNameMatchEntity().getKeyString());
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasNewItem(List<LockdownFileListObject> whitelist, List<LockdownFileListObject> extraFiles, int check_type) {
        LockdownFileListObject o;
        int i;
        if (!this.isValid()) {
            return true;
        }
        if (whitelist != null) {
            block8: for (i = 0; i < whitelist.size(); ++i) {
                o = whitelist.get(i);
                if (this.hasWhiteList(o)) continue;
                switch (check_type) {
                    case 1: {
                        if (o.isTest()) break;
                        continue block8;
                    }
                    case 2: {
                        if (o.isTest()) continue block8;
                    }
                }
                System.out.println("ComputerLockdownProtectionObject>> hasNewItem: New whitelist=" + o.getName());
                return true;
            }
        }
        if (extraFiles != null) {
            block9: for (i = 0; i < extraFiles.size(); ++i) {
                o = extraFiles.get(i);
                if (this.hasExtraFile(o)) continue;
                switch (check_type) {
                    case 1: {
                        if (o.isTest()) break;
                        continue block9;
                    }
                    case 2: {
                        if (o.isTest()) continue block9;
                    }
                }
                System.out.println("ComputerLockdownProtectionObject>> hasNewItem: New extrafile=" + o.getName());
                return true;
            }
        }
        return false;
    }

    private boolean hasWhiteList(LockdownFileListObject o) {
        ArrayList<ConfigObject> list = this.getAppliedImages();
        if (list == null || list.size() < 1) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            AppliedImage image = (AppliedImage)list.get(i);
            if (!o.getId().equals(image.getObjReference().getTargetId())) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtraFile(LockdownFileListObject o) {
        ArrayList<AdditionalAllowedFile> list = this.getAdditionalAllowedFiles();
        if (list == null || list.size() < 1) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            AdditionalAllowedFile file = list.get(i);
            if (file.getOpFileNameMatchEntity() == null || !o.getName().equals(file.getOpFileNameMatchEntity().getKeyString())) continue;
            return true;
        }
        return false;
    }

    public void setFileList(List<LockdownFileListObject> whitelist, List<LockdownFileListObject> extraFiles) {
        LockdownFileListObject o;
        int i;
        if (!this.isValid()) {
            return;
        }
        LockdownSet set = new LockdownSet();
        this.lockdown.setOptLockdownSet(set);
        if (whitelist != null) {
            for (i = 0; i < whitelist.size(); ++i) {
                o = whitelist.get(i);
                this.addWhiteList(o, set);
            }
        }
        if (extraFiles != null) {
            for (i = 0; i < extraFiles.size(); ++i) {
                o = extraFiles.get(i);
                this.addExtraFile(o, set);
            }
        }
    }

    public boolean isShowLockdown() {
        LicenseObject licenseObj = LicenseObject.getInstance();
        return licenseObj.isOSPretectionPolicy() || !this.isDisabled();
    }

    public boolean isModeChanged(int mode) {
        switch (mode) {
            case 0: {
                if (this.isPolicyDisabled()) {
                    return false;
                }
            }
            case 2: {
                if (this.isPolicyTesting()) {
                    return false;
                }
            }
            case 1: {
                if (!this.isPolicyActivated()) break;
                return false;
            }
        }
        return true;
    }
}

