/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AppUpload;
import com.sygate.scm.common.configobject.schema.Communication;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.Utility;

public class CommunicationObject
extends AbstractUIObject {
    public static final int PUSH_MODE = 0;
    public static final int PULL_MODE = 1;
    public static final int MINUTES = 0;
    public static final int HOURS = 1;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int MAX_HOURS = 48;
    public static final int MIN_HOURS = 1;
    public static final int MAX_MINUTES = 60;
    public static final int MIN_MINUTES = 1;
    public static final int DEF_MINUTES = 5;
    public static final int DEF_HOURS = 1;
    public static final int DEFAULT_STEP_HEARTBEAT = 1;
    public static final int DEFAULT_STEP_RANDOMIZATION = 1;
    Communication _communication;

    public CommunicationObject() {
    }

    public CommunicationObject(Communication communication) {
        this._communication = communication;
    }

    public CommunicationObject getClone() throws ConsoleException {
        try {
            Communication newCommunication = (Communication)PolicyHandler.getCopyOfObj((ConfigObject)this._communication);
            CommunicationObject newObj = new CommunicationObject(newCommunication);
            return newObj;
        }
        catch (ConsoleException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public boolean isConnectToServer() {
        if (this._communication != null && this._communication.getOptEnable() != null) {
            return this._communication.getOptEnable();
        }
        return true;
    }

    public boolean setConnectToServer(boolean connect) {
        boolean oldValue = this.isConnectToServer();
        if (oldValue == connect) {
            return false;
        }
        this._communication.setOptEnable(Boolean.valueOf(connect));
        return true;
    }

    public int getMode() {
        Integer mode = this._communication.getMode();
        if (mode.equals(Communication.PULL)) {
            return 1;
        }
        return 0;
    }

    public boolean setMode(int newMode) {
        int oldValue = this.getMode();
        if (oldValue == newMode) {
            return false;
        }
        Integer newIntMode = newMode == 1 ? Communication.PULL : Communication.PUSH;
        this._communication.setMode(newIntMode);
        return true;
    }

    public long getHeartbeat() {
        if (this._communication.getOptPollModeHeartbeatFreq() != null) {
            return this._communication.getOptPollModeHeartbeatFreq();
        }
        return 300L;
    }

    public boolean setHeartbeat(long newValue) {
        long oldValue = this.getHeartbeat();
        if (oldValue == newValue) {
            return false;
        }
        this._communication.setOptPollModeHeartbeatFreq(Long.valueOf(newValue));
        return true;
    }

    public Communication getCommunication() {
        return this._communication;
    }

    public boolean getAppUploadFlag() {
        AppUpload upload = this._communication.getOptAppUpload();
        if (upload != null) {
            if (upload.getOptEnable() != null) {
                return upload.getOptEnable();
            }
            return upload.getDefEnable();
        }
        return false;
    }

    public boolean setAppUploadFlag(boolean newValue) {
        boolean oldValue = this.getAppUploadFlag();
        if (oldValue != newValue) {
            AppUpload upload = this._communication.getOptAppUpload();
            if (upload == null) {
                upload = new AppUpload();
                this._communication.setOptAppUpload(upload);
            }
            upload.setOptEnable(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public long getLogUploadHeartbeat() {
        if (this._communication.getOptUploadLogHeartbeatFreq() != null) {
            return this._communication.getOptUploadLogHeartbeatFreq();
        }
        return 300L;
    }

    public boolean setLogUploadHeartbeat(long newValue) {
        long oldValue = this.getLogUploadHeartbeat();
        if (oldValue == newValue) {
            return false;
        }
        this._communication.setOptUploadLogHeartbeatFreq(Long.valueOf(newValue));
        return true;
    }

    public long getOperationStateUploadHeartbeat() {
        if (this._communication.getOptUploadOpStateHeartbeatFreq() != null) {
            return this._communication.getOptUploadOpStateHeartbeatFreq();
        }
        return 300L;
    }

    public boolean setOperationStateUploadHeartbeat(long newValue) {
        long oldValue = this.getOperationStateUploadHeartbeat();
        if (oldValue == newValue) {
            return false;
        }
        this._communication.setOptUploadOpStateHeartbeatFreq(Long.valueOf(newValue));
        return true;
    }

    public long getCommandStateUploadHeartbeat() {
        if (this._communication.getOptUploadCmdStateHeartbeatFreq() != null) {
            return this._communication.getOptUploadCmdStateHeartbeatFreq();
        }
        return 300L;
    }

    public boolean setCommandStateUploadHeartbeat(long newValue) {
        long oldValue = this.getCommandStateUploadHeartbeat();
        if (oldValue == newValue) {
            return false;
        }
        this._communication.setOptUploadCmdStateHeartbeatFreq(Long.valueOf(newValue));
        return true;
    }

    public ServerListObject getServerList() throws ConsoleException {
        ObjReference objRef = this._communication.getObjReference();
        String targetType = objRef.getTargetType();
        if (!targetType.equals("DefaultServerList")) {
            SemServerList serverList = DataobjectManager.getInstance().getSemServerList(objRef.getTargetId());
            return new ServerListObject(serverList);
        }
        SemServerList serverList = GUIManager.getDefaultServerList(objRef.getTargetId());
        return new ServerListObject(serverList, true);
    }

    public String getServerListId() throws ConsoleException {
        return this._communication.getObjReference().getTargetId();
    }

    public boolean setServerList(ServerListObject selectedOne) throws ConsoleException {
        ServerListObject oldObj = this.getServerList();
        if (selectedOne != null && oldObj != null && oldObj.getId().equals(selectedOne.getId())) {
            return false;
        }
        if (selectedOne == null) {
            return false;
        }
        if (selectedOne.isDefaultList()) {
            ObjReference refer = this._communication.getObjReference();
            refer.setName("DefaultServerListLink");
            refer.setTargetType("DefaultServerList");
            refer.setTargetId(selectedOne.getId());
            return true;
        }
        ObjReference objRef = this._communication.getObjReference();
        objRef.setTargetType("SemServerList");
        objRef.setName("ServerListLink");
        objRef.setTargetId(selectedOne.getId());
        return true;
    }

    public boolean getDownloadProfile() {
        if (this._communication != null) {
            Boolean downloadProfile = this._communication.getOptDownloadProfile();
            if (downloadProfile == null) {
                downloadProfile = this._communication.getDefDownloadProfile();
            }
            return downloadProfile;
        }
        return true;
    }

    public boolean setDownloadProfile(boolean newValue) {
        boolean oldValue = this.getDownloadProfile();
        if (oldValue == newValue) {
            return false;
        }
        this._communication.setOptDownloadProfile(Boolean.valueOf(newValue));
        return true;
    }

    public boolean setRandomizationEnabled(boolean newValue) {
        boolean oldValue = this.getRandomizationEnabled();
        if (oldValue == newValue) {
            return false;
        }
        if (this._communication != null) {
            this._communication.setOptRandomizationEnabled(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getRandomizationEnabled() {
        if (this._communication != null) {
            Boolean randomizationEnabled = this._communication.getOptRandomizationEnabled();
            if (randomizationEnabled == null) {
                randomizationEnabled = this._communication.getDefRandomizationEnabled();
            }
            return randomizationEnabled;
        }
        return false;
    }

    public boolean setAllowClientUploadCriticalEventImmediately(boolean newValue) {
        boolean oldValue = this.getAllowClientUploadCriticalEventImmediately();
        if (oldValue == newValue) {
            return false;
        }
        if (this._communication != null) {
            this._communication.setOptAllowClientUploadCriticalEventImmediately(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getAllowClientUploadCriticalEventImmediately() {
        if (this._communication != null) {
            boolean allowClientUploadCriticalEventImmediately = Utility.getBooleanValue((Boolean)this._communication.getOptAllowClientUploadCriticalEventImmediately(), (Boolean)this._communication.getDefAllowClientUploadCriticalEventImmediately());
            return allowClientUploadCriticalEventImmediately;
        }
        return false;
    }

    public boolean setRememberCurrentGroup(boolean newValue) {
        boolean oldValue = this.getRememberCurrentGroup();
        if (oldValue == newValue) {
            return false;
        }
        if (this._communication != null) {
            this._communication.setOptRememberCurrentGroup(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getRememberCurrentGroup() {
        if (this._communication != null) {
            boolean rememberCurrentGroup = Utility.getBooleanValue((Boolean)this._communication.getOptRememberCurrentGroup(), (Boolean)this._communication.getDefRememberCurrentGroup());
            return rememberCurrentGroup;
        }
        return false;
    }

    public boolean setRememberCurrentPolicyMode(boolean newValue) {
        boolean oldValue = this.getRememberCurrentPolicyMode();
        if (oldValue == newValue) {
            return false;
        }
        if (this._communication != null) {
            this._communication.setOptRememberCurrentPolicyMode(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getRememberCurrentPolicyMode() {
        if (this._communication != null) {
            boolean rememberCurrentPolicyMode = Utility.getBooleanValue((Boolean)this._communication.getOptRememberCurrentPolicyMode(), (Boolean)this._communication.getDefRememberCurrentPolicyMode());
            return rememberCurrentPolicyMode;
        }
        return false;
    }

    public boolean setRandomizationRange(int newValue) {
        int oldValue = this.getRandomizationRange();
        if (oldValue == newValue) {
            return false;
        }
        if (this.getRandomizationFrequency() == 0) {
            if (newValue > 3600) {
                newValue = 3600;
            }
            if (newValue < 60) {
                newValue = 60;
            }
        } else {
            if (newValue > 172800) {
                newValue = 172800;
            }
            if (newValue < 3600) {
                newValue = 3600;
            }
        }
        this._communication.setOptRandomizationRange(Integer.valueOf(newValue));
        return true;
    }

    public int getRandomizationRange() {
        if (this._communication != null && this._communication.getOptRandomizationRange() != null) {
            return this._communication.getOptRandomizationRange();
        }
        if (this.getRandomizationFrequency() == 0) {
            return 300;
        }
        return 3600;
    }

    public int getRandomizationFrequency() {
        if (this._communication != null) {
            Integer randomFreq = this._communication.getOptRandomizationFrequency();
            if (randomFreq == null) {
                randomFreq = this._communication.getDefRandomizationFrequency();
            }
            return randomFreq;
        }
        return 0;
    }

    public boolean setRandomizationFrequency(int newValue) {
        int oldValue = this.getRandomizationFrequency();
        if (oldValue == newValue) {
            return false;
        }
        if (newValue == 0) {
            this._communication.setOptRandomizationRange(Integer.valueOf(300));
        } else {
            this._communication.setOptRandomizationRange(Integer.valueOf(3600));
        }
        this._communication.setOptRandomizationFrequency(Integer.valueOf(newValue));
        return true;
    }
}

