/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemComputerHandler;
import com.sygate.scm.console.logicobject.ClientTechnology;
import com.sygate.scm.console.logicobject.ClientTechnologyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.util.Date;

public class ClientTechnologyUserObject
extends UserObject
implements ClientTechnology {
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    public static final int COMPUTER_NAME = 0;
    public static final int HEALTH_STATUS = 1;
    public static final int LOGON_NAME = 2;
    public static final int IP_ADDRESS = 3;
    public static final int LAST_SCAN = 4;
    public static final int AV_STATUS = 5;
    public static final int FW_STATUS = 6;
    public static final int PTP_STATUS = 7;
    public static final int DA_STATUS = 8;
    public static final int PEP_STATUS = 9;
    public static final int CIDS_STATUS = 10;
    public static final int CIDS_IE_STATUS = 11;
    public static final int CIDS_FF_STATUS = 12;
    public static final int TAMPER_PROTECTION_STATUS = 13;
    public static final int VIRUS_DEF = 14;
    public static final int IPS_DEF = 15;
    public static final int MR_CLEAN_DEF = 16;
    public static final int PTP_DEF = 17;
    private static final int ADVML_AV_DEF = 18;
    private static final int EDR_DEF = 19;
    private static final int WTR_DEF = 20;
    private static final int COL_TDAD_DEF = 21;
    public static final int MAJORVERSION = 35;
    public static final int MINORVERSION = 36;
    public static final int ELAM_STATUS = 38;
    public static final int LB_STATUS = 46;
    public static final int NTR_STATUS = 47;
    public static final int TDAD_STATUS = 49;
    public static final int IPS_OOB_STATUS = 50;
    public static final int URL_ON_OFF_STATUS = 52;
    public static final int CIDS_CHROME_STATUS = 53;
    public static final int AC_STATUS = 54;
    public static final int DC_STATUS = 55;
    public static final int NOT_INSTALLED_STATUS = 2;
    private String groupName = "";
    private String ipAddress = "0.0.0.0";
    private String lastScan;
    private int avStatus = 1;
    private int fwStatus = 1;
    private String rebootReason = "";
    private int ptpStatus = 1;
    private int daStatus = 1;
    private int cidsStatus = 1;
    private int cidiIEStatus = 1;
    private int cidsFFStatus = 1;
    private int cidsChromeStatus = 1;
    private int cidsSilentMode = 0;
    private int tpStatus = 1;
    private int elamStatus = 1;
    private int pepStatus = 1;
    private int lbStatus = 1;
    private int ntrStatus = 0;
    private int tdadStatus = 0;
    private int ipsOobStatus = 0;
    private int ipsServerSigStatus = 0;
    private int urlOnOffStatus = 0;
    private int acStatus = 127;
    private int dcStatus = 127;
    private String ipsDef = null;
    private String mrCleanDef = null;
    private String virusDef = null;
    private String bashDef = null;
    private String syKnCalDef = null;
    private String syKnWlDef = null;
    private String advmlAVDef = null;
    private String edrDef = null;
    private String wtrDef = null;
    private String tdadDef = null;

    public ClientTechnologyUserObject() {
        this.client = new SemClient();
        this.agent = new SemAgent();
    }

    public ClientTechnologyUserObject(SemClient client) {
        super(client);
        this.agent = new SemAgent();
    }

    @Override
    public SemAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setObject(SemTableRow row, String groupId, int peAlert, int isInfected, int onlineStatus) {
        this.getAgent().setAgentId(row.getSemTableValue(34).getValue());
        this.setComputerName(row.getSemTableValue(0).getValue());
        this.setComputerIp(row.getSemTableValue(3).getValue());
        this.setUserName(row.getSemTableValue(2).getValue());
        this.setLastScanTime(row.getSemTableValue(4).getValue());
        this.setAVStatus(Utility.parseInt((String)row.getSemTableValue(5).getValue(), (int)-1));
        this.setFirewallStatus(Utility.parseInt((String)row.getSemTableValue(6).getValue(), (int)-1));
        this.setNtrStatus(Utility.parseInt((String)row.getSemTableValue(47).getValue(), (int)-1));
        this.setVirusDefinition(row.getSemTableValue(14).getValue());
        this.setPtpStatus(Utility.parseInt((String)row.getSemTableValue(7).getValue(), (int)-1));
        this.setDaStatus(Utility.parseInt((String)row.getSemTableValue(8).getValue(), (int)-1));
        this.setCidsStatus(Utility.parseInt((String)row.getSemTableValue(10).getValue(), (int)-1));
        this.setCidiIEStatus(Utility.parseInt((String)row.getSemTableValue(11).getValue(), (int)-1));
        this.setCidsFFStatus(Utility.parseInt((String)row.getSemTableValue(12).getValue(), (int)-1));
        this.setCidsChromeStatus(Utility.parseInt((String)row.getSemTableValue(53).getValue(), (int)-1));
        this.setCidsSilentMode(Utility.parseInt((String)row.getSemTableValue(37).getValue(), (int)-1));
        this.setTpStatus(Utility.parseInt((String)row.getSemTableValue(13).getValue(), (int)-1));
        this.setElamStatus(Utility.parseInt((String)row.getSemTableValue(38).getValue(), (int)-1));
        this.setPepStatus(Utility.parseInt((String)row.getSemTableValue(9).getValue(), (int)-1));
        this.setLbStatus(Utility.parseInt((String)row.getSemTableValue(46).getValue(), (int)-1));
        this.setTdadStatus(Utility.parseInt((String)row.getSemTableValue(49).getValue(), (int)-1));
        this.setIpsOobStatus(Utility.parseInt((String)row.getSemTableValue(50).getValue(), (int)-1));
        this.setIpsServerSigStatus(Utility.parseInt((String)row.getSemTableValue(51).getValue(), (int)-1));
        this.setUrlOnOffStatus(Utility.parseInt((String)row.getSemTableValue(52).getValue(), (int)-1));
        this.setAcStatus(Utility.parseInt((String)row.getSemTableValue(54).getValue(), (int)-1));
        this.setDcStatus(Utility.parseInt((String)row.getSemTableValue(55).getValue(), (int)-1));
        this.setVirusDefinition(row.getSemTableValue(14).getValue());
        this.setGroupId(groupId);
        this.setComputerDomainName(row.getSemTableValue(20).getValue());
        this.setUserDomainName(row.getSemTableValue(21).getValue());
        this.setAgentDomainId(Manager.getCurrentDomainId());
        this.client.setOptComputerId(row.getSemTableValue(15).getValue());
        this.client.setClientId(row.getSemTableValue(16).getValue());
        this.client.setOptGroupId(groupId);
        this.getAgent().setTimeStamp(Long.valueOf(row.getSemTableValue(17).getValue()));
        this.client.setUSN(Long.valueOf(row.getSemTableValue(18).getValue()));
        this.client.setDeleted(Integer.valueOf(row.getSemTableValue(19).getValue()));
        this.setOnlineStatusEx(onlineStatus);
        this.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(29).getValue(), (int)0));
        this.setRebootReason(SemComputerHandler.getFormattedRebootReason(row.getSemTableValue(28).getValue()));
        this.setDeployMessage(row.getSemTableValue(29).getValue());
        this.setDeployTargetVersion(row.getSemTableValue(30).getValue());
        this.setDeployRunningVersion(row.getSemTableValue(31).getValue());
        this.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(32).getValue(), (long)0L));
        this.setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(35).getValue())));
        this.setAgentVersionMinor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(36).getValue())));
        this.setPowerEraserPendingAlertCount(peAlert);
        this.setInfected(isInfected);
        this.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(45).getValue())));
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 1: {
                this.setOnlineStatusEx((Integer)value);
                break;
            }
            case 2: {
                this.setLoginName((String)value);
                break;
            }
            case 3: {
                this.setComputerIp((String)value);
                break;
            }
            case 4: {
                this.setLastScanTime((String)value);
                break;
            }
            case 5: {
                this.setAVStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 6: {
                this.setFirewallStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 7: {
                this.setPtpStatus((Integer)value);
                break;
            }
            case 9: {
                this.setPepStatus((Integer)value);
                break;
            }
            case 8: {
                this.setDaStatus((Integer)value);
                break;
            }
            case 10: {
                this.setCidsStatus((Integer)value);
                break;
            }
            case 11: {
                this.setCidiIEStatus((Integer)value);
                break;
            }
            case 12: {
                this.setCidsFFStatus((Integer)value);
                break;
            }
            case 13: {
                this.setCidsChromeStatus((Integer)value);
                break;
            }
            case 14: {
                this.setTpStatus((Integer)value);
                break;
            }
            case 23: {
                this.setElamStatus((Integer)value);
                break;
            }
            case 24: {
                this.setLbStatus((Integer)value);
                break;
            }
            case 15: {
                this.setVirusDefinition((String)value);
                break;
            }
            case 17: {
                this.setMrCleanDef((String)value);
                break;
            }
            case 18: {
                break;
            }
            case 16: {
                this.setIpsDef((String)value);
                break;
            }
            case 19: {
                this.setAdvmlAVDef((String)value);
                break;
            }
            case 20: {
                this.setEDRDef((String)value);
                break;
            }
            case 21: {
                this.setWtrDef((String)value);
                break;
            }
            case 22: {
                this.setTdadDef((String)value);
                break;
            }
            case 35: {
                this.setAgentVersionMajor((Integer)value);
                break;
            }
            case 25: {
                this.setNtrStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 26: {
                this.setTdadStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 27: {
                this.setIpsOobStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 28: {
                this.setUrlOnOffStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 29: {
                this.setAcStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 30: {
                this.setDcStatus(Integer.parseInt(value.toString()));
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        Object ret = null;
        ret = LIC_OBJ.isSEPSBProduct() ? this.getSEPSBValueAt(index) : this.getSEPEValueAt(index);
        return ret;
    }

    public Object getSEPEValueAt(int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getComputerIp();
            }
            case 4: {
                return this.getLastScanTime();
            }
            case 5: {
                return this.getAVStatus();
            }
            case 6: {
                return this.getFirewallStatus();
            }
            case 8: {
                StringBuffer opStateDesc = new StringBuffer(ClientTechnologyObject.getOPStatDesc(this.getDaStatus()));
                String mode = this.getDownloadAdvisorMode();
                if (!mode.isEmpty()) {
                    opStateDesc.append(" - ");
                    opStateDesc.append(mode);
                }
                return opStateDesc.toString();
            }
            case 7: {
                return ClientTechnologyObject.getOPStatDesc(this.getPtpStatus());
            }
            case 9: {
                return ClientTechnologyObject.getOPStatDesc(this.getPepStatus());
            }
            case 10: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsStatus());
            }
            case 11: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidiIEStatus());
            }
            case 12: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsFFStatus());
            }
            case 13: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsChromeStatus());
            }
            case 14: {
                return ClientTechnologyObject.getOPStatDesc(this.getTpStatus());
            }
            case 23: {
                return ClientTechnologyObject.getOPStatDesc(this.getElamStatus());
            }
            case 24: {
                return ClientTechnologyObject.getLbStatDesc(this.getLbStatus());
            }
            case 26: {
                return ClientTechnologyObject.getOPStatDesc(this.getTdadStatus());
            }
            case 27: {
                return ClientTechnologyObject.getOPStatDesc(this.getIpsOobStatus());
            }
            case 15: {
                return this.getVirusDefinition();
            }
            case 17: {
                return this.getMrCleanDef();
            }
            case 18: {
                return this.getPtpDef();
            }
            case 16: {
                return this.getIpsDef();
            }
            case 19: {
                return this.getAdvmlAVDef();
            }
            case 20: {
                return this.getEDRDef();
            }
            case 21: {
                return this.getWtrDef();
            }
            case 22: {
                return this.getTdadDef();
            }
            case 35: {
                return this.getAgentVersionMajor();
            }
            case 25: {
                return this.getNtrStatus();
            }
            case 28: {
                return ClientTechnologyObject.getOPStatDesc(this.getUrlOnOffStatus());
            }
            case 29: {
                return ClientTechnologyObject.getOPStatDesc(this.getAcStatus());
            }
            case 30: {
                return ClientTechnologyObject.getOPStatDesc(this.getDcStatus());
            }
        }
        return null;
    }

    public Object getSEPSBValueAt(int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getComputerIp();
            }
            case 4: {
                return this.getLastScanTime();
            }
            case 5: {
                return this.getAVStatus();
            }
            case 6: {
                return this.getFirewallStatus();
            }
            case 8: {
                StringBuffer opStateDesc = new StringBuffer(ClientTechnologyObject.getOPStatDesc(this.getDaStatus()));
                String mode = this.getDownloadAdvisorMode();
                if (!mode.isEmpty()) {
                    opStateDesc.append(" - ");
                    opStateDesc.append(mode);
                }
                return opStateDesc.toString();
            }
            case 7: {
                return ClientTechnologyObject.getOPStatDesc(this.getPtpStatus());
            }
            case 9: {
                return ClientTechnologyObject.getOPStatDesc(this.getPepStatus());
            }
            case 10: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsStatus());
            }
            case 11: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidiIEStatus());
            }
            case 12: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsFFStatus());
            }
            case 13: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsChromeStatus());
            }
            case 14: {
                return ClientTechnologyObject.getOPStatDesc(this.getTpStatus());
            }
            case 23: {
                return ClientTechnologyObject.getOPStatDesc(this.getElamStatus());
            }
            case 15: {
                return this.getVirusDefinition();
            }
            case 17: {
                return this.getMrCleanDef();
            }
            case 18: {
                return this.getPtpDef();
            }
            case 16: {
                return this.getIpsDef();
            }
            case 20: {
                return this.getEDRDef();
            }
            case 21: {
                return this.getWtrDef();
            }
            case 22: {
                return this.getTdadDef();
            }
            case 35: {
                return this.getAgentVersionMajor();
            }
            case 25: {
                return this.getNtrStatus();
            }
            case 26: {
                return ClientTechnologyObject.getOPStatDesc(this.getTdadStatus());
            }
            case 27: {
                return ClientTechnologyObject.getOPStatDesc(this.getIpsOobStatus());
            }
            case 28: {
                return ClientTechnologyObject.getOPStatDesc(this.getUrlOnOffStatus());
            }
            case 29: {
                return ClientTechnologyObject.getOPStatDesc(this.getAcStatus());
            }
            case 30: {
                return ClientTechnologyObject.getOPStatDesc(this.getDcStatus());
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.showFinderTable && index == 2) {
            index = 3;
        }
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Date.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
            case 9: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
            case 10: {
                return String.class;
            }
            case 11: {
                return String.class;
            }
            case 12: {
                return String.class;
            }
            case 13: {
                return String.class;
            }
            case 23: {
                return String.class;
            }
            case 15: {
                return String.class;
            }
            case 17: {
                return String.class;
            }
            case 18: {
                return String.class;
            }
            case 16: {
                return String.class;
            }
            case 19: {
                return String.class;
            }
            case 20: {
                return String.class;
            }
            case 21: {
                return String.class;
            }
            case 22: {
                return String.class;
            }
            case 35: {
                return Integer.class;
            }
            case 25: {
                return String.class;
            }
            case 24: {
                return String.class;
            }
            case 26: {
                return String.class;
            }
            case 27: {
                return String.class;
            }
            case 29: {
                return String.class;
            }
            case 30: {
                return String.class;
            }
        }
        return null;
    }

    public void setComputerIp(String value) {
        this.ipAddress = value;
    }

    public String getComputerIp() {
        return this.ipAddress;
    }

    public void setLastScanTime(String value) {
        String time = "";
        try {
            long number = Long.parseLong(value);
            if (number >= 60000L) {
                Date d = new Date(number);
                DateFormat df = DateFormat.getDateTimeInstance(1, 3);
                df.setTimeZone(Utility.getLocalTimeZone());
                time = df.format(d);
            } else {
                time = MSGRES.getString("ClientTechnologyObject.notScanned");
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.lastScan = time;
    }

    public void setAgentDomainId(String value) {
        this.agent.setOptDomainId(value);
    }

    public void setAgentGroupId(String value) {
        this.agent.setOptGroupId(value);
    }

    public void setAgentGroupName(String value) {
        this.groupName = value;
    }

    public void setAVStatus(int i) {
        this.avStatus = i;
    }

    public void setFirewallStatus(int n) {
        this.fwStatus = n;
    }

    public void setNtrStatus(int status) {
        this.ntrStatus = status;
    }

    public int getPtpStatus() {
        return this.ptpStatus;
    }

    public int getPepStatus() {
        return this.pepStatus;
    }

    public void setPtpStatus(int ptpStatus) {
        this.ptpStatus = ptpStatus;
    }

    public void setPepStatus(int pepStatus) {
        this.pepStatus = pepStatus;
    }

    public int getDaStatus() {
        return this.daStatus;
    }

    public void setDaStatus(int daStatus) {
        this.daStatus = daStatus;
    }

    public int getCidsStatus() {
        return this.cidsStatus;
    }

    public void setCidsStatus(int cidsStatus) {
        this.cidsStatus = cidsStatus;
    }

    public int getCidiIEStatus() {
        return this.cidiIEStatus;
    }

    public void setCidiIEStatus(int cidiIEStatus) {
        this.cidiIEStatus = cidiIEStatus;
    }

    public int getCidsFFStatus() {
        return this.cidsFFStatus;
    }

    public void setCidsFFStatus(int cidsFFStatus) {
        this.cidsFFStatus = cidsFFStatus;
    }

    public int getCidsChromeStatus() {
        return this.cidsChromeStatus;
    }

    public void setCidsChromeStatus(int cidsChromeStatus) {
        this.cidsChromeStatus = cidsChromeStatus;
    }

    public int getCidsSilentMode() {
        return this.cidsSilentMode;
    }

    public void setCidsSilentMode(int cidsSilentMode) {
        this.cidsSilentMode = cidsSilentMode;
    }

    public int getTpStatus() {
        return this.tpStatus;
    }

    public void setTpStatus(int tpStatus) {
        this.tpStatus = tpStatus;
    }

    public int getElamStatus() {
        return this.elamStatus;
    }

    public int getLbStatus() {
        return this.lbStatus;
    }

    public void setLbStatus(int lbStatus) {
        this.lbStatus = lbStatus;
    }

    public int getTdadStatus() {
        return this.tdadStatus;
    }

    public void setTdadStatus(int tdadStatus) {
        this.tdadStatus = tdadStatus;
    }

    public int getIpsOobStatus() {
        return this.ipsOobStatus;
    }

    public void setIpsOobStatus(int ipsOobStatus) {
        this.ipsOobStatus = ipsOobStatus;
    }

    public int getIpsServerSigStatus() {
        return this.ipsServerSigStatus;
    }

    public void setIpsServerSigStatus(int ipsServerSigStatus) {
        this.ipsServerSigStatus = ipsServerSigStatus;
    }

    public void setElamStatus(int elamStatus) {
        this.elamStatus = elamStatus;
    }

    public void setVirusDefinition(String value) {
        this.virusDef = value;
    }

    public String getAgentDomainId() {
        return this.agent.getOptDomainId();
    }

    public String getAgentGroupId() {
        return this.agent.getOptGroupId();
    }

    public String getLastScanTime() {
        return this.lastScan;
    }

    public String getAVStatus() {
        return ClientTechnologyObject.getOPStatDesc(this.avStatus);
    }

    public String getFirewallStatus() {
        return ClientTechnologyObject.getOPStatDesc(this.fwStatus);
    }

    public String getNtrStatus() {
        return ClientTechnologyObject.getOPStatDesc(this.ntrStatus);
    }

    public void setRebootReason(String reason) {
        this.rebootReason = reason;
    }

    public String getRebootReason() {
        return this.rebootReason;
    }

    public int getUrlOnOffStatus() {
        return this.urlOnOffStatus;
    }

    public void setUrlOnOffStatus(int urlOnOffStatus) {
        this.urlOnOffStatus = urlOnOffStatus;
    }

    public int getAcStatus() {
        return this.acStatus;
    }

    public void setAcStatus(int acStatus) {
        this.acStatus = acStatus;
    }

    public int getDcStatus() {
        return this.dcStatus;
    }

    public void setDcStatus(int dcStatus) {
        this.dcStatus = dcStatus;
    }

    public String getVirusDefinition() {
        if (this.avStatus == 2) {
            return ClientTechnologyUserObject.formatDefDate("");
        }
        return ClientTechnologyUserObject.formatDefDate(this.virusDef);
    }

    public String getAgentGroupName() {
        return this.groupName;
    }

    public String getPtpDef() {
        if (this.ptpStatus == 2) {
            return ClientTechnologyObject.getOPStatDesc(2);
        }
        if (this.isPostAmberClient()) {
            return ClientTechnologyUserObject.formatDefDate(this.bashDef);
        }
        int ret = RevisionObject.compareDbFormatRevision(this.syKnCalDef, this.syKnWlDef);
        if (ret == 1) {
            return ClientTechnologyUserObject.formatDefDate(this.syKnCalDef);
        }
        return ClientTechnologyUserObject.formatDefDate(this.syKnWlDef);
    }

    public String getMrCleanDef() {
        if (this.daStatus == 2) {
            return ClientTechnologyUserObject.formatDefDate("");
        }
        return ClientTechnologyUserObject.formatDefDate(this.mrCleanDef);
    }

    @Override
    public void setMrCleanDef(String mrCleanDef) {
        this.mrCleanDef = mrCleanDef;
    }

    public String getIpsDef() {
        Object suffix = "";
        if (this.getIpsServerSigStatus() == 1 && this.ipsDef != null) {
            suffix = " " + MSGRES.getString("ClientTechnologyObject.IPS_SERVER_SIG_SUFFIX");
        }
        return ClientTechnologyUserObject.formatDefDate(this.ipsDef) + (String)suffix;
    }

    @Override
    public void setIpsDef(String ipsDef) {
        this.ipsDef = ipsDef;
    }

    @Override
    public void setBashDef(String bashDef) {
        this.bashDef = bashDef;
    }

    @Override
    public void setSyKnCalDef(String syKnCalDef) {
        this.syKnCalDef = syKnCalDef;
    }

    @Override
    public void setSyKnWlDef(String syKnWlDef) {
        this.syKnWlDef = syKnWlDef;
    }

    @Override
    public void setAdvmlAVDef(String advmlAVDef) {
        this.advmlAVDef = advmlAVDef;
    }

    public String getAdvmlAVDef() {
        return ClientTechnologyUserObject.formatDefDate(this.advmlAVDef);
    }

    @Override
    public void setEDRDef(String edrDef) {
        this.edrDef = edrDef;
    }

    public String getEDRDef() {
        return ClientTechnologyUserObject.formatDefDate(this.edrDef);
    }

    public String getWtrDef() {
        return ClientTechnologyUserObject.formatDefDate(this.wtrDef);
    }

    @Override
    public void setWtrDef(String wtrDef) {
        this.wtrDef = wtrDef;
    }

    public String getTdadDef() {
        return ClientTechnologyUserObject.formatDefDate(this.tdadDef);
    }

    @Override
    public void setTdadDef(String tdadDef) {
        this.tdadDef = tdadDef;
    }

    @Override
    public void setOnlineStatus(int status) {
        this.setOnlineStatusEx(status);
    }

    public String getDownloadAdvisorMode() {
        if (this.daStatus == 2 || this.daStatus == 127 || this.cidsStatus == 127) {
            return "";
        }
        if (this.cidsSilentMode == 0 && this.cidsStatus == 2) {
            return MSGRES.getString("ClientTechnologyObject.basicMode");
        }
        return MSGRES.getString("ClientTechnologyObject.advancedMode");
    }
}

