/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemComputerHandler;
import com.sygate.scm.console.logicobject.ClientTechnology;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.util.Date;

public class ClientTechnologyObject
extends ComputerObject
implements ClientTechnology {
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    public static final int NO_REPORTED_STATUS = -1;
    public static final int STATUS_ON = 1;
    public static final int CURRENT_CLIENT_ID = 15;
    public static final int LAST_SITE_ID = 16;
    public static final int LAST_SERVER_ID = 17;
    public static final int COMPUTER_NAME = 0;
    public static final int HEALTH_STATUS = 1;
    public static final int ONLINE_STATUS = 1;
    public static final int LOGON_NAME = 2;
    public static final int IP_ADDRESS = 3;
    public static final int LAST_SCAN = 4;
    public static final int AV_STATUS = 5;
    public static final int FW_STATUS = 6;
    public static final int PTP_STATUS = 7;
    public static final int DA_STATUS = 8;
    public static final int PEP_STATUS = 9;
    public static final int CIDS_STATUS = 10;
    public static final int CIDS_IE_STATUS = 11;
    public static final int CIDS_FF_STATUS = 12;
    public static final int TAMPER_PROTECTION_STATUS = 13;
    public static final int VIRUS_DEF = 14;
    public static final int COMPUTER_ID = 15;
    public static final int CLIENT_ID = 16;
    public static final int TIME_STAMP = 17;
    public static final int USN = 18;
    public static final int DELETED = 19;
    public static final int COMPUTER_DOMAIN = 20;
    public static final int USER_DOMAIN = 21;
    public static final int DEPLOY_STATUS = 29;
    public static final int DEPLOY_MSG = 30;
    public static final int DEPLOY_TARGET_VER = 31;
    public static final int DEPLOY_RUNNING_VER = 32;
    public static final int DEPLOY_TIMESTAMP = 33;
    public static final int PLATFORM = 27;
    public static final int REBOOT_REASON = 28;
    public static final int AGENT_ID = 34;
    public static final int MAJORVERSION = 35;
    public static final int MINORVERSION = 36;
    public static final int CIDS_SILENT_MODE = 37;
    public static final int ELAM_STATUS = 38;
    public static final int LB_STATUS = 46;
    public static final int NTR_STATUS = 47;
    public static final int TDAD_STATUS = 49;
    public static final int IPS_OOB_STATUS = 50;
    public static final int IPS_SERVER_SIG_STATUS = 51;
    public static final int URL_ON_OFF_STATUS = 52;
    public static final int CIDS_CHROME_STATUS = 53;
    public static final int AC_STATUS = 54;
    public static final int DC_STATUS = 55;
    public static final int NOT_INSTALLED_STATUS = 2;
    public static final int INVALID_OPSTATE_VALUE = 126;
    private String groupName = "";
    private String ipAddress = "0.0.0.0";
    private String lastScan;
    private int avStatus = 1;
    private int fwStatus = 1;
    private String rebootReason = "";
    private int ptpStatus = 1;
    private int daStatus = 1;
    private int cidsStatus = 1;
    private int cidiIEStatus = 1;
    private int cidsFFStatus = 1;
    private int cidsChromeStatus = 1;
    private int cidsSilentMode = 0;
    private int tpStatus = 1;
    private int elamStatus = 1;
    private int pepStatus = 1;
    private int lbStatus = 1;
    private int ntrStatus = 0;
    private int tdadStatus = 1;
    private int ipsOobStatus = 1;
    private int urlOnOffStatus = 1;
    private int ipsServerSigStatus = 0;
    private int acStatus = 127;
    private int dcStatus = 127;
    private String ipsDef = null;
    private String mrCleanDef = null;
    private String virusDef = null;
    private String advmlAVDef = null;
    private String edrDef = null;
    private String wtrDef = null;
    private String tdadDef = null;
    private String bashDef = null;
    private String syKnCalDef = null;
    private String syKnWlDef = null;
    public static final int COL_CIDS_BROWSER_CHROME_ONOFF = 13;
    public static final int COL_TAMPER_PROTECTION_STATUS = 14;
    public static final int COL_VIRUS_DEF = 15;
    public static final int COL_IPS_DEF = 16;
    public static final int COL_MR_CLEAN_DEF = 17;
    public static final int COL_PTP_DEF = 18;
    public static final int COL_ADVML_AV_DEF = 19;
    public static final int COL_EDR_DEF = 20;
    public static final int COL_WTR_DEF = 21;
    public static final int COL_TDAD_DEF = 22;
    public static final int COL_ELAM_STATUS = 23;
    public static final int COL_LB_STATUS = 24;
    public static final int COL_NTR_STATUS = 25;
    public static final int COL_TDAD_STATUS = 26;
    public static final int COL_IPS_OOB_STATUS = 27;
    public static final int COL_URL_ONOFF = 28;
    public static final int COL_AC_ONOFF = 29;
    public static final int COL_DC_ONOFF = 30;

    public ClientTechnologyObject() {
        this.client = new SemClient();
        this.agent = new SemAgent();
    }

    public ClientTechnologyObject(SemClient client) {
        super(client);
        this.agent = new SemAgent();
    }

    @Override
    public SemAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setObject(SemTableRow row, String groupId, int peAlert, int isInfected, int onlineStatus) {
        this.getAgent().setAgentId(row.getSemTableValue(34).getValue());
        this.setComputerName(row.getSemTableValue(0).getValue());
        this.setComputerIp(row.getSemTableValue(3).getValue());
        this.setUserName(row.getSemTableValue(2).getValue());
        this.setLastScanTime(row.getSemTableValue(4).getValue());
        this.setAVStatus(Utility.parseInt((String)row.getSemTableValue(5).getValue(), (int)-1));
        this.setFirewallStatus(Utility.parseInt((String)row.getSemTableValue(6).getValue(), (int)-1));
        this.setNtrStatus(Utility.parseInt((String)row.getSemTableValue(47).getValue(), (int)-1));
        this.setVirusDefinition(row.getSemTableValue(14).getValue());
        this.setPtpStatus(Utility.parseInt((String)row.getSemTableValue(7).getValue(), (int)-1));
        this.setDaStatus(Utility.parseInt((String)row.getSemTableValue(8).getValue(), (int)-1));
        this.setCidsStatus(Utility.parseInt((String)row.getSemTableValue(10).getValue(), (int)-1));
        this.setCidiIEStatus(Utility.parseInt((String)row.getSemTableValue(11).getValue(), (int)-1));
        this.setCidsFFStatus(Utility.parseInt((String)row.getSemTableValue(12).getValue(), (int)-1));
        this.setCidsChromeStatus(Utility.parseInt((String)row.getSemTableValue(53).getValue(), (int)-1));
        this.setCidsSilentMode(Utility.parseInt((String)row.getSemTableValue(37).getValue(), (int)-1));
        this.setTpStatus(Utility.parseInt((String)row.getSemTableValue(13).getValue(), (int)-1));
        this.setElamStatus(Utility.parseInt((String)row.getSemTableValue(38).getValue(), (int)-1));
        this.setPepStatus(Utility.parseInt((String)row.getSemTableValue(9).getValue(), (int)-1));
        this.setLbStatus(Utility.parseInt((String)row.getSemTableValue(46).getValue(), (int)-1));
        this.setTdadStatus(Utility.parseInt((String)row.getSemTableValue(49).getValue(), (int)-1));
        this.setIpsOobStatus(Utility.parseInt((String)row.getSemTableValue(50).getValue(), (int)-1));
        this.setIpsServerSigStatus(Utility.parseInt((String)row.getSemTableValue(51).getValue(), (int)-1));
        this.setUrlOnOffStatus(Utility.parseInt((String)row.getSemTableValue(52).getValue(), (int)-1));
        this.setAcStatus(Utility.parseInt((String)row.getSemTableValue(54).getValue(), (int)-1));
        this.setDcStatus(Utility.parseInt((String)row.getSemTableValue(55).getValue(), (int)-1));
        this.setComputerId(row.getSemTableValue(15).getValue());
        this.setGroupId(groupId);
        this.setComputerDomainName(row.getSemTableValue(20).getValue());
        this.setUserDomainName(row.getSemTableValue(21).getValue());
        this.setClientPlatform(Integer.parseInt(row.getSemTableValue(27).getValue()));
        this.setAgentDomainId(Manager.getCurrentDomainId());
        this.getAgent().setTimeStamp(Long.valueOf(row.getSemTableValue(17).getValue()));
        this.client.setUSN(Long.valueOf(row.getSemTableValue(18).getValue()));
        this.client.setDeleted(Integer.valueOf(row.getSemTableValue(19).getValue()));
        this.client.setOptComputerId(row.getSemTableValue(15).getValue());
        this.client.setClientId(row.getSemTableValue(16).getValue());
        this.client.setOptGroupId(groupId);
        this.setOnlineStatusEx(onlineStatus);
        this.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(29).getValue(), (int)0));
        this.setRebootReason(SemComputerHandler.getFormattedRebootReason(row.getSemTableValue(28).getValue()));
        this.setDeployMessage(row.getSemTableValue(30).getValue());
        this.setDeployTargetVersion(row.getSemTableValue(31).getValue());
        this.setDeployRunningVersion(row.getSemTableValue(32).getValue());
        this.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(33).getValue(), (long)0L));
        this.setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(35).getValue())));
        this.setAgentVersionMinor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(36).getValue())));
        this.setPowerEraserPendingAlertCount(peAlert);
        this.setInfected(isInfected);
        this.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(45).getValue())));
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 1: {
                this.setOnlineStatusEx((Integer)value);
                break;
            }
            case 2: {
                this.setLoginName((String)value);
                break;
            }
            case 3: {
                this.setComputerIp((String)value);
                break;
            }
            case 4: {
                this.setLastScanTime((String)value);
                break;
            }
            case 5: {
                this.setAVStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 6: {
                this.setFirewallStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 7: {
                this.setPtpStatus((Integer)value);
                break;
            }
            case 9: {
                this.setPepStatus((Integer)value);
                break;
            }
            case 8: {
                this.setDaStatus((Integer)value);
                break;
            }
            case 10: {
                this.setCidsStatus((Integer)value);
                break;
            }
            case 11: {
                this.setCidiIEStatus((Integer)value);
                break;
            }
            case 12: {
                this.setCidsFFStatus((Integer)value);
                break;
            }
            case 13: {
                this.setCidsChromeStatus((Integer)value);
                break;
            }
            case 14: {
                this.setTpStatus((Integer)value);
                break;
            }
            case 23: {
                this.setElamStatus((Integer)value);
                break;
            }
            case 24: {
                this.setLbStatus((Integer)value);
                break;
            }
            case 15: {
                this.setVirusDefinition((String)value);
                break;
            }
            case 17: {
                this.setMrCleanDef((String)value);
                break;
            }
            case 18: {
                break;
            }
            case 16: {
                this.setIpsDef((String)value);
                break;
            }
            case 19: {
                this.setAdvmlAVDef((String)value);
                break;
            }
            case 20: {
                this.setEDRDef((String)value);
                break;
            }
            case 21: {
                this.setWtrDef((String)value);
                break;
            }
            case 22: {
                this.setTdadDef((String)value);
                break;
            }
            case 35: {
                this.setAgentVersionMajor((Integer)value);
                break;
            }
            case 25: {
                this.setNtrStatus((Integer)value);
                break;
            }
            case 26: {
                this.setTdadStatus((Integer)value);
                break;
            }
            case 27: {
                this.setIpsOobStatus((Integer)value);
                break;
            }
            case 28: {
                this.setUrlOnOffStatus((Integer)value);
                break;
            }
            case 29: {
                this.setAcStatus((Integer)value);
                break;
            }
            case 30: {
                this.setDcStatus((Integer)value);
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        Object ret = null;
        ret = LIC_OBJ.isSEPSBProduct() ? this.getSEPSBValueAt(index) : this.getSEPEValueAt(index);
        return ret;
    }

    public Object getSEPEValueAt(int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getComputerIp();
            }
            case 4: {
                return this.getLastScanTime();
            }
            case 5: {
                return this.getAVStatus();
            }
            case 6: {
                return this.getFirewallStatus();
            }
            case 8: {
                StringBuffer opStateDesc = new StringBuffer(ClientTechnologyObject.getOPStatDesc(this.getDaStatus()));
                String mode = this.getDownloadAdvisorMode();
                if (!mode.isEmpty()) {
                    opStateDesc.append(" - ");
                    opStateDesc.append(mode);
                }
                return opStateDesc.toString();
            }
            case 7: {
                return ClientTechnologyObject.getOPStatDesc(this.getPtpStatus());
            }
            case 9: {
                return ClientTechnologyObject.getOPStatDesc(this.getPepStatus());
            }
            case 10: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsStatus());
            }
            case 11: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidiIEStatus());
            }
            case 12: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsFFStatus());
            }
            case 13: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsChromeStatus());
            }
            case 14: {
                return ClientTechnologyObject.getOPStatDesc(this.getTpStatus());
            }
            case 23: {
                return ClientTechnologyObject.getOPStatDesc(this.getElamStatus());
            }
            case 24: {
                return ClientTechnologyObject.getLbStatDesc(this.getLbStatus());
            }
            case 15: {
                return this.getVirusDefinition();
            }
            case 17: {
                return this.getMrCleanDef();
            }
            case 18: {
                return this.getPtpDef();
            }
            case 19: {
                return this.getAMLAVDef();
            }
            case 20: {
                return this.getEDRDef();
            }
            case 16: {
                return this.getIpsDef();
            }
            case 21: {
                return this.getWtrDef();
            }
            case 22: {
                return this.getTdadDef();
            }
            case 35: {
                return this.getAgentVersionMajor();
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 25: {
                return ClientTechnologyObject.getOPStatDesc(this.getNtrStatus());
            }
            case 26: {
                return ClientTechnologyObject.getOPStatDesc(this.getTdadStatus());
            }
            case 27: {
                return ClientTechnologyObject.getOPStatDesc(this.getIpsOobStatus());
            }
            case 28: {
                return ClientTechnologyObject.getOPStatDesc(this.getUrlOnOffStatus());
            }
            case 29: {
                return ClientTechnologyObject.getOPStatDesc(this.getAcStatus());
            }
            case 30: {
                return ClientTechnologyObject.getOPStatDesc(this.getDcStatus());
            }
        }
        return null;
    }

    public Object getSEPSBValueAt(int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getComputerIp();
            }
            case 4: {
                return this.getLastScanTime();
            }
            case 5: {
                return this.getAVStatus();
            }
            case 6: {
                return this.getFirewallStatus();
            }
            case 8: {
                StringBuffer opStateDesc = new StringBuffer(ClientTechnologyObject.getOPStatDesc(this.getDaStatus()));
                String mode = this.getDownloadAdvisorMode();
                if (!mode.isEmpty()) {
                    opStateDesc.append(" - ");
                    opStateDesc.append(mode);
                }
                return opStateDesc.toString();
            }
            case 7: {
                return ClientTechnologyObject.getOPStatDesc(this.getPtpStatus());
            }
            case 9: {
                return ClientTechnologyObject.getOPStatDesc(this.getPepStatus());
            }
            case 10: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsStatus());
            }
            case 11: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidiIEStatus());
            }
            case 12: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsFFStatus());
            }
            case 13: {
                return ClientTechnologyObject.getOPStatDesc(this.getCidsChromeStatus());
            }
            case 14: {
                return ClientTechnologyObject.getOPStatDesc(this.getTpStatus());
            }
            case 23: {
                return ClientTechnologyObject.getOPStatDesc(this.getElamStatus());
            }
            case 15: {
                return this.getVirusDefinition();
            }
            case 17: {
                return this.getMrCleanDef();
            }
            case 18: {
                return this.getPtpDef();
            }
            case 16: {
                return this.getIpsDef();
            }
            case 20: {
                return this.getEDRDef();
            }
            case 21: {
                return this.getWtrDef();
            }
            case 22: {
                return this.getTdadDef();
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 35: {
                return this.getAgentVersionMajor();
            }
            case 25: {
                return ClientTechnologyObject.getOPStatDesc(this.getNtrStatus());
            }
            case 26: {
                return ClientTechnologyObject.getOPStatDesc(this.getTdadStatus());
            }
            case 27: {
                return ClientTechnologyObject.getOPStatDesc(this.getIpsOobStatus());
            }
            case 28: {
                return ClientTechnologyObject.getOPStatDesc(this.getUrlOnOffStatus());
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.showFinderTable && index == 2) {
            index = 3;
        }
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Date.class;
            }
            case 5: {
                return String.class;
            }
            case 24: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 15: {
                return String.class;
            }
            case 20: {
                return String.class;
            }
            case 22: {
                return String.class;
            }
            case 35: {
                return Integer.class;
            }
            case 25: {
                return String.class;
            }
            case 26: {
                return String.class;
            }
            case 13: {
                return String.class;
            }
            case 27: {
                return String.class;
            }
            case 28: {
                return String.class;
            }
            case 29: {
                return String.class;
            }
            case 30: {
                return String.class;
            }
        }
        return null;
    }

    public void setComputerIp(String value) {
        this.ipAddress = value;
    }

    public String getComputerIp() {
        return this.ipAddress;
    }

    public void setLastScanTime(String value) {
        String time = "";
        try {
            long number = Long.parseLong(value);
            if (number >= 60000L) {
                Date date = new Date(number);
                DateFormat df = DateFormat.getDateTimeInstance(1, 3);
                df.setTimeZone(Utility.getLocalTimeZone());
                time = df.format(date);
            } else {
                time = MSGRES.getString("ClientTechnologyObject.notScanned");
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.lastScan = time;
    }

    public void setAgentDomainId(String value) {
        this.agent.setOptDomainId(value);
    }

    public void setAgentGroupId(String value) {
        this.agent.setOptGroupId(value);
    }

    public void setAgentGroupName(String value) {
        this.groupName = value;
    }

    public void setAVStatus(int avStatus) {
        this.avStatus = avStatus;
    }

    public void setFirewallStatus(int firewallStatus) {
        this.fwStatus = firewallStatus;
    }

    public int getPtpStatus() {
        return this.ptpStatus;
    }

    public void setPtpStatus(int ptpStatus) {
        this.ptpStatus = ptpStatus;
    }

    public int getPepStatus() {
        return this.pepStatus;
    }

    public void setPepStatus(int pepStatus) {
        this.pepStatus = pepStatus;
    }

    public int getDaStatus() {
        return this.daStatus;
    }

    public void setDaStatus(int daStatus) {
        this.daStatus = daStatus;
    }

    public int getCidsStatus() {
        return this.cidsStatus;
    }

    public void setCidsStatus(int cidspStatus) {
        this.cidsStatus = cidspStatus;
    }

    public int getCidiIEStatus() {
        return this.cidiIEStatus;
    }

    public void setCidiIEStatus(int cidiIEStatus) {
        this.cidiIEStatus = cidiIEStatus;
    }

    public int getCidsFFStatus() {
        return this.cidsFFStatus;
    }

    public void setCidsFFStatus(int cidsFFStatus) {
        this.cidsFFStatus = cidsFFStatus;
    }

    public int getCidsChromeStatus() {
        return this.cidsChromeStatus;
    }

    public void setCidsChromeStatus(int cidsChromeStatus) {
        this.cidsChromeStatus = cidsChromeStatus;
    }

    public int getCidsSilentMode() {
        return this.cidsSilentMode;
    }

    public void setCidsSilentMode(int cidsSilentMode) {
        this.cidsSilentMode = cidsSilentMode;
    }

    public void setVirusDefinition(String value) {
        this.virusDef = value;
    }

    public String getAgentDomainId() {
        return this.agent.getOptDomainId();
    }

    public String getAgentGroupId() {
        return this.agent.getOptGroupId();
    }

    public String getLastScanTime() {
        return this.lastScan;
    }

    public int getTpStatus() {
        return this.tpStatus;
    }

    public void setTpStatus(int tpStatus) {
        this.tpStatus = tpStatus;
    }

    public int getElamStatus() {
        return this.elamStatus;
    }

    public void setElamStatus(int elamStatus) {
        this.elamStatus = elamStatus;
    }

    public int getLbStatus() {
        return this.lbStatus;
    }

    public void setLbStatus(int lbStatus) {
        this.lbStatus = lbStatus;
    }

    public String getAVStatus() {
        return ClientTechnologyObject.getOPStatDesc(this.avStatus);
    }

    public String getFirewallStatus() {
        return ClientTechnologyObject.getOPStatDesc(this.fwStatus);
    }

    public int getTdadStatus() {
        return this.tdadStatus;
    }

    public void setTdadStatus(int tdadStatus) {
        this.tdadStatus = tdadStatus;
    }

    public int getIpsOobStatus() {
        return this.ipsOobStatus;
    }

    public void setIpsOobStatus(int ipsOobStatus) {
        this.ipsOobStatus = ipsOobStatus;
    }

    public int getUrlOnOffStatus() {
        return this.urlOnOffStatus;
    }

    public void setUrlOnOffStatus(int urlOnOffStatus) {
        this.urlOnOffStatus = urlOnOffStatus;
    }

    public int getIpsServerSigStatus() {
        return this.ipsServerSigStatus;
    }

    public void setIpsServerSigStatus(int ipsServerSigStatus) {
        this.ipsServerSigStatus = ipsServerSigStatus;
    }

    public static String getOPStatDesc(int opState) {
        switch (opState) {
            case 0: {
                return MSGRES.getString("ClientTechnologyObject.disabled.by.user");
            }
            case 1: {
                return MSGRES.getString("ClientTechnologyObject.Running");
            }
            case 2: {
                return MSGRES.getString("ClientTechnologyObject.notInstalled");
            }
            case 3: {
                return MSGRES.getString("ClientTechnologyObject.disabled.by.admin.using.policy");
            }
            case 4: {
                return MSGRES.getString("ClientTechnologyObject.component.malfunctioning");
            }
            case 5: {
                return MSGRES.getString("ClientTechnologyObject.component.unlicensed");
            }
            case 127: {
                return MSGRES.getString("ClientTechnologyObject.notReportingStatus");
            }
        }
        return MSGRES.getString("ClientTechnologyObject.notReportingStatus");
    }

    public static String getLbStatDesc(int lbstate) {
        switch (lbstate) {
            case 0: {
                return MSGRES.getString("ClientTechnologyObject.disabled.by.user");
            }
            case 1: {
                return MSGRES.getString("ClientTechnologyObject.Running");
            }
            case 2: {
                return MSGRES.getString("ClientTechnologyObject.notApplicable");
            }
            case 3: {
                return MSGRES.getString("ClientTechnologyObject.disabled.by.admin.using.policy");
            }
            case 4: {
                return MSGRES.getString("ClientTechnologyObject.component.content.action.required");
            }
            case 5: {
                return MSGRES.getString("ClientTechnologyObject.component.unlicensed");
            }
            case 127: {
                return MSGRES.getString("ClientTechnologyObject.notReportingStatus");
            }
        }
        return MSGRES.getString("ClientTechnologyObject.notReportingStatus");
    }

    public String getDownloadAdvisorMode() {
        if (this.daStatus == 2 || this.daStatus == 127 || this.cidsStatus == 127) {
            return "";
        }
        if (this.cidsSilentMode == 0 && this.cidsStatus == 2) {
            return MSGRES.getString("ClientTechnologyObject.basicMode");
        }
        return MSGRES.getString("ClientTechnologyObject.advancedMode");
    }

    public String getVirusDefinition() {
        if (this.avStatus == 2) {
            return ClientTechnologyObject.formatDefDate("");
        }
        return ClientTechnologyObject.formatDefDate(this.virusDef);
    }

    public String getAgentGroupName() {
        return this.groupName;
    }

    public void setRebootReason(String reason) {
        this.rebootReason = reason;
    }

    public String getRebootReason() {
        return this.rebootReason;
    }

    public String getPtpDef() {
        if (this.ptpStatus == 2) {
            return ClientTechnologyObject.getOPStatDesc(2);
        }
        if (this.isPostAmberClient()) {
            return ClientTechnologyObject.formatDefDate(this.bashDef);
        }
        int ret = RevisionObject.compareDbFormatRevision(this.syKnCalDef, this.syKnWlDef);
        if (ret == 1) {
            return ClientTechnologyObject.formatDefDate(this.syKnCalDef);
        }
        return ClientTechnologyObject.formatDefDate(this.syKnWlDef);
    }

    public String getAMLAVDef() {
        if (this.daStatus == 2) {
            return ClientTechnologyObject.formatDefDate("");
        }
        return ClientTechnologyObject.formatDefDate(this.advmlAVDef);
    }

    public String getEDRDef() {
        if (this.daStatus == 2) {
            return ClientTechnologyObject.formatDefDate("");
        }
        return ClientTechnologyObject.formatDefDate(this.edrDef);
    }

    public String getMrCleanDef() {
        if (this.daStatus == 2) {
            return ClientTechnologyObject.formatDefDate("");
        }
        return ClientTechnologyObject.formatDefDate(this.mrCleanDef);
    }

    @Override
    public void setMrCleanDef(String mrCleanDef) {
        this.mrCleanDef = mrCleanDef;
    }

    public String getIpsDef() {
        Object suffix = "";
        if (this.getIpsServerSigStatus() == 1 && this.ipsDef != null) {
            suffix = " " + MSGRES.getString("ClientTechnologyObject.IPS_SERVER_SIG_SUFFIX");
        }
        return ClientTechnologyObject.formatDefDate(this.ipsDef) + (String)suffix;
    }

    @Override
    public void setIpsDef(String ipsDef) {
        this.ipsDef = ipsDef;
    }

    @Override
    public void setBashDef(String bashDef) {
        this.bashDef = bashDef;
    }

    @Override
    public void setSyKnCalDef(String syKnCalDef) {
        this.syKnCalDef = syKnCalDef;
    }

    @Override
    public void setSyKnWlDef(String syKnWlDef) {
        this.syKnWlDef = syKnWlDef;
    }

    @Override
    public void setAdvmlAVDef(String advmlAVDef) {
        this.advmlAVDef = advmlAVDef;
    }

    @Override
    public void setEDRDef(String edrDef) {
        this.edrDef = edrDef;
    }

    public String getWtrDef() {
        return ClientTechnologyObject.formatDefDate(this.wtrDef);
    }

    @Override
    public void setWtrDef(String wtrDef) {
        this.wtrDef = wtrDef;
    }

    public String getTdadDef() {
        return ClientTechnologyObject.formatDefDate(this.tdadDef);
    }

    @Override
    public void setTdadDef(String tdadDef) {
        this.tdadDef = tdadDef;
    }

    @Override
    public void setOnlineStatus(int status) {
        this.setOnlineStatusEx(status);
    }

    public int getNtrStatus() {
        return this.ntrStatus;
    }

    public void setNtrStatus(int status) {
        this.ntrStatus = status;
    }

    public int getAcStatus() {
        return this.acStatus;
    }

    public void setAcStatus(int status) {
        this.acStatus = status;
    }

    public int getDcStatus() {
        return this.dcStatus;
    }

    public void setDcStatus(int status) {
        this.dcStatus = status;
    }
}

