/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.ICustomView;
import com.sygate.scm.console.logicobject.OperatingSystemObject;
import com.sygate.scm.console.ui.util.JLabelData;
import java.text.MessageFormat;

public class ClientSystemObject
extends ComputerObject
implements ICustomView {
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    public static final int COMPUTER_NAME = 0;
    public static final int ONLINE_STATUS = 1;
    public static final int LOGON_NAME = 2;
    public static final int IP_ADDRESS = 3;
    public static final int OS_TYPE = 4;
    public static final int SERVICE_PACK = 5;
    public static final int FREE_MEM = 6;
    public static final int FREE_DISK = 7;
    public static final int DISK_TOTAL = 8;
    public static final int GROUP_NAME = 9;
    public static final int COMPUTER_ID = 10;
    public static final int CLIENT_ID = 11;
    public static final int COMPUTER_DOMAIN_NAME = 12;
    public static final int USER_DOMAIN_NAME = 13;
    public static final int TIME_STAMP = 14;
    public static final int USN = 15;
    public static final int DELETED = 16;
    public static final int PLATFORM = 22;
    public static final int DEPLOY_STATUS = 23;
    public static final int DEPLOY_MSG = 24;
    public static final int DEPLOY_TARGET_VERSION = 25;
    public static final int DEPLOY_RUNNING_VERSION = 26;
    public static final int DEPLOY_TIMESTAMP = 27;
    public static final int OPERATION_SYSTEM = 28;
    public static final int MAJORVERSION = 29;
    public static final int I18NOSKEY = 30;
    private SemAgent agent = null;
    private String groupName = "";
    private String ipAddress = "0.0.0.0";
    private String osType = "defaultOsType";
    private String servicePack = "defaultServicePack";
    private Long freeMemory;
    private Long freeDisk;
    private Long diskTotal;

    public ClientSystemObject() {
        this.client = new SemClient();
        this.agent = new SemAgent();
    }

    public ClientSystemObject(SemClient client) {
        super(client);
        this.agent = new SemAgent();
    }

    public SemAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 1: {
                this.setOnlineStatusEx((Integer)value);
                break;
            }
            case 2: {
                this.setLoginName((String)value);
                break;
            }
            case 3: {
                this.setComputerIp((String)value);
                break;
            }
            case 4: {
                this.setOperatingSystemObject((OperatingSystemObject)value);
                break;
            }
            case 5: {
                this.setServicePack((String)value);
                break;
            }
            case 6: {
                this.setFreeMemory(value.toString());
                break;
            }
            case 7: {
                this.setFreeDisk(value.toString());
                break;
            }
            case 8: {
                this.setDiskTotal(value.toString());
                break;
            }
            case 29: {
                this.setAgentVersionMajor((Integer)value);
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getComputerIp();
            }
            case 4: {
                return this.getL10nOperatingSystemName();
            }
            case 5: {
                return this.getServicePack();
            }
            case 6: {
                return this.getFreeMemory();
            }
            case 7: {
                return this.getFreeDisk();
            }
            case 8: {
                return this.getDiskTotal();
            }
            case 29: {
                return this.getAgentVersionMajor();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.showFinderTable && index == 3) {
            index = 4;
        }
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 1: {
                return JLabelData.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return Long.class;
            }
            case 7: {
                return Long.class;
            }
            case 8: {
                return Long.class;
            }
            case 29: {
                return Integer.class;
            }
        }
        return null;
    }

    public void setComputerIp(String value) {
        this.ipAddress = value;
    }

    public String getComputerIp() {
        return this.ipAddress;
    }

    public void setOsType(String value) {
        this.osType = value;
    }

    public String getOsType() {
        return this.osType;
    }

    public void setServicePack(String value) {
        this.servicePack = value;
    }

    public String getServicePack() {
        return this.servicePack;
    }

    public void setFreeMemory(String value) {
        if (value == null || value.compareTo("") == 0) {
            value = "0";
        }
        this.freeMemory = Long.valueOf(value);
    }

    public String getFreeMemory() {
        Long freeMemInMegs = this.freeMemory / 0x100000L;
        String fmim = "" + freeMemInMegs;
        return MessageFormat.format(MSGRES.getString("ClientSystemObject.formatFreeDisk"), fmim);
    }

    public void setFreeDisk(String value) {
        if (value == null || value.compareTo("") == 0) {
            value = "0";
        }
        this.freeDisk = Long.valueOf(value);
    }

    public String getFreeDisk() {
        Long freeDiskInMegs = this.freeDisk / 0x100000L;
        String fdim = "" + freeDiskInMegs;
        return MessageFormat.format(MSGRES.getString("ClientSystemObject.formatFreeDisk"), fdim);
    }

    public void setDiskTotal(String value) {
        if (value == null || value.compareTo("") == 0) {
            value = "0";
        }
        this.diskTotal = Long.valueOf(value);
    }

    public String getDiskTotal() {
        Long totalDiskInMegs = this.diskTotal / 0x100000L;
        String tdim = "" + totalDiskInMegs;
        return MessageFormat.format(MSGRES.getString("ClientSystemObject.formatFreeDisk"), tdim);
    }

    public String getAgentDomainId() {
        return this.agent.getOptDomainId();
    }

    public String getAgentGroupId() {
        return this.agent.getOptGroupId();
    }

    public String getAgentGroupName() {
        return this.groupName;
    }

    public void setAgentGroupName(String value) {
        this.groupName = value;
    }

    public void setAgentDomainId(String value) {
        this.agent.setOptDomainId(value);
    }

    @Override
    public long getAgentTime() {
        return this.getAgent().getTimeStamp();
    }

    @Override
    public Integer getAgentVersionMajor() {
        return this.agent.getOptAgentVersionMajor();
    }

    @Override
    public void setAgentVersionMajor(Integer value) {
        this.agent.setOptAgentVersionMajor(value);
    }
}

