/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ICustomView;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.text.DateFormat;
import java.util.Date;

public class ClientStatusUserObject
extends UserObject
implements ICustomView {
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    public static final int COMPUTER_NAME = 0;
    public static final int HEALTH_STATUS = 1;
    public static final int LOGON_NAME = 2;
    public static final int IP_ADDRESS = 3;
    public static final int VERSION = 4;
    public static final int LAST_UPDATE = 5;
    public static final int REBOOT_REQUIRED = 6;
    public static final int POLICY_SERIAL = 7;
    public static final int MAJORVERSION = 35;
    private int bootRequired = 0;
    private String groupName = "";
    private String ipAddress = "0.0.0.0";
    private String rebootReason = "";
    private String clientOperationSystem = "";
    private String clientOSServicePack = "";

    public ClientStatusUserObject() {
        this.client = new SemClient();
        this.agent = new SemAgent();
    }

    public ClientStatusUserObject(String groupId, String name, String description, String domainName) {
        this.client = new SemClient();
        this.client.setClientId(new GUIDGenerator().getGUIDString());
        this.client.setOptDomainId(Manager.getCurrentDomainId());
        this.client.setOptGroupId(groupId);
        this.client.setOptComputerName(name);
        this.client.setOptDescription(description);
        this.client.setOptComputerDomainName(domainName);
        this.client.setOptPolicyMode(POLICY_MODE);
        this.client.setOptCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setOptCreator(Integer.valueOf(0));
        this.client.setTimeStamp(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setUSN(Long.valueOf(0L));
        this.client.setDeleted(Integer.valueOf(0));
    }

    public ClientStatusUserObject(SemClient client) {
        super(client);
        this.agent = new SemAgent();
    }

    public SemAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 1: {
                this.setOnlineStatusEx((Integer)value);
                break;
            }
            case 2: {
                this.setLoginName((String)value);
                break;
            }
            case 3: {
                this.setComputerIp((String)value);
                break;
            }
            case 4: {
                this.setAgentVersion((String)value);
                break;
            }
            case 5: {
                this.setAgentLastCheckin((Long)value);
                break;
            }
            case 6: {
                this.setRebootRequired(Integer.parseInt(value.toString()));
                break;
            }
            case 7: {
                this.setPolicySerialNumber((String)value);
                break;
            }
            case 35: {
                this.setAgentVersionMajor((Integer)value);
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        Object ret = null;
        ret = LIC_OBJ.isSEPSBProduct() ? this.getSEPSBValueAt(index) : this.getSEPEValueAt(index);
        return ret;
    }

    public Object getSEPEValueAt(int index) {
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getComputerIp();
            }
            case 4: {
                return this.getAgentVersion();
            }
            case 5: {
                return this.getAgentLastCheckin();
            }
            case 6: {
                return this.getRebootRequired() + this.getRebootReason();
            }
            case 7: {
                return this.getPolicySerialNumber();
            }
            case 35: {
                return this.getAgentVersionMajor();
            }
        }
        return null;
    }

    public Object getSEPSBValueAt(int index) {
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getComputerIp();
            }
            case 4: {
                return this.getAgentVersion();
            }
            case 5: {
                return this.getAgentLastCheckin();
            }
            case 6: {
                return this.getRebootRequired() + this.getRebootReason();
            }
            case 7: {
                return this.getPolicySerialNumber();
            }
            case 35: {
                return this.getAgentVersionMajor();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.showFinderTable && index == 2) {
            index = 3;
        }
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Date.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
            case 35: {
                return Integer.class;
            }
        }
        return null;
    }

    public void setRebootReason(String reason) {
        this.rebootReason = reason;
    }

    public String getRebootReason() {
        return this.rebootReason;
    }

    public void setComputerIp(String value) {
        this.ipAddress = value;
    }

    public String getComputerIp() {
        return this.ipAddress;
    }

    public void setAgentLastCheckin(Long value) {
        this.agent.setOptLastUpdateTime(value);
    }

    public void setAgentVersion(String value) {
        this.agent.setOptAgentVersion(value);
    }

    public void setAgentDomainId(String value) {
        this.agent.setOptDomainId(value);
    }

    public void setAgentGroupId(String value) {
        this.agent.setOptGroupId(value);
    }

    public void setAgentGroupName(String value) {
        this.groupName = value;
    }

    public void setPolicySerialNumber(String n) {
        this.agent.setOptProfileSerialNo(n);
    }

    public void setRebootRequired(int i) {
        this.bootRequired = i;
    }

    public String getAgentLastCheckin() {
        String time = "";
        if (this.agent.getOptLastUpdateTime() > 0L) {
            try {
                Date d = new Date(this.agent.getOptLastUpdateTime());
                time = DateFormat.getDateTimeInstance(1, 3).format(d);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return time;
    }

    public String getAgentVersion() {
        return this.agent.getOptAgentVersion();
    }

    public String getAgentDomainId() {
        return this.agent.getOptDomainId();
    }

    public String getAgentGroupId() {
        return this.agent.getOptGroupId();
    }

    public String getPolicySerialNumber() {
        return this.agent.getOptProfileSerialNo();
    }

    public String getRebootRequired() {
        if (this.bootRequired == 1) {
            return MSGRES.getString("ClientStatusObject.yes");
        }
        return MSGRES.getString("ClientStatusObject.no");
    }

    public String getAgentGroupName() {
        return this.groupName;
    }

    public void setClientOperationSystem(String operationSystem) {
        if (!StringUtilities.isEmpty((String)operationSystem)) {
            this.clientOperationSystem = operationSystem;
        }
    }

    public String getClientOperationSystem() {
        return this.clientOperationSystem;
    }

    public void setClientOSServicePack(String servicePack) {
        if (!StringUtilities.isEmpty((String)servicePack)) {
            this.clientOSServicePack = servicePack;
        }
    }

    public String getClientOSSerivePack() {
        return this.clientOSServicePack;
    }

    @Override
    public long getAgentTime() {
        return this.getAgent().getTimeStamp();
    }

    @Override
    public Integer getAgentVersionMajor() {
        return this.agent.getOptAgentVersionMajor();
    }

    @Override
    public void setAgentVersionMajor(Integer value) {
        this.agent.setOptAgentVersionMajor(value);
    }
}

