/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.ClientHealthColumnData;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.OperatingSystemObject;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class ClientObject
extends AbstractUIObject
implements TableRow {
    protected static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    public static final int NAME = 0;
    public static final int DOMAIN_NAME = 1;
    public static final int LOGON_NAME = 2;
    public static final int DESCRIPTION = 3;
    public static final int HEALTH_STATUS = 4;
    public static final String COLUMN_POWERERASER_PENDING_ALERTS = "POWERERASER_PENDING_ALERTS";
    public static final String COLUMN_INSTALL_TYPE = "INSTALL_TYPE_STATUS";
    public static final String COLUMN_INFECTED = "INFECTED";
    boolean showOnlineStatus = false;
    boolean showFinderTable = false;
    protected int deployStatus = 0;
    protected String deployTargetVersion = "";
    protected String deployRunningVersion = "";
    protected long deployTimestamp = 0L;
    protected String deployMessage = "";
    protected int installType = 0;
    SemAgent agent = null;
    SemClient client = null;
    public int platformType = 1;
    private int onlineStatus = 0;
    protected OperatingSystemObject osObj = null;
    private int infected = 0;
    private int powerEraserPendingAlertCount = 0;

    public ClientObject() {
    }

    public ClientObject(SemClient client) {
        this.client = client;
    }

    public int getInfected() {
        return this.infected;
    }

    public void setInfected(int infected) {
        this.infected = infected;
    }

    public int getPowerEraserPendingAlertCount() {
        return this.powerEraserPendingAlertCount;
    }

    public void setPowerEraserPendingAlertCount(int powerEraserPendingAlertCount) {
        this.powerEraserPendingAlertCount = powerEraserPendingAlertCount;
    }

    public void switchMode() {
        if (this.getPolicyMode() == 1) {
            this.setPolicyMode(0);
        } else {
            this.setPolicyMode(1);
        }
        this.client.setOptHash(null);
    }

    public ClientObject cloneClient(boolean pinned) {
        if (this.client == null) {
            return null;
        }
        SemClient copySemClient = null;
        try {
            copySemClient = (SemClient)SemClient.readXML((byte[])this.client.getBytes());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (copySemClient != null) {
            ClientObject copyClient = null;
            copyClient = this.isComputerMode() ? new ComputerObject(copySemClient) : new UserObject(copySemClient);
            copyClient.setClientId();
            copyClient.setCreationTime(TimeUtil.getServerTime());
            copyClient.setPinned(pinned);
            return copyClient;
        }
        return null;
    }

    public void reset() {
    }

    public static String formatDefDate(String def) {
        return RevisionObject.convertDbFormatStringToUIFormat(def);
    }

    public boolean isValid() {
        return this.client != null;
    }

    public SemClient getSemClient() {
        return this.client;
    }

    public void setShowFinderTable(boolean showFinderTable) {
        this.showFinderTable = showFinderTable;
    }

    public void setShowOnlineStatus(boolean showOnlineStatus) {
        this.showOnlineStatus = showOnlineStatus;
    }

    public String getId() {
        return this.getClientId();
    }

    public String getHash() {
        if (this.client == null || this.client.getOptHash() == null) {
            return "";
        }
        return this.client.getOptHash();
    }

    public String getComputerId() {
        if (this.client == null || this.client.getOptComputerId() == null) {
            return "";
        }
        return this.client.getOptComputerId().trim();
    }

    public void setComputerId(String string) {
        if (this.client != null) {
            this.client.setOptComputerId(string);
        }
    }

    public boolean hasComputerId() {
        return this.client != null && this.client.getOptComputerId() != null && this.client.getOptComputerId().trim().length() > 0;
    }

    public String getClientId() {
        if (this.client == null || this.client.getClientId() == null) {
            return "";
        }
        return this.client.getClientId();
    }

    public void setClientId(String id) {
        if (this.client == null) {
            return;
        }
        this.client.setClientId(id);
    }

    public void setClientId() {
        this.setClientId(new GUIDGenerator().getGUIDString());
    }

    public int getPolicyMode() {
        if (this.client == null || this.client.getOptPolicyMode() == null) {
            return 0;
        }
        return this.client.getOptPolicyMode();
    }

    public void setPolicyMode(int policyMode) {
        if (this.client != null) {
            this.client.setOptPolicyMode(Integer.valueOf(policyMode));
        }
    }

    public String getHardwareKey() {
        if (this.client == null || this.client.getOptHardwareKey() == null) {
            return "";
        }
        return this.client.getOptHardwareKey();
    }

    public int getCreator() {
        if (this.client == null || this.client.getOptCreator() == null) {
            return -1;
        }
        return this.client.getOptCreator();
    }

    public long getCreationTime() {
        if (this.client == null || this.client.getOptCreationTime() == null) {
            return -1L;
        }
        return this.client.getOptCreationTime();
    }

    public void setCreationTime(long time) {
        if (this.client == null) {
            return;
        }
        this.client.setOptCreationTime(Long.valueOf(time));
    }

    public String getCreationTimeDisplayString() {
        long time = this.getCreationTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public String getUserName_Same_As_In_DB() {
        if (this.client == null || this.client.getOptUserName() == null) {
            return "";
        }
        return this.client.getOptUserName();
    }

    public String getUserName() {
        if (this.client == null || StringUtilities.isEmpty((String)this.client.getOptUserName())) {
            return MSGRES.getString("ClientObject.UserName.Null");
        }
        return this.client.getOptUserName().trim();
    }

    public void setUserName(String string) {
        if (this.client != null) {
            this.client.setOptUserName(string);
        }
    }

    public String getComputerName() {
        if (this.client == null || StringUtilities.isEmpty((String)this.client.getOptComputerName())) {
            return MSGRES.getString("ClientObject.UserName.Null");
        }
        return this.client.getOptComputerName().trim();
    }

    public void setComputerName(String string) {
        if (this.client != null) {
            this.client.setOptComputerName(string);
        }
    }

    public String getUserDomainName_Same_As_In_DB() {
        if (this.client == null || this.client.getOptUserDomainName() == null) {
            return "";
        }
        return this.client.getOptUserDomainName();
    }

    public String getUserDomainName() {
        if (this.client == null || StringUtilities.isEmpty((String)this.client.getOptUserDomainName())) {
            return MSGRES.getString("ClientObject.UserDomainName.Null");
        }
        return this.client.getOptUserDomainName().trim();
    }

    public void setUserDomainName(String value) {
        if (this.client != null) {
            this.client.setOptUserDomainName(value);
        }
    }

    public String getComputerDomainName() {
        if (this.client == null || this.client.getOptComputerDomainName() == null) {
            return "";
        }
        return this.client.getOptComputerDomainName().trim();
    }

    public void setComputerDomainName(String value) {
        if (this.client != null) {
            this.client.setOptComputerDomainName(value);
        }
    }

    public String getFullName() {
        if (this.client == null || this.client.getOptFullName() == null) {
            return "";
        }
        return this.client.getOptFullName();
    }

    public void setFullName(String value) {
        if (this.client != null) {
            this.client.setOptFullName(value);
        }
    }

    public String getDescription() {
        if (this.client == null || this.client.getOptDescription() == null) {
            return "";
        }
        return this.client.getOptDescription();
    }

    public void setDescription(String value) {
        if (this.client != null) {
            this.client.setOptDescription(value);
        }
    }

    public String getGroupId() {
        if (this.client == null || this.client.getOptGroupId() == null) {
            return "";
        }
        return this.client.getOptGroupId();
    }

    public boolean hasGroupId() {
        if (this.client == null) {
            return false;
        }
        return this.client.getOptGroupId() != null && this.client.getOptGroupId().length() > 1;
    }

    public void setGroupId(String value) {
        if (this.client != null) {
            this.client.setOptGroupId(value);
        }
    }

    public boolean isGroupOu() {
        if (this.client == null || this.client.getOptGroupIsOu() == null) {
            return false;
        }
        return this.client.getOptGroupIsOu() == 1;
    }

    public void setGroupOu(boolean ou) {
        if (this.client == null) {
            return;
        }
        this.client.setOptGroupIsOu(Integer.valueOf(ou ? 1 : 0));
    }

    public boolean isPinned() {
        if (this.client == null || this.client.getOptPinMark() == null) {
            return false;
        }
        return this.client.getOptPinMark() == 1;
    }

    public void setPinned(boolean pinned) {
        if (this.client == null) {
            return;
        }
        this.client.setOptPinMark(Integer.valueOf(pinned ? 1 : 0));
    }

    public boolean isLanSensor() {
        if (this.client == null || this.client.getOptExtraFeature() == null) {
            return false;
        }
        return this.client.getOptExtraFeature() == 1;
    }

    public void setLanSensor(boolean isLanSensor) {
        if (this.client == null) {
            return;
        }
        this.client.setOptExtraFeature(Integer.valueOf(isLanSensor ? 1 : 0));
    }

    public static String getPolicyModeTypeName(int policyMode) {
        return policyMode == 1 ? MSGRES.getString("ClientObject.PolicyModeName.Computer") : MSGRES.getString("ClientObject.PolicyModeName.User");
    }

    public String getPolicyModeTypeName() {
        return ClientObject.getPolicyModeTypeName(this.getPolicyMode());
    }

    public String getCompoundName(boolean add_type_prefix) {
        String compound = this.getName() + "\\" + this.getDomainName();
        if (add_type_prefix) {
            compound = this.getPolicyModeTypeName() + " " + compound;
        }
        return compound;
    }

    public String getComputerCompoundName() {
        String compound = this.getComputerName() + "\\" + this.getComputerDomainName();
        return compound;
    }

    public String getUserCompoundName() {
        String compound = this.getUserName() + "\\" + this.getUserDomainName();
        return compound;
    }

    public boolean hasAgentAssociated() {
        String computerId = this.getComputerId();
        return computerId != null && computerId.length() > 0;
    }

    public String getOuGuid() {
        if (this.client == null || this.client.getOptOuGuid() == null) {
            return "";
        }
        return this.client.getOptOuGuid();
    }

    public void setOuGuid(String guid) {
        if (this.client == null) {
            return;
        }
        this.client.setOptOuGuid(guid);
    }

    public boolean isComputerMode() {
        return this.getMode() == 1;
    }

    public boolean isUserMode() {
        return this.getMode() == 0;
    }

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDomainName();

    public abstract void setDomainName(String var1);

    public abstract String getLoginName();

    public abstract void setLoginName(String var1);

    public abstract int getMode();

    public int getOnlineStatusEx() {
        return this.onlineStatus;
    }

    public void setOnlineStatusEx(int status) {
        this.onlineStatus = status;
    }

    public int getClientPlatform() {
        return this.platformType;
    }

    public int isOnline() {
        try {
            return SemClientHandler.getClientOnlineStatus(this);
        }
        catch (Throwable ex) {
            return 0;
        }
    }

    public GroupObject getGroupObject() {
        String groupId = this.getGroupId();
        try {
            GroupObject group = GroupHandler.getGroupById(groupId);
            return group;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public abstract Icon getOnlineIconForLocal();

    public abstract Icon getOnlineIconForRemoteServer();

    public abstract Icon getOnlineIconForRemoteSite();

    public abstract Icon getOfflineIcon();

    public abstract Icon getInstallErrorIcon();

    @Override
    public void setValueAt(Object value, int index) {
        if (this.showFinderTable) {
            if (index == 2) {
                index = 3;
            }
        } else if (index != 0) {
            index = index == 1 ? 4 : --index;
        }
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 1: {
                this.setDomainName((String)value);
                break;
            }
            case 2: {
                this.setLoginName((String)value);
                break;
            }
            case 3: {
                this.setDescription((String)value);
                break;
            }
            case 4: {
                this.setOnlineStatusEx((Integer)value);
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        if (this.showFinderTable) {
            if (index == 2) {
                index = 3;
            }
        } else if (index != 0) {
            index = index == 1 ? 4 : --index;
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 1: {
                return this.getDomainName();
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getDescription();
            }
            case 4: {
                return this.getHealthIcon();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.showFinderTable && index == 2) {
            index = 3;
        }
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public Icon getIcon() {
        ImageIcon icon = null;
        if (this.showOnlineStatus) {
            if (this.deployStatus != 0 && (this.deployStatus == 302469120 || this.deployStatus == 302469121 || this.deployStatus == 302469122 || this.deployStatus == 302469123 || this.deployStatus == 302469125 || this.deployStatus == 302469126 || this.deployStatus == 302469127 || this.deployStatus == 302469129 || this.deployStatus == 302469130 || this.deployStatus == 302469132)) {
                icon = (ImageIcon)this.getInstallErrorIcon();
                icon.setDescription("InstallErrorIcon");
                return icon;
            }
            int status = this.getOnlineStatusEx();
            switch (status) {
                case 1: {
                    icon = (ImageIcon)this.getOnlineIconForLocal();
                    icon.setDescription("OnlineIconForLocal");
                    return icon;
                }
                case 2: {
                    icon = (ImageIcon)this.getOnlineIconForRemoteServer();
                    icon.setDescription("OnlineIconForRemoteServer");
                    return icon;
                }
                case 3: {
                    icon = (ImageIcon)this.getOnlineIconForRemoteSite();
                    icon.setDescription("OnlineIconForRemoteSite");
                    return icon;
                }
                case 0: {
                    icon = (ImageIcon)this.getOfflineIcon();
                    icon.setDescription("OfflineIcon");
                    return icon;
                }
            }
            icon = (ImageIcon)this.getOfflineIcon();
            icon.setDescription("OfflineIcon");
            return icon;
        }
        icon = (ImageIcon)this.getOfflineIcon();
        icon.setDescription("OfflineIcon");
        return icon;
    }

    public void setDeployStatus(int i) {
        this.deployStatus = i;
    }

    public int getDeployStatus() {
        return this.deployStatus;
    }

    public void setDeployTargetVersion(String value) {
        this.deployTargetVersion = value;
    }

    public String getDeployTargetVersion() {
        return this.deployTargetVersion;
    }

    public void setDeployRunningVersion(String value) {
        this.deployRunningVersion = value;
    }

    public String getDeployRunningVersion() {
        return this.deployRunningVersion;
    }

    public void setDeployTimestamp(long timestamp) {
        this.deployTimestamp = timestamp;
    }

    public long getDeployTimestamp() {
        return this.deployTimestamp;
    }

    public void setDeployMessage(String deployMsg) {
        this.deployMessage = deployMsg;
    }

    public String getDeployMessage() {
        return this.deployMessage;
    }

    public int getInstallType() {
        return this.installType;
    }

    public void setInstallType(int instType) {
        this.installType = instType;
    }

    public JLabelData getHealthIcon() {
        ClientHealthColumnData data = null;
        int status = this.getOnlineStatusEx();
        String alertMsg = "";
        String healthStateValue = null;
        if (this.getInfected() > 0 || this.getPowerEraserPendingAlertCount() > 0) {
            alertMsg = MSGRES.getString("ClientObject.Alert");
        }
        switch (status) {
            case 1: 
            case 2: {
                healthStateValue = MSGRES.getString("ClientObject.ok");
                break;
            }
            case 3: {
                healthStateValue = MSGRES.getString("ClientObject.ok_remote_site");
                break;
            }
            case 0: {
                healthStateValue = MSGRES.getString("ClientObject.offline");
                break;
            }
            case 4: {
                healthStateValue = MSGRES.getString("ClientObject.offline_remote_site");
                break;
            }
            default: {
                healthStateValue = MSGRES.getString("ClientObject.offline");
            }
        }
        data = new ClientHealthColumnData(healthStateValue + alertMsg);
        data.setComputerId(this.getComputerId());
        data.setInfected(this.getInfected());
        data.setPowerEraserPendingAlertCount(this.getPowerEraserPendingAlertCount());
        StringBuffer tooltipText = new StringBuffer("");
        if (data.hasRiskInfo()) {
            String msg1;
            String msg;
            if (data.getInfected() > 0) {
                msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ClientObject.InfectedCount");
                msg1 = MessageFormat.format(msg, data.getInfected());
                tooltipText.append(msg1);
                tooltipText.append(" ");
            }
            if (data.getPowerEraserPendingAlertCount() > 0) {
                msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ClientObject.PowerEraserPendingAlerts");
                msg1 = MessageFormat.format(msg, data.getPowerEraserPendingAlertCount());
                tooltipText.append(msg1);
            }
        }
        data.setTooltipText(tooltipText.toString());
        return data;
    }

    public void setClientPlatform(int value) {
        this.platformType = value;
    }

    public Integer getAgentVersionMajor() {
        return this.agent.getOptAgentVersionMajor();
    }

    public void setAgentVersionMajor(Integer value) {
        this.agent.setOptAgentVersionMajor(value);
    }

    public Integer getAgentVersionMinor() {
        return this.agent.getOptAgentVersionMinor();
    }

    public void setAgentVersionMinor(Integer value) {
        this.agent.setOptAgentVersionMinor(value);
    }

    public boolean isPostAmberClient() {
        int major = this.getAgentVersionMajor();
        int minor = this.getAgentVersionMinor();
        if (major > 12) {
            return true;
        }
        return major == 12 && minor >= 1;
    }

    public boolean isLegacyClient() {
        return this.getAgentVersionMajor() == 11;
    }

    public void setOperatingSystemObject(OperatingSystemObject osObj) {
        this.osObj = osObj;
    }

    public OperatingSystemObject getOperatingSystemObject() {
        return this.osObj;
    }

    public String getL10nOperatingSystemName() {
        return this.osObj != null ? this.osObj.getDisplayName() : "";
    }

    public String getEnglishOperatingSystemName() {
        return this.osObj != null ? this.osObj.getEnglishName() : "";
    }
}

