/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.ICustomView;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.Utility;

public class ClientNetworkInformationObject
extends ComputerObject
implements ICustomView {
    public static final int COMPUTER_NAME = 0;
    public static final int ONLINE_STATUS = 1;
    public static final int LOGON_NAME = 2;
    public static final int IP_ADDRESS = 3;
    public static final int DNS_SERVER = 4;
    public static final int WINS_SERVER = 5;
    public static final int MAC_ADDRESS = 6;
    public static final int GATEWAYS = 7;
    public static final int GROUP_NAME = 8;
    public static final int COMPUTER_ID = 9;
    public static final int CLIENT_ID = 10;
    public static final int COMPUTER_DOMAIN_NAME = 11;
    public static final int CURRENT_LOGIN_DOMAIN = 12;
    public static final int TIME_STAMP = 13;
    public static final int USN = 14;
    public static final int DELETED = 15;
    public static final int CURRENT_CLIENT_ID = 16;
    public static final int LAST_SITE_ID = 17;
    public static final int LAST_SERVER_ID = 18;
    public static final int DNS_SERVER2 = 19;
    public static final int WINS_SERVER2 = 20;
    public static final int DEPLOY_STATUS = 21;
    public static final int PLATFORM = 28;
    public static final int MAJORVERSION = 29;
    public static final int DOMAIN_WORKGROUP = 35;
    public static final int COMPUTER_NAME_TABLE_COLUMN_INDEX = 0;
    public static final int ONLINE_STATUS_TABLE_COLUMN_INDEX = 1;
    public static final int DOMAIN_WORKGROUP_TABLE_COLUMN_INDEX = 2;
    public static final int LOGON_NAME_TABLE_COLUMN_INDEX = 3;
    public static final int IP_ADDRESS_TABLE_COLUMN_INDEX = 4;
    public static final int DNS_SERVER_TABLE_COLUMN_INDEX = 5;
    public static final int WINS_SERVER_TABLE_COLUMN_INDEX = 6;
    public static final int MAC_ADDRESS_TABLE_COLUMN_INDEX = 7;
    public static final int GATEWAYS_TABLE_COLUMN_INDEX = 8;
    private SemAgent agent = null;
    private String groupName = "";
    private String ipAddress = "0.0.0.0";
    private String dnsServer = "";
    private String dnsServer2 = "";
    private String winsServer = "";
    private String winsServer2 = "";
    private String macAddress = "";
    private String gateways = "";

    public ClientNetworkInformationObject() {
        this.client = new SemClient();
        this.agent = new SemAgent();
    }

    public ClientNetworkInformationObject(SemClient client) {
        super(client);
        this.agent = new SemAgent();
    }

    public SemAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (this.showFinderTable && index == 4) {
            index = 5;
        }
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 1: {
                this.setOnlineStatusEx((Integer)value);
                break;
            }
            case 3: {
                this.setLoginName((String)value);
                break;
            }
            case 4: {
                this.setComputerIp((String)value);
                break;
            }
            case 5: {
                this.setDnsServer((String)value);
                break;
            }
            case 6: {
                this.setWinsServer((String)value);
                break;
            }
            case 7: {
                this.setMacAddress((String)value);
                break;
            }
            case 8: {
                this.setGateways((String)value);
                break;
            }
            case 2: {
                this.setComputerDomainName((String)value);
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        if (this.showFinderTable && index == 4) {
            index = 5;
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 3: {
                return this.getLoginName();
            }
            case 4: {
                return this.getComputerIp();
            }
            case 5: {
                return this.getAllDnsServers();
            }
            case 6: {
                return this.getAllWinsServers();
            }
            case 7: {
                return this.getMacAddress();
            }
            case 8: {
                return this.getGateways();
            }
            case 2: {
                return this.getComputerDomainName();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.showFinderTable && index == 2) {
            index = 3;
        }
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public void setComputerIp(String value) {
        this.ipAddress = value;
    }

    public String getComputerIp() {
        return this.ipAddress;
    }

    public void setDnsServer(String value) {
        this.dnsServer = value;
    }

    public void setDnsServer2(String value) {
        this.dnsServer2 = value;
    }

    public String getDnsServer() {
        return this.dnsServer;
    }

    public String getDnsServer2() {
        return this.dnsServer2;
    }

    public String getAllDnsServers() {
        if (this.dnsServer2 != null && this.dnsServer2.length() != 0 && Utility.isValidIPAddress((String)this.dnsServer2)) {
            return this.dnsServer + ";" + this.dnsServer2;
        }
        return this.dnsServer;
    }

    public String getWinsServer() {
        return this.winsServer;
    }

    public String getWinsServer2() {
        return this.winsServer2;
    }

    public String getAllWinsServers() {
        if (this.winsServer2 != null && this.winsServer2.length() != 0 && Utility.isValidIPAddress((String)this.winsServer2)) {
            return this.winsServer + ";" + this.winsServer2;
        }
        return this.winsServer;
    }

    public void setWinsServer(String value) {
        this.winsServer = value;
    }

    public void setWinsServer2(String value) {
        this.winsServer2 = value;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String value) {
        this.macAddress = value;
    }

    public void setGateways(String value) {
        this.gateways = value;
    }

    public String getGateways() {
        return this.gateways;
    }

    public String getAgentDomainId() {
        return this.agent.getOptDomainId();
    }

    public String getAgentGroupId() {
        return this.agent.getOptGroupId();
    }

    public String getAgentGroupName() {
        return this.groupName;
    }

    public void setAgentGroupName(String value) {
        this.groupName = value;
    }

    public void setAgentDomainId(String value) {
        this.agent.setOptDomainId(value);
    }

    @Override
    public long getAgentTime() {
        return this.getAgent().getTimeStamp();
    }

    @Override
    public Integer getAgentVersionMajor() {
        return this.agent.getOptAgentVersionMajor();
    }

    @Override
    public void setAgentVersionMajor(Integer value) {
        this.agent.setOptAgentVersionMajor(value);
    }
}

