/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ClientTechnologyObject;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.util.Date;

public class ClientDefaultViewObject
extends ComputerObject {
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    public static final int COMPUTER_NAME = 0;
    public static final int HEALTH_STATUS = 1;
    public static final int LOGON_NAME = 2;
    public static final int LAST_UPDATE = 3;
    public static final int VIRUS_DEF = 4;
    public static final int AMLAV_DEF = 5;
    public static final int POLICY_SERIAL = 6;
    public static final int LAST_SCAN = 7;
    public static final int AV_STATUS = 8;
    public static final int FW_STATUS = 9;
    public static final int LB_STATUS = 10;
    public static final int REBOOT_REQUIRED = 11;
    public static final int DESCRIPTION = 12;
    public static final int MAJORVERSION = 32;
    public static final int NO_REPORTED_STATUS = -1;
    private int bootRequired = 0;
    private String groupName = "";
    private String ipAddress = "0.0.0.0";
    private String lastScan;
    private int avStatus = 1;
    private int fwStatus = 1;
    private String virusDef = null;
    private String rebootReason = "";
    private int lbStatus = 1;
    private String amlavDef = null;

    public ClientDefaultViewObject() {
        this.client = new SemClient();
        this.agent = new SemAgent();
    }

    public ClientDefaultViewObject(String groupId, String name, String description, String domainName) {
        this.client = new SemClient();
        this.client.setClientId(new GUIDGenerator().getGUIDString());
        this.client.setOptDomainId(Manager.getCurrentDomainId());
        this.client.setOptGroupId(groupId);
        this.client.setOptComputerName(name);
        this.client.setOptDescription(description);
        this.client.setOptComputerDomainName(domainName);
        this.client.setOptPolicyMode(POLICY_MODE);
        this.client.setOptCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setOptCreator(Integer.valueOf(0));
        this.client.setTimeStamp(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setUSN(Long.valueOf(0L));
        this.client.setDeleted(Integer.valueOf(0));
    }

    public ClientDefaultViewObject(SemClient client) {
        super(client);
        this.agent = new SemAgent();
    }

    public SemAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 2: {
                this.setLoginName((String)value);
                break;
            }
            case 3: {
                this.setAgentLastCheckin((Long)value);
                break;
            }
            case 11: {
                this.setRebootRequired(Integer.parseInt(value.toString()));
                break;
            }
            case 6: {
                this.setPolicySerialNumber((String)value);
                break;
            }
            case 1: {
                this.setOnlineStatusEx((Integer)value);
                break;
            }
            case 7: {
                this.setLastScanTime((String)value);
                break;
            }
            case 8: {
                this.setAVStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 9: {
                this.setFirewallStatus(Integer.parseInt(value.toString()));
                break;
            }
            case 4: {
                this.setVirusDefinition((String)value);
                break;
            }
            case 5: {
                this.setAmlavDefinition((String)value);
                break;
            }
            case 32: {
                this.setAgentVersionMajor((Integer)value);
                break;
            }
            case 12: {
                this.setDescription((String)value);
                break;
            }
            case 10: {
                this.setLbStatus(Integer.parseInt(value.toString()));
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        Object ret = null;
        ret = LIC_OBJ.isSEPSBProduct() ? this.getSEPSBValueAt(index) : this.getSEPEValueAt(index);
        return ret;
    }

    public Object getSEPEValueAt(int index) {
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getAgentLastCheckin();
            }
            case 11: {
                return this.getRebootRequired() + this.getRebootReason();
            }
            case 6: {
                return this.getPolicySerialNumber();
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 7: {
                return this.getLastScanTime();
            }
            case 8: {
                return this.getAVStatus();
            }
            case 9: {
                return this.getFirewallStatus();
            }
            case 4: {
                return this.getVirusDefinition();
            }
            case 5: {
                return this.getAmlavDefinition();
            }
            case 32: {
                return this.getAgentVersionMajor();
            }
            case 12: {
                return this.getDescription();
            }
            case 10: {
                return this.getLbStatus();
            }
        }
        return null;
    }

    public Object getSEPSBValueAt(int index) {
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getIcon());
            }
            case 2: {
                return this.getLoginName();
            }
            case 3: {
                return this.getAgentLastCheckin();
            }
            case 11: {
                return this.getRebootRequired() + this.getRebootReason();
            }
            case 6: {
                return this.getPolicySerialNumber();
            }
            case 1: {
                return this.getHealthIcon();
            }
            case 7: {
                return this.getLastScanTime();
            }
            case 8: {
                return this.getAVStatus();
            }
            case 9: {
                return this.getFirewallStatus();
            }
            case 4: {
                return this.getVirusDefinition();
            }
            case 5: {
                return this.getAmlavDefinition();
            }
            case 32: {
                return this.getAgentVersionMajor();
            }
            case 12: {
                return this.getDescription();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Date.class;
            }
            case 11: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 1: {
                return JLabelData.class;
            }
            case 7: {
                return Date.class;
            }
            case 8: {
                return String.class;
            }
            case 10: {
                return String.class;
            }
            case 9: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 32: {
                return Integer.class;
            }
            case 12: {
                return String.class;
            }
        }
        return null;
    }

    public void setComputerIp(String value) {
        this.ipAddress = value;
    }

    public String getComputerIp() {
        return this.ipAddress;
    }

    public void setAgentLastCheckin(Long value) {
        this.agent.setOptLastUpdateTime(value);
    }

    public void setAgentVersion(String value) {
        this.agent.setOptAgentVersion(value);
    }

    public void setAgentDomainId(String value) {
        this.agent.setOptDomainId(value);
    }

    public void setAgentGroupId(String value) {
        this.agent.setOptGroupId(value);
    }

    public void setAgentGroupName(String value) {
        this.groupName = value;
    }

    public void setPolicySerialNumber(String n) {
        this.agent.setOptProfileSerialNo(n);
    }

    public void setRebootRequired(int i) {
        this.bootRequired = i;
    }

    public String getAgentLastCheckin() {
        String time = "";
        if (this.agent.getOptLastUpdateTime() > 0L) {
            Date d;
            try {
                d = new Date(this.agent.getOptLastUpdateTime());
                time = DateFormat.getDateTimeInstance(1, 3).format(d);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            if (this.agent.getOptLastUpdateTime() > 0L) {
                try {
                    d = new Date(this.agent.getOptLastUpdateTime());
                    DateFormat df = DateFormat.getDateTimeInstance(1, 3);
                    df.setTimeZone(Utility.getLocalTimeZone());
                    time = df.format(d);
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        }
        return time;
    }

    public String getAgentVersion() {
        return this.agent.getOptAgentVersion();
    }

    public String getAgentDomainId() {
        return this.agent.getOptDomainId();
    }

    public String getAgentGroupId() {
        return this.agent.getOptGroupId();
    }

    public String getPolicySerialNumber() {
        return this.agent.getOptProfileSerialNo();
    }

    public String getRebootRequired() {
        if (this.bootRequired == 1) {
            return MSGRES.getString("ClientStatusObject.yes");
        }
        return MSGRES.getString("ClientStatusObject.no");
    }

    public String getAgentGroupName() {
        return this.groupName;
    }

    public String getLastScanTime() {
        return this.lastScan;
    }

    public void setLastScanTime(String value) {
        String time = "";
        try {
            long number = 0L;
            try {
                number = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (number >= 60000L) {
                Date d = new Date(number);
                DateFormat df = DateFormat.getDateTimeInstance(1, 3);
                df.setTimeZone(Utility.getLocalTimeZone());
                time = df.format(d);
            } else {
                time = MSGRES.getString("ClientTechnologyObject.notScanned");
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.lastScan = time;
    }

    public String getAVStatus() {
        return ClientTechnologyObject.getOPStatDesc(this.avStatus);
    }

    public void setAVStatus(int i) {
        this.avStatus = i;
    }

    public String getLbStatus() {
        return ClientTechnologyObject.getLbStatDesc(this.lbStatus);
    }

    public void setLbStatus(int status) {
        this.lbStatus = status;
    }

    public String getFirewallStatus() {
        return ClientTechnologyObject.getOPStatDesc(this.fwStatus);
    }

    public void setFirewallStatus(int n) {
        this.fwStatus = n;
    }

    public String getVirusDefinition() {
        return ClientDefaultViewObject.formatDefDate(this.virusDef);
    }

    public void setVirusDefinition(String value) {
        this.virusDef = value;
    }

    public String getAmlavDefinition() {
        return ClientDefaultViewObject.formatDefDate(this.amlavDef);
    }

    public void setAmlavDefinition(String value) {
        this.amlavDef = value;
    }

    @Override
    public Integer getAgentVersionMajor() {
        return this.agent.getOptAgentVersionMajor();
    }

    @Override
    public void setAgentVersionMajor(Integer value) {
        this.agent.setOptAgentVersionMajor(value);
    }

    public void setRebootReason(String reason) {
        this.rebootReason = reason;
    }

    public String getRebootReason() {
        return this.rebootReason;
    }
}

