/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.BASHSystemChanges;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class BASHSystemChangesObject
extends AbstractUIObject {
    private BASHSystemChanges systemChanges;
    public static final int IGNORE = 0;
    public static final int PROMPT = 1;
    public static final int BLOCK = 2;
    public static final int LOG = 3;

    public BASHSystemChangesObject() {
        this.systemChanges = this.getDefaultSystemChanges();
    }

    public BASHSystemChangesObject(BASHSystemChanges systemChanges) {
        this.systemChanges = systemChanges != null ? systemChanges : this.getDefaultSystemChanges();
    }

    private BASHSystemChanges getDefaultSystemChanges() {
        BASHSystemChanges defSystemChanges = new BASHSystemChanges();
        defSystemChanges.setDNSChangeDetectAction(BASHSystemChanges.IGNORE);
        defSystemChanges.setOptLockDNSChangeDetectAction(defSystemChanges.getDefLockDNSChangeDetectAction());
        defSystemChanges.setHostFileChangeDetectAction(BASHSystemChanges.IGNORE);
        defSystemChanges.setOptLockHostFileChangeDetectAction(defSystemChanges.getDefLockHostFileChangeDetectAction());
        return defSystemChanges;
    }

    public BASHSystemChanges getSystemChanges() {
        return this.systemChanges;
    }

    public void setSystemChanges(BASHSystemChanges systemChanges) {
        if (systemChanges != null) {
            this.systemChanges = systemChanges;
        }
    }

    public Integer getDNSChangeDetectAction() {
        return this.systemChanges.getDNSChangeDetectAction();
    }

    public Integer getHostFileChangeDetectAction() {
        return this.systemChanges.getHostFileChangeDetectAction();
    }

    public Boolean getLockDNSChangeDetectAction() {
        return this.systemChanges.getOptLockDNSChangeDetectAction() != null ? this.systemChanges.getOptLockDNSChangeDetectAction() : this.systemChanges.getDefLockDNSChangeDetectAction();
    }

    public Boolean getLockHostFileChangeDetectAction() {
        return this.systemChanges.getOptLockHostFileChangeDetectAction() != null ? this.systemChanges.getOptLockHostFileChangeDetectAction() : this.systemChanges.getDefLockHostFileChangeDetectAction();
    }

    public void setDNSChangeDetectAction(Integer value) {
        if (value != null) {
            int action = value;
            switch (action) {
                case 0: {
                    this.systemChanges.setDNSChangeDetectAction(BASHSystemChanges.IGNORE);
                    break;
                }
                case 1: {
                    this.systemChanges.setDNSChangeDetectAction(BASHSystemChanges.PROMPT);
                    break;
                }
                case 2: {
                    this.systemChanges.setDNSChangeDetectAction(BASHSystemChanges.BLOCK);
                    break;
                }
                case 3: {
                    this.systemChanges.setDNSChangeDetectAction(BASHSystemChanges.LOG);
                    break;
                }
            }
        }
    }

    public void setHostFileChangeDetectAction(Integer value) {
        if (value != null) {
            int action = value;
            switch (action) {
                case 0: {
                    this.systemChanges.setHostFileChangeDetectAction(BASHSystemChanges.IGNORE);
                    break;
                }
                case 1: {
                    this.systemChanges.setHostFileChangeDetectAction(BASHSystemChanges.PROMPT);
                    break;
                }
                case 2: {
                    this.systemChanges.setHostFileChangeDetectAction(BASHSystemChanges.BLOCK);
                    break;
                }
                case 3: {
                    this.systemChanges.setHostFileChangeDetectAction(BASHSystemChanges.LOG);
                    break;
                }
            }
        }
    }

    public void setLockDNSChangeDetectAction(Boolean value) {
        if (value != null) {
            this.systemChanges.setOptLockDNSChangeDetectAction(value);
        }
    }

    public void setLockHostFileChangeDetectAction(Boolean value) {
        if (value != null) {
            this.systemChanges.setOptLockHostFileChangeDetectAction(value);
        }
    }

    public BASHSystemChanges getSchemaObject() {
        return this.systemChanges;
    }
}

