/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.BASHBPESettings;
import com.sygate.scm.common.configobject.schema.BASHConfidenceSettings;
import com.sygate.scm.common.configobject.schema.BASHHighConfidence;
import com.sygate.scm.common.configobject.schema.BASHLowConfidence;
import com.sygate.scm.common.configobject.schema.BASHNetworkSettings;
import com.sygate.scm.common.configobject.schema.BASHPolicy;
import com.sygate.scm.common.configobject.schema.BASHSystemChanges;
import com.sygate.scm.common.configobject.schema.HppNotifications;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.BASHBPESettingsObject;
import com.sygate.scm.console.logicobject.BASHConfidenceObject;
import com.sygate.scm.console.logicobject.BASHNetworkSettingsObject;
import com.sygate.scm.console.logicobject.BASHNotificationsObject;
import com.sygate.scm.console.logicobject.BASHSystemChangesObject;
import com.sygate.scm.util.BooleanWrapper;

public class BASHPolicyObject
extends AbstractUIObject {
    private BASHPolicy bashPolicy;
    private BASHConfidenceObject objConfidenceSettings;
    private BASHNotificationsObject objNotifications;
    private BASHSystemChangesObject objSystemChanges;
    private BASHBPESettingsObject objBPESettings;
    private BASHNetworkSettingsObject objNetworkSettings;

    public BASHPolicyObject() {
        this.bashPolicy = this.getDefaultBASHPolicy();
        this.objConfidenceSettings = new BASHConfidenceObject(this.bashPolicy.getOptBASHConfidenceSettings());
        this.objNotifications = new BASHNotificationsObject(this.bashPolicy.getOptHppNotifications());
        this.objSystemChanges = new BASHSystemChangesObject(this.bashPolicy.getOptBASHSystemChanges());
        this.objBPESettings = new BASHBPESettingsObject(this.bashPolicy.getOptBASHBPESettings());
        this.objNetworkSettings = new BASHNetworkSettingsObject(this.bashPolicy.getOptBASHNetworkSettings());
    }

    public BASHPolicyObject(BASHPolicy policy) {
        this.bashPolicy = policy != null ? policy : this.getDefaultBASHPolicy();
        this.objConfidenceSettings = new BASHConfidenceObject(this.bashPolicy.getOptBASHConfidenceSettings());
        this.objNotifications = new BASHNotificationsObject(this.bashPolicy.getOptHppNotifications());
        this.objSystemChanges = new BASHSystemChangesObject(this.bashPolicy.getOptBASHSystemChanges());
        this.objBPESettings = new BASHBPESettingsObject(this.bashPolicy.getOptBASHBPESettings());
        this.objNetworkSettings = new BASHNetworkSettingsObject(this.bashPolicy.getOptBASHNetworkSettings());
    }

    private BASHPolicy getDefaultBASHPolicy() {
        BASHPolicy policy = new BASHPolicy();
        policy.setOptEnabled(Boolean.TRUE);
        policy.setOptLocked(Boolean.TRUE);
        BASHConfidenceSettings confidence = new BASHConfidenceSettings();
        BASHHighConfidence highConfidence = new BASHHighConfidence();
        highConfidence.setOptLockHighConfidenceAction(highConfidence.getDefLockHighConfidenceAction());
        highConfidence.setHighConfidenceAction(highConfidence.getDefHighConfidenceAction());
        BASHLowConfidence lowConfidence = new BASHLowConfidence();
        lowConfidence.setLowConfidenceAction(lowConfidence.getDefLowConfidenceAction());
        lowConfidence.setOptLockLowConfidenceAction(lowConfidence.getDefLockLowConfidenceAction());
        lowConfidence.setOptEnableAggressiveMode(lowConfidence.getDefEnableAggressiveMode());
        lowConfidence.setOptLockAggressiveMode(lowConfidence.getDefLockAggressiveMode());
        confidence.setOptBASHHighConfidence(highConfidence);
        confidence.setOptBASHLowConfidence(lowConfidence);
        policy.setOptBASHConfidenceSettings(confidence);
        BASHSystemChanges systemChanges = new BASHSystemChanges();
        systemChanges.setDNSChangeDetectAction(systemChanges.getDefDNSChangeDetectAction());
        systemChanges.setOptLockDNSChangeDetectAction(systemChanges.getDefLockDNSChangeDetectAction());
        systemChanges.setHostFileChangeDetectAction(systemChanges.getDefHostFileChangeDetectAction());
        systemChanges.setOptLockHostFileChangeDetectAction(systemChanges.getDefLockHostFileChangeDetectAction());
        policy.setOptBASHSystemChanges(systemChanges);
        HppNotifications notifications = new HppNotifications();
        notifications.setDisplayAlert(notifications.getDefDisplayAlert());
        policy.setOptHppNotifications(notifications);
        BASHBPESettings bpe = new BASHBPESettings();
        bpe.setOptEnabled(Boolean.TRUE);
        bpe.setOptLocked(Boolean.TRUE);
        bpe.setHighConfidenceAction(bpe.getDefHighConfidenceAction());
        bpe.setOptLockHighConfidenceAction(bpe.getDefLockHighConfidenceAction());
        bpe.setLowConfidenceAction(bpe.getDefLowConfidenceAction());
        bpe.setOptLockLowConfidenceAction(bpe.getDefLockLowConfidenceAction());
        policy.setOptBASHBPESettings(bpe);
        BASHNetworkSettings networkSettings = new BASHNetworkSettings();
        networkSettings.setOptEnabled(networkSettings.getDefEnabled());
        networkSettings.setOptLockEnableNetworkFileMonitoring(networkSettings.getDefLockEnableNetworkFileMonitoring());
        networkSettings.setOptEnableNetworkFileMonitoring(networkSettings.getDefEnableNetworkFileMonitoring());
        policy.setOptBASHNetworkSettings(networkSettings);
        policy.setOptEnabled(policy.getDefEnabled());
        policy.setOptLocked(policy.getDefLocked());
        return policy;
    }

    public BASHConfidenceObject getConfidenceSettingsObject() {
        return this.objConfidenceSettings;
    }

    public void setConfidenceSettingsObject(BASHConfidenceObject confidenceSettings) {
        if (confidenceSettings != null) {
            this.objConfidenceSettings = confidenceSettings;
            this.bashPolicy.setOptBASHConfidenceSettings(confidenceSettings.getSchemaObject());
            BooleanWrapper bw = confidenceSettings.getLockedHighConfidenceAction();
            Boolean locked = this.objBPESettings.getSchemaObject().getDefLockHighConfidenceAction();
            if (bw != null && !bw.isNull()) {
                locked = bw.booleanValue();
            }
            this.objBPESettings.setLockHighConfidenceAction(locked);
            bw = confidenceSettings.getLockedLowConfidenceAction();
            locked = this.objBPESettings.getSchemaObject().getDefLockLowConfidenceAction();
            if (bw != null && !bw.isNull()) {
                locked = bw.booleanValue();
            }
            this.objBPESettings.setLockLowConfidenceAction(locked);
            switch (confidenceSettings.getHighConfidenceAction()) {
                case 0: {
                    this.objBPESettings.setHighConfidenceAction(BASHBPESettings.LOG);
                    break;
                }
                case 3: {
                    this.objBPESettings.setHighConfidenceAction(BASHBPESettings.IGNORE);
                    break;
                }
                default: {
                    this.objBPESettings.setHighConfidenceAction(BASHBPESettings.BLOCK);
                }
            }
            switch (confidenceSettings.getLowConfidenceAction()) {
                case 0: {
                    this.objBPESettings.setLowConfidenceAction(BASHBPESettings.LOG);
                    break;
                }
                case 3: {
                    this.objBPESettings.setLowConfidenceAction(BASHBPESettings.IGNORE);
                    break;
                }
                default: {
                    this.objBPESettings.setLowConfidenceAction(BASHBPESettings.BLOCK);
                }
            }
            this.bashPolicy.setOptBASHBPESettings(this.objBPESettings.getSchemaObject());
        }
    }

    public BASHSystemChangesObject getSystemChangesObject() {
        return this.objSystemChanges;
    }

    public void setSystemChangesObject(BASHSystemChangesObject systemChanges) {
        if (systemChanges != null) {
            this.objSystemChanges = systemChanges;
            this.bashPolicy.setOptBASHSystemChanges(systemChanges.getSchemaObject());
        }
    }

    public BASHBPESettingsObject getBPESettingsObject() {
        return this.objBPESettings;
    }

    public BASHNetworkSettingsObject getNetworkSettingsObject() {
        return this.objNetworkSettings;
    }

    public void setNetworkSettingsObject(BASHNetworkSettingsObject networkSettings) {
        if (networkSettings != null) {
            this.objNetworkSettings = networkSettings;
            this.bashPolicy.setOptBASHNetworkSettings(networkSettings.getSchemaObject());
        }
    }

    public BASHNotificationsObject getNotificationsObject() {
        return this.objNotifications;
    }

    public void setNotificationsObject(BASHNotificationsObject notifications) {
        if (notifications != null) {
            this.objNotifications = notifications;
            this.bashPolicy.setOptHppNotifications(notifications.getSchemaObject());
        }
    }

    public BASHPolicy getSchemaObject() {
        return this.bashPolicy;
    }

    public Boolean getEnabled() {
        return this.bashPolicy.getOptEnabled() != null ? this.bashPolicy.getOptEnabled() : this.bashPolicy.getDefEnabled();
    }

    public Boolean getLocked() {
        return this.bashPolicy.getOptLocked() != null ? this.bashPolicy.getOptLocked() : this.bashPolicy.getDefLocked();
    }

    public void setEnabled(Boolean value) {
        this.bashPolicy.setOptEnabled(value);
    }

    public void setLocked(Boolean value) {
        this.bashPolicy.setOptLocked(value);
    }
}

